/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.acearth.scanbit;

import com.ctreber.acearth.projection.Projection;
import com.ctreber.acearth.scanbit.BitGeneratorMap;
import com.ctreber.acearth.scanbit.ScanBuf;
import com.ctreber.acearth.util.EdgeCrossing;
import com.ctreber.acearth.util.Point2D;
import com.ctreber.acearth.util.Point3D;
import java.util.Comparator;

public class BitGeneratorMapDefault
extends BitGeneratorMap {
    public BitGeneratorMapDefault(Projection pProjection) {
        super(pProjection);
    }

    @Override
    protected Comparator getEdgeXingComparator() {
        return new EdgeXingComparator();
    }

    @Override
    protected ScanBuf scanOutline() {
        ScanBuf lScanBuf = new ScanBuf(this.fImageHeight, this.fImageWidth);
        double lLeft = this.fProjection.finalizeX(-Math.PI);
        double lRight = this.fProjection.finalizeX(Math.PI);
        double lTop = this.fProjection.finalizeY(1000000.0);
        double lBottom = this.fProjection.finalizeY(-1000000.0);
        lScanBuf.addLine(lRight, lTop, lLeft, lTop);
        lScanBuf.addLine(lLeft, lTop, lLeft, lBottom);
        lScanBuf.addLine(lLeft, lBottom, lRight, lBottom);
        lScanBuf.addLine(lRight, lBottom, lRight, lTop);
        return lScanBuf;
    }

    @Override
    protected void scanPolygon(ScanBuf pScanBuf, Point3D[] pPoints3D, Point2D[] pPoints2D, int pIndex) {
        int lAngle;
        double mx;
        Point2D lCurr = pPoints2D[pIndex];
        int lIndexPrev = pIndex - 1 >= 0 ? pIndex - 1 : pPoints2D.length - 1;
        Point2D lPrev = pPoints2D[lIndexPrev];
        double dx = lCurr.getX() - lPrev.getX();
        if (Math.abs(dx) <= Math.PI) {
            pScanBuf.addLine(this.fProjection.finalizeX(lPrev.getX()), this.fProjection.finalizeY(lPrev.getY()), this.fProjection.finalizeX(lCurr.getX()), this.fProjection.finalizeY(lCurr.getY()));
            return;
        }
        double my = this.getYMidPoint(pPoints3D[lIndexPrev], pPoints3D[pIndex]);
        if (dx > 0.0) {
            mx = -Math.PI;
            lAngle = 2;
        } else {
            mx = Math.PI;
            lAngle = 0;
        }
        pScanBuf.addLine(this.fProjection.finalizeX(lPrev.getX()), this.fProjection.finalizeY(lPrev.getY()), this.fProjection.finalizeX(mx), this.fProjection.finalizeY(my));
        this.addEdgeXing(new EdgeCrossing(1, pIndex, mx, my, lAngle));
        if (dx > 0.0) {
            mx = Math.PI;
            lAngle = 0;
        } else {
            mx = -Math.PI;
            lAngle = 2;
        }
        pScanBuf.addLine(this.fProjection.finalizeX(mx), this.fProjection.finalizeY(my), this.fProjection.finalizeX(lCurr.getX()), this.fProjection.finalizeY(lCurr.getY()));
        this.addEdgeXing(new EdgeCrossing(0, pIndex, mx, my, lAngle));
    }

    private double getYMidPoint(Point3D pPrev, Point3D pCurr) {
        double lZ;
        double lY;
        if (pCurr.getX() != 0.0) {
            double ratio = pPrev.getX() / pCurr.getX();
            lY = pPrev.getY() - ratio * pCurr.getY();
            lZ = pPrev.getZ() - ratio * pCurr.getZ();
        } else {
            lY = pCurr.getY();
            lZ = pCurr.getZ();
        }
        double lDistance = Math.sqrt(lY * lY + lZ * lZ);
        return this.fProjection.projectY(lY *= (double)(lZ > 0.0 ? -1 : 1) / lDistance);
    }

    @Override
    protected void handleCrossings(ScanBuf pScanBuf, EdgeCrossing[] xings) {
        EdgeCrossing to;
        EdgeCrossing from;
        int lStart;
        if (xings[0].getType() == 1) {
            lStart = 0;
        } else {
            from = xings[xings.length - 1];
            to = xings[0];
            this.addEdgeToScanbuf(pScanBuf, from, to);
            lStart = 1;
        }
        for (int i = lStart; i < xings.length - 1; i += 2) {
            from = xings[i];
            to = xings[i + 1];
            this.addEdgeToScanbuf(pScanBuf, from, to);
        }
    }

    private void addEdgeToScanbuf(ScanBuf pScanBuf, EdgeCrossing from, EdgeCrossing to) {
        int lAngleFrom = (int)from.getAngle();
        double lXFrom = this.fProjection.finalizeX(from.getX());
        double lYFrom = this.fProjection.finalizeY(from.getY());
        while (lAngleFrom != (int)to.getAngle()) {
            int lAngleNew = 0;
            double lXNew = 0.0;
            double lYNew = 0.0;
            switch (lAngleFrom) {
                case 0: {
                    lXNew = this.fProjection.finalizeX(Math.PI);
                    lYNew = this.fProjection.finalizeY(1000000.0);
                    lAngleNew = 1;
                    break;
                }
                case 1: {
                    lXNew = this.fProjection.finalizeX(-Math.PI);
                    lYNew = this.fProjection.finalizeY(1000000.0);
                    lAngleNew = 2;
                    break;
                }
                case 2: {
                    lXNew = this.fProjection.finalizeX(-Math.PI);
                    lYNew = this.fProjection.finalizeY(-1000000.0);
                    lAngleNew = 3;
                    break;
                }
                case 3: {
                    lXNew = this.fProjection.finalizeX(Math.PI);
                    lYNew = this.fProjection.finalizeY(-1000000.0);
                    lAngleNew = 0;
                }
            }
            pScanBuf.addLine(lXFrom, lYFrom, lXNew, lYNew);
            lAngleFrom = lAngleNew;
            lXFrom = lXNew;
            lYFrom = lYNew;
        }
        pScanBuf.addLine(lXFrom, lYFrom, this.fProjection.finalizeX(to.getX()), this.fProjection.finalizeY(to.getY()));
    }

    private static class EdgeXingComparator
    implements Comparator {
        private EdgeXingComparator() {
        }

        public int compare(Object o1, Object o2) {
            EdgeCrossing a = (EdgeCrossing)o1;
            EdgeCrossing b = (EdgeCrossing)o2;
            if (a.getAngle() < b.getAngle()) {
                return -1;
            }
            if (a.getAngle() > b.getAngle()) {
                return 1;
            }
            if (a.getAngle() == 0.0) {
                return a.getY() < b.getY() ? -1 : (a.getY() > b.getY() ? 1 : 0);
            }
            if (a.getAngle() == 2.0) {
                return a.getY() > b.getY() ? -1 : (a.getY() < b.getY() ? 1 : 0);
            }
            throw new RuntimeException("No result");
        }
    }
}

