/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.acearth.scanbit;

import com.ctreber.acearth.projection.Projection;
import com.ctreber.acearth.scanbit.BitGeneratorMap;
import com.ctreber.acearth.scanbit.ScanBuf;
import com.ctreber.acearth.util.EdgeCrossing;
import com.ctreber.acearth.util.Point2D;
import com.ctreber.acearth.util.Point3D;
import java.util.Comparator;

public class BitGeneratorMapOrtho
extends BitGeneratorMap {
    public BitGeneratorMapOrtho(Projection pProjection) {
        super(pProjection);
    }

    @Override
    protected Comparator getEdgeXingComparator() {
        return new EdgeCrossingComparator();
    }

    @Override
    protected ScanBuf scanOutline() {
        ScanBuf lScanBuf = new ScanBuf(this.fImageHeight, this.fImageWidth);
        this.addArcToScanbuf(lScanBuf, 1.0, 0.0, 0.0, 1.0, 0.0, Math.PI * 2);
        return lScanBuf;
    }

    private void addArcToScanbuf(ScanBuf pScanBuf, double pXFrom, double pYFrom, double pAngleFrom, double pXTo, double pYTo, double pAngleTo) {
        double curr_y;
        double curr_x;
        double step = 1.0 / this.fProjection.getScale() * 10.0;
        if (step > 0.05) {
            step = 0.05;
        }
        int lAngleFrom = (int)Math.ceil(pAngleFrom / step);
        int lAngleTo = (int)Math.floor(pAngleTo / step);
        double prev_x = this.fProjection.finalizeX(pXFrom);
        double prev_y = this.fProjection.finalizeY(pYFrom);
        if (lAngleFrom <= lAngleTo) {
            double c_step = Math.cos(step);
            double s_step = Math.sin(step);
            double angle = (double)lAngleFrom * step;
            double arc_x = Math.cos(angle);
            double arc_y = Math.sin(angle);
            for (int i = lAngleFrom; i <= lAngleTo; ++i) {
                curr_x = this.fProjection.finalizeX(arc_x);
                curr_y = this.fProjection.finalizeY(arc_y);
                pScanBuf.addLine(prev_x, prev_y, curr_x, curr_y);
                double tmp = c_step * arc_x - s_step * arc_y;
                arc_y = s_step * arc_x + c_step * arc_y;
                arc_x = tmp;
                prev_x = curr_x;
                prev_y = curr_y;
            }
        }
        curr_x = this.fProjection.finalizeX(pXTo);
        curr_y = this.fProjection.finalizeY(pYTo);
        pScanBuf.addLine(prev_x, prev_y, curr_x, curr_y);
    }

    @Override
    protected void scanPolygon(ScanBuf pScanBuf, Point3D[] pPoints3D, Point2D[] pPoints2D, int pIndex) {
        Point3D lCurr = pPoints3D[pIndex];
        int lIndexPrev = pIndex - 1 >= 0 ? pIndex - 1 : pPoints2D.length - 1;
        Point3D lPrev = pPoints3D[lIndexPrev];
        if (lPrev.getZ() <= 0.0) {
            if (lCurr.getZ() <= 0.0) {
                return;
            }
            Point3D extra = this.findEdgeCrossing(lPrev, lCurr);
            this.addEdgeXing(new EdgeCrossing(0, pIndex, extra.getX(), extra.getY(), Math.atan2(extra.getY(), extra.getX())));
            lPrev = extra;
        } else if (lCurr.getZ() <= 0.0) {
            Point3D extra = this.findEdgeCrossing(lPrev, lCurr);
            this.addEdgeXing(new EdgeCrossing(1, pIndex, extra.getX(), extra.getY(), Math.atan2(extra.getY(), extra.getX())));
            lCurr = extra;
        }
        pScanBuf.addLine(this.fProjection.finalizeX(lPrev.getX()), this.fProjection.finalizeY(lPrev.getY()), this.fProjection.finalizeX(lCurr.getX()), this.fProjection.finalizeY(lCurr.getY()));
    }

    private Point3D findEdgeCrossing(Point3D pPrev, Point3D pCurr) {
        double tmp = pCurr.getZ() / (pCurr.getZ() - pPrev.getZ());
        double r0 = pCurr.getX() - tmp * (pCurr.getX() - pPrev.getX());
        double r1 = pCurr.getY() - tmp * (pCurr.getY() - pPrev.getY());
        tmp = Math.sqrt(r0 * r0 + r1 * r1);
        return new Point3D(r0 / tmp, r1 / tmp, 0.0);
    }

    @Override
    protected void handleCrossings(ScanBuf pScanBuf, EdgeCrossing[] xings) {
        EdgeCrossing to;
        EdgeCrossing from;
        int lStart;
        if (xings[0].getType() == 1) {
            lStart = 0;
        } else {
            from = xings[xings.length - 1];
            to = xings[0];
            this.addArcToScanbuf(pScanBuf, from.getX(), from.getY(), from.getAngle(), to.getX(), to.getY(), to.getAngle() + Math.PI * 2);
            lStart = 1;
        }
        for (int i = lStart; i < xings.length - 1; i += 2) {
            from = xings[i];
            to = xings[i + 1];
            this.addArcToScanbuf(pScanBuf, from.getX(), from.getY(), from.getAngle(), to.getX(), to.getY(), to.getAngle());
        }
    }

    private static class EdgeCrossingComparator
    implements Comparator {
        private EdgeCrossingComparator() {
        }

        public int compare(Object o1, Object o2) {
            EdgeCrossing a = (EdgeCrossing)o1;
            EdgeCrossing b = (EdgeCrossing)o2;
            return a.getAngle() < b.getAngle() ? -1 : (a.getAngle() > b.getAngle() ? 1 : 0);
        }
    }
}

