/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.hector.HectorPath;
import net.sourceforge.plantuml.hector.Pin;
import net.sourceforge.plantuml.hector.PinFactory;
import net.sourceforge.plantuml.hector.PinLink;
import net.sourceforge.plantuml.hector.Skeleton;
import net.sourceforge.plantuml.hector.SkeletonBuilder;
import net.sourceforge.plantuml.hector.SkeletonConfiguration;
import net.sourceforge.plantuml.hector.SkeletonConfigurationUtils;
import net.sourceforge.plantuml.hector.UnlinarCompressedPlan;
import net.sourceforge.plantuml.hector.UnlinearCompression;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CucaDiagramFileMakerHectorB2
implements CucaDiagramFileMaker {
    private final CucaDiagram diagram;
    private SkeletonConfiguration configuration;
    private double singleWidth;
    private double singleHeight;
    private double nodeDistanceX = 30.0;
    private double nodeDistanceY = 50.0;
    private UnlinarCompressedPlan unlinarCompressedPlan;
    private final Map<Pin, IEntityImage> images = new LinkedHashMap<Pin, IEntityImage>();
    private final Map<Link, PinLink> links = new LinkedHashMap<Link, PinLink>();

    public CucaDiagramFileMakerHectorB2(CucaDiagram diagram) {
        this.diagram = diagram;
    }

    private double getX(Pin pin) {
        return this.nodeDistanceX * (double)this.configuration.getCol(pin);
    }

    private double getY(Pin pin) {
        return this.nodeDistanceY * (double)pin.getRow();
    }

    private Point2D getPoint(Pin pin) {
        return new Point2D.Double(this.getX(pin), this.getY(pin));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImageData createFile(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException {
        void var7_10;
        PinFactory pinFactory = new PinFactory();
        SkeletonBuilder skeletonBuilder = new SkeletonBuilder();
        this.links.clear();
        for (Link link : this.diagram.getLinks()) {
            PinLink pinLink = pinFactory.createPinLink(link);
            this.links.put(link, pinLink);
            skeletonBuilder.add(pinLink);
        }
        Skeleton skeleton = skeletonBuilder.createSkeletons().get(0);
        this.configuration = SkeletonConfigurationUtils.getBest(skeleton);
        this.singleWidth = 0.0;
        this.singleHeight = 0.0;
        this.images.clear();
        for (Pin pin : skeleton.getPins()) {
            ILeaf leaf = (ILeaf)pin.getUserData();
            IEntityImage image = this.computeImage(leaf);
            Dimension2D dim = TextBlockUtils.getDimension(image);
            if (dim.getWidth() > this.singleWidth) {
                this.singleWidth = dim.getWidth();
            }
            if (dim.getHeight() > this.singleHeight) {
                this.singleHeight = dim.getHeight();
            }
            this.images.put(pin, image);
        }
        this.unlinarCompressedPlan = new UnlinarCompressedPlan(this.singleWidth, this.nodeDistanceX, this.singleHeight, this.nodeDistanceY);
        MinMax minMax = MinMax.getEmpty(false);
        for (Pin pin : skeleton.getPins()) {
            MinMax minMax2 = var7_10.addPoint(this.unlinarCompressedPlan.uncompress(this.getX(pin), this.getY(pin), UnlinearCompression.Rounding.BORDER_2));
        }
        double d = 10.0;
        Dimension2DDouble dimTotal = new Dimension2DDouble(20.0 + var7_10.getMaxX(), 20.0 + var7_10.getMaxY());
        UGraphic ug = null;
        ug = (UGraphic2)ug.apply(new UTranslate(10.0, 10.0));
        for (PinLink pinLink : skeleton.getPinLinks()) {
            this.drawPinLink(ug, pinLink);
        }
        for (Pin pin : skeleton.getPins()) {
            this.drawPin(ug, pin);
        }
        throw new UnsupportedOperationException();
    }

    private void drawPin(UGraphic ug, Pin pin) {
        Point2D pt = this.unlinarCompressedPlan.uncompress(this.getPoint(pin), UnlinearCompression.Rounding.BORDER_1);
        double x = pt.getX();
        double y = pt.getY();
        URectangle rect = new URectangle(this.unlinarCompressedPlan.getInnerX(), this.unlinarCompressedPlan.getInnerY());
        ug.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UChangeBackColor(HtmlColorUtils.BLACK)).apply(new UTranslate(x, y)).draw(rect);
    }

    private void drawPinLink(UGraphic ug, PinLink pinLink) {
        Point2D pp1 = this.getPoint(pinLink.getPin1());
        Point2D pp2 = this.getPoint(pinLink.getPin2());
        Rose rose = new Rose();
        HtmlColor color = rose.getHtmlColor(this.diagram.getSkinParam(), ColorParam.classArrow);
        HectorPath path = this.unlinarCompressedPlan.uncompressSegment(pp1, pp2);
        path.draw(ug, color);
    }

    private IEntityImage computeImage(ILeaf leaf) {
        IEntityImage image = CucaDiagramFileMakerSvek2.createEntityImageBlock(leaf, this.diagram.getSkinParam(), false, this.diagram, null, null, null);
        return image;
    }
}

