/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.IfManagerNegatif;
import net.sourceforge.plantuml.preproc.IfManagerPositif;
import net.sourceforge.plantuml.preproc.ReadLine;

class IfManager
implements ReadLine {
    protected static final Pattern ifdefPattern = MyPattern.cmpile("^[%s]*!if(n)?def[%s]+([A-Za-z_][A-Za-z_0-9]*)$");
    protected static final Pattern elsePattern = MyPattern.cmpile("^[%s]*!else$");
    protected static final Pattern endifPattern = MyPattern.cmpile("^[%s]*!endif$");
    private final Defines defines;
    private final ReadLine source;
    private IfManager child;

    public IfManager(ReadLine source, Defines defines) {
        this.defines = defines;
        this.source = source;
    }

    @Override
    public final CharSequence2 readLine() throws IOException {
        if (this.child != null) {
            CharSequence2 s = this.child.readLine();
            if (s != null) {
                return s;
            }
            this.child = null;
        }
        return this.readLineInternal();
    }

    protected CharSequence2 readLineInternal() throws IOException {
        CharSequence2 s = this.source.readLine();
        if (s == null) {
            return null;
        }
        Matcher m = ifdefPattern.matcher(s);
        if (m.find()) {
            boolean ok = this.defines.isDefine(m.group(2));
            if (m.group(1) != null) {
                ok = !ok;
            }
            this.child = ok ? new IfManagerPositif(this.source, this.defines) : new IfManagerNegatif(this.source, this.defines);
            return this.readLine();
        }
        return s;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }
}

