/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.DataSourceImpl;
import net.sourceforge.plantuml.salt.Dictionary;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.factory.AbstractElementFactoryComplex;
import net.sourceforge.plantuml.salt.factory.ElementFactory;
import net.sourceforge.plantuml.salt.factory.ElementFactoryBorder;
import net.sourceforge.plantuml.salt.factory.ElementFactoryButton;
import net.sourceforge.plantuml.salt.factory.ElementFactoryCheckboxOff;
import net.sourceforge.plantuml.salt.factory.ElementFactoryCheckboxOn;
import net.sourceforge.plantuml.salt.factory.ElementFactoryDroplist;
import net.sourceforge.plantuml.salt.factory.ElementFactoryImage;
import net.sourceforge.plantuml.salt.factory.ElementFactoryLine;
import net.sourceforge.plantuml.salt.factory.ElementFactoryMenu;
import net.sourceforge.plantuml.salt.factory.ElementFactoryPyramid;
import net.sourceforge.plantuml.salt.factory.ElementFactoryRadioOff;
import net.sourceforge.plantuml.salt.factory.ElementFactoryRadioOn;
import net.sourceforge.plantuml.salt.factory.ElementFactoryRetrieveFromDictonnary;
import net.sourceforge.plantuml.salt.factory.ElementFactoryTab;
import net.sourceforge.plantuml.salt.factory.ElementFactoryText;
import net.sourceforge.plantuml.salt.factory.ElementFactoryTextField;
import net.sourceforge.plantuml.salt.factory.ElementFactoryTree;

public class SaltUtils {
    public static Element createElement(List<String> data) {
        DataSourceImpl source = new DataSourceImpl(data);
        ArrayList<AbstractElementFactoryComplex> cpx = new ArrayList<AbstractElementFactoryComplex>();
        Dictionary dictionnary = new Dictionary();
        cpx.add(new ElementFactoryPyramid(source, dictionnary));
        cpx.add(new ElementFactoryBorder(source, dictionnary));
        for (AbstractElementFactoryComplex abstractElementFactoryComplex : cpx) {
            SaltUtils.addSimpleFactory(abstractElementFactoryComplex, source, dictionnary);
        }
        for (AbstractElementFactoryComplex abstractElementFactoryComplex : cpx) {
            for (AbstractElementFactoryComplex f2 : cpx) {
                abstractElementFactoryComplex.addFactory(f2);
            }
        }
        for (ElementFactory elementFactory : cpx) {
            if (!elementFactory.ready()) continue;
            Log.info("Using " + elementFactory);
            return elementFactory.create().getElement();
        }
        Log.println("data=" + data);
        throw new IllegalArgumentException();
    }

    private static void addSimpleFactory(AbstractElementFactoryComplex cpxFactory, DataSource source, Dictionary dictionnary) {
        cpxFactory.addFactory(new ElementFactoryMenu(source, dictionnary));
        cpxFactory.addFactory(new ElementFactoryTree(source, dictionnary));
        cpxFactory.addFactory(new ElementFactoryTab(source, dictionnary));
        cpxFactory.addFactory(new ElementFactoryLine(source));
        cpxFactory.addFactory(new ElementFactoryTextField(source, dictionnary));
        cpxFactory.addFactory(new ElementFactoryButton(source, dictionnary));
        cpxFactory.addFactory(new ElementFactoryDroplist(source, dictionnary));
        cpxFactory.addFactory(new ElementFactoryRadioOn(source, dictionnary));
        cpxFactory.addFactory(new ElementFactoryRadioOff(source, dictionnary));
        cpxFactory.addFactory(new ElementFactoryCheckboxOn(source, dictionnary));
        cpxFactory.addFactory(new ElementFactoryCheckboxOff(source, dictionnary));
        cpxFactory.addFactory(new ElementFactoryImage(source, dictionnary));
        cpxFactory.addFactory(new ElementFactoryRetrieveFromDictonnary(source, dictionnary));
        cpxFactory.addFactory(new ElementFactoryText(source, dictionnary));
    }
}

