/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public final class RoundedContainer {
    private final Dimension2D dim;
    private final double titleHeight;
    private final double attributeHeight;
    private final HtmlColor borderColor;
    private final HtmlColor backColor;
    private final HtmlColor imgBackcolor;
    private final UStroke stroke;

    public RoundedContainer(Dimension2D dim, double titleHeight, double attributeHeight, HtmlColor borderColor, HtmlColor backColor, HtmlColor imgBackcolor, UStroke stroke) {
        this.dim = dim;
        this.imgBackcolor = imgBackcolor;
        this.titleHeight = titleHeight;
        this.borderColor = borderColor;
        this.backColor = backColor;
        this.attributeHeight = attributeHeight;
        this.stroke = stroke;
    }

    public void drawU(UGraphic ug, boolean shadowing) {
        ug = ug.apply(new UChangeBackColor(this.backColor)).apply(new UChangeColor(this.borderColor));
        URectangle rect = new URectangle(this.dim.getWidth(), this.dim.getHeight(), 25.0, 25.0);
        if (shadowing) {
            rect.setDeltaShadow(3.0);
        }
        ug.apply(this.stroke).draw(rect);
        double yLine = this.titleHeight + this.attributeHeight;
        ug = ug.apply(new UChangeBackColor(this.imgBackcolor));
        double thickness = this.stroke.getThickness();
        URectangle inner = new URectangle(this.dim.getWidth() - 4.0 * thickness, this.dim.getHeight() - this.titleHeight - 4.0 * thickness - this.attributeHeight, 25.0, 25.0);
        ug.apply(new UChangeColor(this.imgBackcolor)).apply(new UTranslate(2.0 * thickness, yLine + 2.0 * thickness)).draw(inner);
        if (this.titleHeight > 0.0) {
            ug.apply(this.stroke).apply(new UTranslate(0.0, yLine)).draw(new ULine(this.dim.getWidth(), 0.0));
        }
        if (this.attributeHeight > 0.0) {
            ug.apply(this.stroke).apply(new UTranslate(0.0, yLine - this.attributeHeight)).draw(new ULine(this.dim.getWidth(), 0.0));
        }
    }
}

