/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.AlignParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DotSplines;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizLayoutStrategy;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ColorMapperMonochrome;
import net.sourceforge.plantuml.ugraphic.Sprite;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class SkinParam
implements ISkinParam {
    private final Map<String, String> params = new HashMap<String, String>();
    private Rankdir rankdir = Rankdir.TOP_TO_BOTTOM;
    private static final String stereoPatternString = "\\<\\<(.*?)\\>\\>";
    private static final Pattern stereoPattern = MyPattern.cmpile("\\<\\<(.*?)\\>\\>");
    private final Map<String, Sprite> sprites = new HashMap<String, Sprite>();
    private final IHtmlColorSet htmlColorSet = new HtmlColorSetSimple();

    public void setParam(String key, String value) {
        this.params.put(SkinParam.cleanForKey(key), StringUtils.trin(value));
    }

    public static SkinParam noShadowing() {
        SkinParam result = new SkinParam();
        result.setParam("shadowing", "false");
        return result;
    }

    static String cleanForKey(String key) {
        Matcher m;
        key = StringUtils.trin(StringUtils.goLowerCase(key));
        key = key.replaceAll("_|\\.|\\s", "");
        key = SkinParam.replaceSmart(key, "partition", "package");
        key = SkinParam.replaceSmart(key, "sequenceparticipant", "participant");
        if ((key = SkinParam.replaceSmart(key, "sequenceactor", "actor")).contains("arrow")) {
            key = key.replaceAll("activityarrow|objectarrow|classarrow|componentarrow|statearrow|usecasearrow", "genericarrow");
        }
        if ((m = stereoPattern.matcher(key)).find()) {
            String s = m.group(1);
            key = key.replaceAll(stereoPatternString, "");
            key = key + "<<" + s + ">>";
        }
        return key;
    }

    private static String replaceSmart(String s, String src, String target) {
        if (!s.contains(src)) {
            return s;
        }
        return s.replaceAll(src, target);
    }

    @Override
    public HtmlColor getHyperlinkColor() {
        HtmlColor result = this.getHtmlColor(ColorParam.hyperlink, null, false);
        if (result == null) {
            return HtmlColorUtils.BLUE;
        }
        return result;
    }

    @Override
    public HtmlColor getBackgroundColor() {
        HtmlColor result = this.getHtmlColor(ColorParam.background, null, false);
        if (result == null) {
            return HtmlColorUtils.WHITE;
        }
        return result;
    }

    @Override
    public String getValue(String key) {
        return this.params.get(SkinParam.cleanForKey(key));
    }

    static String humanName(String key) {
        StringBuilder sb = new StringBuilder();
        boolean upper = true;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c == '_') {
                upper = true;
                continue;
            }
            sb.append(upper ? StringUtils.goUpperCase(c) : StringUtils.goLowerCase(c));
            upper = false;
        }
        return sb.toString();
    }

    @Override
    public HtmlColor getHtmlColor(ColorParam param, Stereotype stereotype, boolean clickable) {
        boolean acceptTransparent;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            String value2 = this.getValue(param.name() + "color" + stereotype.getLabel(false));
            if (value2 != null && this.getIHtmlColorSet().getColorIfValid(value2) != null) {
                return this.getIHtmlColorSet().getColorIfValid(value2);
            }
        }
        String value = this.getValue(this.getParamName(param, clickable));
        boolean bl = acceptTransparent = param == ColorParam.background;
        if (value == null) {
            return null;
        }
        return this.getIHtmlColorSet().getColorIfValid(value, acceptTransparent);
    }

    private String getParamName(ColorParam param, boolean clickable) {
        String n = param.name();
        if (clickable && n.endsWith("Background")) {
            n = n.replaceAll("Background", "ClickableBackground");
        } else if (clickable && n.endsWith("Border")) {
            n = n.replaceAll("Border", "ClickableBorder");
        }
        return n + "color";
    }

    private void checkStereotype(Stereotype stereotype) {
    }

    private int getFontSize(FontParam param, Stereotype stereotype) {
        String value;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            String value2 = this.getValue(param.name() + "fontsize" + stereotype.getLabel(false));
            if (value2 != null && value2.matches("\\d+")) {
                return Integer.parseInt(value2);
            }
        }
        if ((value = this.getValue(param.name() + "fontsize")) == null || !value.matches("\\d+")) {
            value = this.getValue("defaultfontsize");
        }
        if (value == null || !value.matches("\\d+")) {
            return param.getDefaultSize(this);
        }
        return Integer.parseInt(value);
    }

    private String getFontFamily(FontParam param, Stereotype stereotype) {
        String value;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            String value2 = this.getValue(param.name() + "fontname" + stereotype.getLabel(false));
            if (value2 != null) {
                return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(value2);
            }
        }
        if ((value = this.getValue(param.name() + "fontname")) != null) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(value);
        }
        if (param != FontParam.CIRCLED_CHARACTER && (value = this.getValue("defaultfontname")) != null) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(value);
        }
        return param.getDefaultFamily();
    }

    @Override
    public HtmlColor getFontHtmlColor(FontParam param, Stereotype stereotype) {
        String value = null;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            value = this.getValue(param.name() + "fontcolor" + stereotype.getLabel(false));
        }
        if (value == null || this.getIHtmlColorSet().getColorIfValid(value) == null) {
            value = this.getValue(param.name() + "fontcolor");
        }
        if (value == null || this.getIHtmlColorSet().getColorIfValid(value) == null) {
            value = this.getValue("defaultfontcolor");
        }
        if (value == null || this.getIHtmlColorSet().getColorIfValid(value) == null) {
            value = param.getDefaultColor();
        }
        return this.getIHtmlColorSet().getColorIfValid(value);
    }

    private int getFontStyle(FontParam param, Stereotype stereotype, boolean inPackageTitle) {
        String value = null;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            value = this.getValue(param.name() + "fontstyle" + stereotype.getLabel(false));
        }
        if (value == null) {
            value = this.getValue(param.name() + "fontstyle");
        }
        if (value == null) {
            value = this.getValue("defaultfontstyle");
        }
        if (value == null) {
            return param.getDefaultFontStyle(this, inPackageTitle);
        }
        int result = 0;
        if (StringUtils.goLowerCase(value).contains("bold")) {
            result |= 1;
        }
        if (StringUtils.goLowerCase(value).contains("italic")) {
            result |= 2;
        }
        return result;
    }

    @Override
    public UFont getFont(FontParam fontParam, Stereotype stereotype, boolean inPackageTitle) {
        if (stereotype != null) {
            this.checkStereotype(stereotype);
        }
        String fontFamily = this.getFontFamily(fontParam, stereotype);
        int fontStyle = this.getFontStyle(fontParam, stereotype, inPackageTitle);
        int fontSize = this.getFontSize(fontParam, stereotype);
        return new UFont(fontFamily, fontStyle, fontSize);
    }

    @Override
    public int getCircledCharacterRadius() {
        String value = this.getValue("circledcharacterradius");
        if (value != null && value.matches("\\d+")) {
            return Integer.parseInt(value);
        }
        return this.getFontSize(FontParam.CIRCLED_CHARACTER, null) / 3 + 6;
    }

    @Override
    public int classAttributeIconSize() {
        String value = this.getValue("classAttributeIconSize");
        if (value != null && value.matches("\\d+")) {
            return Integer.parseInt(value);
        }
        return 10;
    }

    private boolean isMonochrome() {
        return "true".equals(this.getValue("monochrome"));
    }

    public static Collection<String> getPossibleValues() {
        String h;
        TreeSet<String> result = new TreeSet<String>();
        result.add("Monochrome");
        result.add("CircledCharacterRadius");
        result.add("ClassAttributeIconSize");
        result.add("DefaultFontName");
        result.add("DefaultFontStyle");
        result.add("DefaultFontSize");
        result.add("DefaultFontColor");
        for (FontParam fontParam : EnumSet.allOf(FontParam.class)) {
            h = SkinParam.humanName(fontParam.name());
            result.add(h + "FontStyle");
            result.add(h + "FontName");
            result.add(h + "FontSize");
            result.add(h + "FontColor");
        }
        for (ColorParam colorParam : EnumSet.allOf(ColorParam.class)) {
            h = SkinParam.capitalize(colorParam.name());
            result.add(h + "Color");
        }
        for (LineParam lineParam : EnumSet.allOf(LineParam.class)) {
            h = SkinParam.capitalize(lineParam.name());
            result.add(h + "Thickness");
        }
        return Collections.unmodifiableSet(result);
    }

    private static String capitalize(String name) {
        return StringUtils.goUpperCase(name.substring(0, 1)) + name.substring(1);
    }

    @Override
    public int getDpi() {
        String value = this.getValue("dpi");
        if (value != null && value.matches("\\d+")) {
            return Integer.parseInt(value);
        }
        return 96;
    }

    @Override
    public DotSplines getDotSplines() {
        String value = this.getValue("linetype");
        if ("polyline".equalsIgnoreCase(value)) {
            return DotSplines.POLYLINE;
        }
        if ("ortho".equalsIgnoreCase(value)) {
            return DotSplines.ORTHO;
        }
        return DotSplines.SPLINES;
    }

    @Override
    public GraphvizLayoutStrategy getStrategy() {
        String value = this.getValue("layout");
        if ("neato".equalsIgnoreCase(value)) {
            return GraphvizLayoutStrategy.NEATO;
        }
        if ("circo".equalsIgnoreCase(value)) {
            return GraphvizLayoutStrategy.CIRCO;
        }
        if ("fdp".equalsIgnoreCase(value)) {
            return GraphvizLayoutStrategy.FDP;
        }
        if ("twopi".equalsIgnoreCase(value)) {
            return GraphvizLayoutStrategy.TWOPI;
        }
        return GraphvizLayoutStrategy.DOT;
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment(AlignParam param) {
        String value;
        switch (param) {
            case SEQUENCE_MESSAGE_ALIGN: {
                value = this.getArg(this.getValue(AlignParam.SEQUENCE_MESSAGE_ALIGN.name()), 0);
                break;
            }
            case SEQUENCE_MESSAGETEXT_ALIGN: {
                value = this.getArg(this.getValue(AlignParam.SEQUENCE_MESSAGE_ALIGN.name()), 1);
                break;
            }
            default: {
                value = this.getValue(param.name());
            }
        }
        HorizontalAlignment result = HorizontalAlignment.fromString(value);
        if (result == null) {
            return param.getDefaultValue();
        }
        return result;
    }

    @Override
    public HorizontalAlignment getDefaultTextAlignment() {
        String value = this.getValue("defaulttextalignment");
        HorizontalAlignment result = HorizontalAlignment.fromString(value);
        if (result == null) {
            return HorizontalAlignment.CENTER;
        }
        return result;
    }

    private String getArg(String value, int i) {
        if (value == null) {
            return null;
        }
        String[] split = value.split(":");
        if (i >= split.length) {
            return split[0];
        }
        return split[i];
    }

    @Override
    public ColorMapper getColorMapper() {
        if (this.isMonochrome()) {
            return new ColorMapperMonochrome();
        }
        return new ColorMapperIdentity();
    }

    @Override
    public boolean shadowing() {
        String value = this.getValue("shadowing");
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        return !this.strictUmlStyle();
    }

    @Override
    public boolean shadowing2(SkinParameter skinParameter) {
        if (skinParameter == null) {
            throw new IllegalArgumentException();
        }
        String name = skinParameter.getUpperCaseName();
        String value = this.getValue(name + "shadowing");
        if (value == null) {
            return this.shadowing();
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        return !this.strictUmlStyle();
    }

    @Override
    public PackageStyle getPackageStyle() {
        String value = this.getValue("packageStyle");
        PackageStyle p = PackageStyle.fromString(value);
        if (p == null) {
            return PackageStyle.FOLDER;
        }
        return p;
    }

    public void addSprite(String name, Sprite sprite) {
        this.sprites.put(name, sprite);
    }

    @Override
    public Sprite getSprite(String name) {
        return this.sprites.get(name);
    }

    @Override
    public boolean useUml2ForComponent() {
        if (this.strictUmlStyle()) {
            return true;
        }
        String value = this.getValue("componentstyle");
        return "uml2".equalsIgnoreCase(value);
    }

    @Override
    public boolean stereotypePositionTop() {
        String value = this.getValue("stereotypePosition");
        return !"bottom".equalsIgnoreCase(value);
    }

    @Override
    public boolean useSwimlanes(UmlDiagramType type) {
        if (type != UmlDiagramType.ACTIVITY) {
            return false;
        }
        if ("true".equalsIgnoreCase(this.getValue("swimlane"))) {
            return true;
        }
        return "true".equalsIgnoreCase(this.getValue("swimlanes"));
    }

    @Override
    public double getNodesep() {
        String value = this.getValue("nodesep");
        if (value != null && value.matches("\\d+")) {
            return Double.parseDouble(value);
        }
        return 0.0;
    }

    @Override
    public double getRanksep() {
        String value = this.getValue("ranksep");
        if (value != null && value.matches("\\d+")) {
            return Double.parseDouble(value);
        }
        return 0.0;
    }

    @Override
    public double getRoundCorner() {
        String value = this.getValue("roundcorner");
        if (value != null && value.matches("\\d+")) {
            return Double.parseDouble(value);
        }
        return 0.0;
    }

    @Override
    public UStroke getThickness(LineParam param, Stereotype stereotype) {
        String value;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            String value2 = this.getValue(param.name() + "thickness" + stereotype.getLabel(false));
            if (value2 != null && value2.matches("[\\d.]+")) {
                return new UStroke(Double.parseDouble(value2));
            }
        }
        if ((value = this.getValue(param.name() + "thickness")) != null && value.matches("[\\d.]+")) {
            return new UStroke(Double.parseDouble(value));
        }
        return null;
    }

    @Override
    public double maxMessageSize() {
        String value = this.getValue("maxmessagesize");
        if (value != null && value.matches("-?\\d+")) {
            return Double.parseDouble(value);
        }
        return 0.0;
    }

    @Override
    public boolean strictUmlStyle() {
        String value = this.getValue("style");
        return "strictuml".equalsIgnoreCase(value);
    }

    @Override
    public boolean forceSequenceParticipantUnderlined() {
        String value = this.getValue("sequenceParticipant");
        return "underline".equalsIgnoreCase(value);
    }

    @Override
    public ConditionStyle getConditionStyle() {
        String value = this.getValue("conditionStyle");
        ConditionStyle p = ConditionStyle.fromString(value);
        if (p == null) {
            return ConditionStyle.INSIDE;
        }
        return p;
    }

    @Override
    public double minClassWidth() {
        String value = this.getValue("minclasswidth");
        if (value != null && value.matches("\\d+")) {
            return Integer.parseInt(value);
        }
        return 0.0;
    }

    @Override
    public boolean sameClassWidth() {
        return "true".equals(this.getValue("sameclasswidth"));
    }

    @Override
    public final Rankdir getRankdir() {
        return this.rankdir;
    }

    public final void setRankdir(Rankdir rankdir) {
        this.rankdir = rankdir;
    }

    @Override
    public boolean useOctagonForActivity(Stereotype stereotype) {
        String value = this.getValue("activityshape");
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            String value2 = this.getValue("activityshape" + stereotype.getLabel(false));
            if (value2 != null) {
                value = value2;
            }
        }
        if ("roundedbox".equalsIgnoreCase(value)) {
            return false;
        }
        return "octagon".equalsIgnoreCase(value);
    }

    @Override
    public IHtmlColorSet getIHtmlColorSet() {
        return this.htmlColorSet;
    }

    @Override
    public boolean useUnderlineForHyperlink() {
        String value = this.getValue("hyperlinkunderline");
        return !"false".equalsIgnoreCase(value);
    }

    @Override
    public double getPadding() {
        String value = this.getValue("padding");
        if (value != null && value.matches("\\d+(\\.\\d+)?")) {
            return Double.parseDouble(value);
        }
        return 0.0;
    }

    @Override
    public int groupInheritance() {
        String value = this.getValue("groupinheritance");
        int result = Integer.MAX_VALUE;
        if (value != null && value.matches("\\d+")) {
            result = Integer.parseInt(value);
        }
        if (result <= 1) {
            result = Integer.MAX_VALUE;
        }
        return result;
    }

    @Override
    public boolean useGuillemet() {
        String value = this.getValue("guillemet");
        return !"false".equalsIgnoreCase(value);
    }

    @Override
    public boolean handwritten() {
        String value = this.getValue("handwritten");
        return "true".equalsIgnoreCase(value);
    }

    @Override
    public String getSvgLinkTarget() {
        String value = this.getValue("svglinktarget");
        if (value == null) {
            return "_top";
        }
        return value;
    }

    @Override
    public String getMonospacedFamily() {
        String value = this.getValue("defaultMonospacedFontName");
        if (value == null) {
            return "monospaced";
        }
        return value;
    }
}

