/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.asciiart.AbstractComponentText;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextActor
extends AbstractComponentText {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;

    public ComponentTextActor(ComponentType type, Display stringsToDisplay, FileFormat fileFormat) {
        this.type = type;
        this.stringsToDisplay = stringsToDisplay;
        this.fileFormat = fileFormat;
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        UmlCharArea charArea = ((UGraphicTxt)ug).getCharArea();
        int width = (int)dimensionToUse.getWidth();
        int height = (int)dimensionToUse.getHeight();
        charArea.fillRect(' ', 0, 0, width, height);
        int xman = width / 2 - 1;
        if (this.type == ComponentType.ACTOR_HEAD) {
            charArea.drawStringsLR(this.stringsToDisplay.as(), 1, this.getStickManHeight());
            if (this.fileFormat == FileFormat.UTXT) {
                charArea.drawStickManUnicode(xman, 0);
            } else {
                charArea.drawStickMan(xman, 0);
            }
        } else if (this.type == ComponentType.ACTOR_TAIL) {
            charArea.drawStringsLR(this.stringsToDisplay.as(), 1, 0);
            if (this.fileFormat == FileFormat.UTXT) {
                charArea.drawStickManUnicode(xman, 1);
            } else {
                charArea.drawStickMan(xman, 1);
            }
        } else assert (false);
    }

    private int getStickManHeight() {
        if (this.fileFormat == FileFormat.UTXT) {
            return 6;
        }
        return 5;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + this.getStickManHeight();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWidth(this.stringsToDisplay) + 2;
    }
}

