/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.classdiagram.FullLayout;
import net.sourceforge.plantuml.classdiagram.RowLayout;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;
import net.sourceforge.plantuml.svek.image.EntityImageClass;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;

public class ClassDiagram
extends AbstractClassOrObjectDiagram {
    private String namespaceSeparator = ".";
    private boolean allowMixing;
    private int useLayoutExplicit = 0;

    @Override
    public ILeaf getOrCreateLeaf(Code code, LeafType type, USymbol symbol) {
        if (this.namespaceSeparator != null) {
            code = code.withSeparator(this.namespaceSeparator);
        }
        if (type == null) {
            code = code.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:");
            if (this.namespaceSeparator == null) {
                return this.getOrCreateLeafDefault(code, LeafType.CLASS, symbol);
            }
            if (super.leafExist(code = code.getFullyQualifiedCode(this.getCurrentGroup()))) {
                return this.getOrCreateLeafDefault(code, LeafType.CLASS, symbol);
            }
            return this.createEntityWithNamespace(code, Display.getWithNewlines(code.getShortName(this.getLeafs())), LeafType.CLASS, symbol);
        }
        if (this.namespaceSeparator == null) {
            return this.getOrCreateLeafDefault(code, LeafType.CLASS, symbol);
        }
        if (super.leafExist(code = code.getFullyQualifiedCode(this.getCurrentGroup()))) {
            return this.getOrCreateLeafDefault(code, type, symbol);
        }
        return this.createEntityWithNamespace(code, Display.getWithNewlines(code.getShortName(this.getLeafs())), type, symbol);
    }

    public IGroup getOrCreateNamespace(Code namespace, Display display, GroupType type, IGroup parent) {
        IGroup g;
        if (this.namespaceSeparator != null) {
            namespace = namespace.withSeparator(this.namespaceSeparator).getFullyQualifiedCode(this.getCurrentGroup());
        }
        this.currentGroup = g = this.getOrCreateNamespaceInternal(namespace, display, type, parent);
        return g;
    }

    private IGroup getOrCreateNamespaceInternal(Code namespace, Display display, GroupType type, IGroup parent) {
        IGroup result = this.entityFactory.getGroups().get(namespace);
        if (result != null) {
            return result;
        }
        if (this.entityFactory.getLeafs().containsKey(namespace)) {
            result = this.entityFactory.muteToGroup(namespace, namespace, type, parent);
            result.setDisplay(display);
        } else {
            result = this.entityFactory.createGroup(namespace, display, namespace, type, parent, this.getHides(), this.getNamespaceSeparator());
        }
        this.entityFactory.addGroup(result);
        return result;
    }

    @Override
    public ILeaf createLeaf(Code code, Display display, LeafType type, USymbol symbol) {
        if (this.namespaceSeparator != null) {
            code = code.withSeparator(this.namespaceSeparator);
        }
        if (type != LeafType.ABSTRACT_CLASS && type != LeafType.ANNOTATION && type != LeafType.CLASS && type != LeafType.INTERFACE && type != LeafType.ENUM && type != LeafType.LOLLIPOP && type != LeafType.NOTE) {
            return super.createLeaf(code, display, type, symbol);
        }
        if (this.namespaceSeparator == null) {
            return super.createLeaf(code, display, type, symbol);
        }
        if (super.leafExist(code = code.getFullyQualifiedCode(this.getCurrentGroup()))) {
            throw new IllegalArgumentException("Already known: " + code);
        }
        return this.createEntityWithNamespace(code, display, type, symbol);
    }

    private ILeaf createEntityWithNamespace(Code fullyCode, Display display, LeafType type, USymbol symbol) {
        IGroup group = this.getCurrentGroup();
        String namespace = this.getNamespace(fullyCode);
        if (namespace != null && (EntityUtils.groupRoot(group) || !group.getCode().getFullName().equals(namespace))) {
            Code namespace2 = Code.of(namespace);
            group = this.getOrCreateNamespaceInternal(namespace2, Display.getWithNewlines(namespace), GroupType.PACKAGE, this.getRootGroup());
        }
        return this.createLeafInternal(fullyCode, Display.isNull(display) ? Display.getWithNewlines(fullyCode.getShortName(this.getLeafs())).withCreoleMode(CreoleMode.SIMPLE_LINE) : display, type, group, symbol);
    }

    private final String getNamespace(Code fullyCode) {
        String name = fullyCode.getFullName();
        do {
            int x;
            if ((x = name.lastIndexOf(this.namespaceSeparator)) == -1) {
                return null;
            }
            name = name.substring(0, x);
        } while (this.getLeafs().containsKey(Code.of(name, this.namespaceSeparator)));
        return name;
    }

    @Override
    public final boolean leafExist(Code code) {
        if (this.namespaceSeparator == null) {
            return super.leafExist(code);
        }
        code = code.withSeparator(this.namespaceSeparator);
        return super.leafExist(code.getFullyQualifiedCode(this.getCurrentGroup()));
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.CLASS;
    }

    public void setNamespaceSeparator(String namespaceSeparator) {
        this.namespaceSeparator = namespaceSeparator;
    }

    @Override
    public String getNamespaceSeparator() {
        return this.namespaceSeparator;
    }

    public void setAllowMixing(boolean allowMixing) {
        this.allowMixing = allowMixing;
    }

    public boolean isAllowMixing() {
        return this.allowMixing;
    }

    public void layoutNewLine() {
        ++this.useLayoutExplicit;
        this.incRawLayout();
    }

    @Override
    protected final ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        if (this.useLayoutExplicit != 0) {
            return this.exportLayoutExplicit(os, index, fileFormatOption);
        }
        return super.exportDiagramInternal(os, index, fileFormatOption);
    }

    protected final ImageData exportLayoutExplicit(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        FullLayout fullLayout = new FullLayout();
        for (int i = 0; i <= this.useLayoutExplicit; ++i) {
            RowLayout rawLayout = this.getRawLayout(i);
            fullLayout.addRowLayout(rawLayout);
        }
        ImageBuilder imageBuilder = new ImageBuilder(this.getSkinParam().getColorMapper(), 1.0, HtmlColorUtils.WHITE, null, null, 0.0, 10.0, null, this.getSkinParam().handwritten());
        imageBuilder.addUDrawable(fullLayout);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, os);
    }

    private RowLayout getRawLayout(int raw) {
        RowLayout rawLayout = new RowLayout();
        for (ILeaf leaf : this.getLeafs().values()) {
            if (leaf.getRawLayout() != raw) continue;
            rawLayout.addLeaf(this.getEntityImageClass(leaf));
        }
        return rawLayout;
    }

    private TextBlock getEntityImageClass(ILeaf entity) {
        return new EntityImageClass(null, entity, this.getSkinParam(), this);
    }
}

