/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.command.JavaClass;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.cucadiagram.LeafType;

class JavaFile {
    private static final Pattern classDefinition = MyPattern.cmpile("^(?:public[%s]+|abstract[%s]+|final[%s]+)*(class|interface|enum|annotation)[%s]+(\\w+)(?:.*\\b(extends|implements)[%s]+([\\w%s,]+))?");
    private static final Pattern packageDefinition = MyPattern.cmpile("^package[%s]+([\\w+.]+)[%s]*;");
    private final List<JavaClass> all = new ArrayList<JavaClass>();

    public JavaFile(File f) throws IOException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(f));
            this.initFromReader(br);
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    private void initFromReader(BufferedReader br) throws IOException {
        String s;
        String javaPackage = null;
        while ((s = br.readLine()) != null) {
            Matcher matchPackage = packageDefinition.matcher(s = StringUtils.trin(s));
            if (matchPackage.find()) {
                javaPackage = matchPackage.group(1);
                continue;
            }
            Matcher matchClassDefinition = classDefinition.matcher(s);
            if (!matchClassDefinition.find()) continue;
            String n = matchClassDefinition.group(2);
            String p = matchClassDefinition.group(4);
            LeafType type = LeafType.valueOf(StringUtils.goUpperCase(matchClassDefinition.group(1)));
            LeafType parentType = JavaFile.getParentType(type, matchClassDefinition.group(3));
            this.all.add(new JavaClass(javaPackage, n, p, type, parentType));
        }
    }

    static LeafType getParentType(LeafType type, String extendsOrImplements) {
        if (extendsOrImplements == null) {
            return null;
        }
        if (type == LeafType.CLASS) {
            if (extendsOrImplements.equals("extends")) {
                return LeafType.CLASS;
            }
            return LeafType.INTERFACE;
        }
        return LeafType.INTERFACE;
    }

    public List<JavaClass> getJavaClasses() {
        return Collections.unmodifiableList(this.all);
    }
}

