/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.font.LineMetrics;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.CharHidder;

public class AtomText
implements Atom {
    private static DelayedDouble ZERO = new DelayedDouble(){

        @Override
        public double getDouble(StringBounder stringBounder) {
            return 0.0;
        }
    };
    private final FontConfiguration fontConfiguration;
    private final String text;
    private final DelayedDouble marginLeft;
    private final DelayedDouble marginRight;
    private final Url url;

    public static Atom create(String text, FontConfiguration fontConfiguration) {
        return new AtomText(text, fontConfiguration, null, ZERO, ZERO);
    }

    public static Atom createUrl(Url url, FontConfiguration fontConfiguration) {
        fontConfiguration = fontConfiguration.hyperlink();
        return new AtomText(url.getLabel(), fontConfiguration, url, ZERO, ZERO);
    }

    public static AtomText createHeading(String text, FontConfiguration fontConfiguration, int order) {
        fontConfiguration = order == 0 ? fontConfiguration.bigger(4.0).bold() : (order == 1 ? fontConfiguration.bigger(2.0).bold() : (order == 2 ? fontConfiguration.bigger(1.0).bold() : fontConfiguration.italic()));
        return new AtomText(text, fontConfiguration, null, ZERO, ZERO);
    }

    public static Atom createListNumber(final FontConfiguration fontConfiguration, final int order, int localNumber) {
        DelayedDouble left = new DelayedDouble(){

            @Override
            public double getDouble(StringBounder stringBounder) {
                Dimension2D dim = stringBounder.calculateDimension(fontConfiguration.getFont(), "9. ");
                return dim.getWidth() * (double)order;
            }
        };
        DelayedDouble right = new DelayedDouble(){

            @Override
            public double getDouble(StringBounder stringBounder) {
                Dimension2D dim = stringBounder.calculateDimension(fontConfiguration.getFont(), ".");
                return dim.getWidth();
            }
        };
        return new AtomText("" + (localNumber + 1) + ".", fontConfiguration, null, left, right);
    }

    public String toString() {
        return this.text + " " + this.fontConfiguration;
    }

    private AtomText(String text, FontConfiguration style, Url url, DelayedDouble marginLeft, DelayedDouble marginRight) {
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        this.text = StringUtils.manageUnicodeNotationUplus(StringUtils.manageAmpDiese(StringUtils.showComparatorCharacters(CharHidder.unhide(text))));
        this.fontConfiguration = style;
        this.url = url;
    }

    public FontConfiguration getFontConfiguration() {
        return this.fontConfiguration;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D rect = stringBounder.calculateDimension(this.fontConfiguration.getFont(), this.text);
        Log.debug("g2d=" + rect);
        Log.debug("Size for " + this.text + " is " + rect);
        double h = rect.getHeight();
        if (h < 10.0) {
            h = 10.0;
        }
        double width = this.text.indexOf(9) == -1 ? rect.getWidth() : this.getWidth(stringBounder);
        double left = this.marginLeft.getDouble(stringBounder);
        double right = this.marginRight.getDouble(stringBounder);
        return new Dimension2DDouble(width + left + right, h);
    }

    private double getDescent() {
        LineMetrics fm = TextBlockUtils.getLineMetrics(this.fontConfiguration.getFont(), this.text);
        double descent = fm.getDescent();
        return descent;
    }

    public double getFontSize2D() {
        return this.fontConfiguration.getFont().getSize2D();
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return this.fontConfiguration.getSpace();
    }

    private double getTabSize(StringBounder stringBounder) {
        return stringBounder.calculateDimension(this.fontConfiguration.getFont(), "        ").getWidth();
    }

    @Override
    public void drawU(UGraphic ug) {
        if (ug.isSpecialTxt()) {
            ug.draw(this);
            return;
        }
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        ug = ug.apply(new UChangeColor(this.fontConfiguration.getColor()));
        if (this.marginLeft != ZERO) {
            ug = ug.apply(new UTranslate(this.marginLeft.getDouble(ug.getStringBounder()), 0.0));
        }
        StringTokenizer tokenizer = new StringTokenizer(this.text, "\t", true);
        double x = 0.0;
        Dimension2D rect = ug.getStringBounder().calculateDimension(this.fontConfiguration.getFont(), this.text);
        double descent = this.getDescent();
        double ypos = rect.getHeight() - descent;
        if (tokenizer.hasMoreTokens()) {
            double tabSize = this.getTabSize(ug.getStringBounder());
            while (tokenizer.hasMoreTokens()) {
                String s = tokenizer.nextToken();
                if (s.equals("\t")) {
                    double remainder = x % tabSize;
                    x += tabSize - remainder;
                    continue;
                }
                UText utext = new UText(s, this.fontConfiguration);
                Dimension2D dim = ug.getStringBounder().calculateDimension(this.fontConfiguration.getFont(), s);
                ug.apply(new UTranslate(x, ypos)).draw(utext);
                x += dim.getWidth();
            }
        }
        if (this.url != null) {
            ug.closeAction();
        }
    }

    private double getWidth(StringBounder stringBounder) {
        return this.getWidth(stringBounder, this.text);
    }

    private double getWidth(StringBounder stringBounder, String text) {
        StringTokenizer tokenizer = new StringTokenizer(text, "\t", true);
        double tabSize = this.getTabSize(stringBounder);
        double x = 0.0;
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            if (s.equals("\t")) {
                double remainder = x % tabSize;
                x += tabSize - remainder;
                continue;
            }
            Dimension2D dim = stringBounder.calculateDimension(this.fontConfiguration.getFont(), s);
            x += dim.getWidth();
        }
        return x;
    }

    public List<AtomText> getSplitted(StringBounder stringBounder, double maxWidth) {
        ArrayList<AtomText> result = new ArrayList<AtomText>();
        StringTokenizer st = new StringTokenizer(this.text, " ", true);
        StringBuilder currentLine = new StringBuilder();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            double w = this.getWidth(stringBounder, currentLine + token);
            if (w > maxWidth) {
                result.add(new AtomText(currentLine.toString(), this.fontConfiguration, this.url, this.marginLeft, this.marginRight));
                currentLine.setLength(0);
                if (token.startsWith(" ")) continue;
                currentLine.append(token);
                continue;
            }
            currentLine.append(token);
        }
        result.add(new AtomText(currentLine.toString(), this.fontConfiguration, this.url, this.marginLeft, this.marginRight));
        return Collections.unmodifiableList(result);
    }

    public final String getText() {
        return this.text;
    }

    static interface DelayedDouble {
        public double getDouble(StringBounder var1);
    }
}

