/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.QuadCurve2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

class EntityImageUsecase
extends AbstractEntityImage {
    private final TextBlock name;

    public EntityImageUsecase(IEntity entity) {
        super(entity);
        this.name = entity.getDisplay().create(new FontConfiguration(this.getFont14(), HtmlColorUtils.BLACK, HtmlColorUtils.BLUE, true), HorizontalAlignment.CENTER, new SpriteContainerEmpty());
    }

    @Override
    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D nameDim = this.name.calculateDimension(stringBounder);
        double eps = 1.7;
        return new Dimension2DDouble(nameDim.getWidth() * 1.7, nameDim.getHeight() * 1.7);
    }

    @Override
    public void draw(ColorMapper colorMapper, Graphics2D g2d) {
        Dimension2D dimTotal = this.getDimension(StringBounderUtils.asStringBounder(g2d));
        GeneralPath ellipse = new GeneralPath();
        double h = dimTotal.getHeight();
        double w = dimTotal.getWidth();
        ellipse.append(new QuadCurve2D.Double(0.0, h / 2.0, 0.0, 0.0, w / 2.0, 0.0), true);
        ellipse.append(new QuadCurve2D.Double(w / 2.0, 0.0, w, 0.0, w, h / 2.0), true);
        ellipse.append(new QuadCurve2D.Double(w, h / 2.0, w, h, w / 2.0, h), true);
        ellipse.append(new QuadCurve2D.Double(w / 2.0, h, 0.0, h, 0.0, h / 2.0), true);
        g2d.setColor(colorMapper.getMappedColor(this.getYellow()));
        g2d.fill(ellipse);
        g2d.setColor(colorMapper.getMappedColor(this.getRed()));
        g2d.draw(ellipse);
        g2d.setColor(Color.BLACK);
    }
}

