/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class MethodsOrFieldsArea {
    private final UFont font;
    private final List<String> strings = new ArrayList<String>();

    public MethodsOrFieldsArea(List<Member> attributes, UFont font) {
        this.font = font;
        for (Member att : attributes) {
            this.strings.add(att.getDisplay(false));
        }
    }

    public VisibilityModifier getVisibilityModifier() {
        throw new UnsupportedOperationException();
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double x = 0.0;
        double y = 0.0;
        for (String s : this.strings) {
            TextBlock bloc = this.createTextBlock(s);
            Dimension2D dim = bloc.calculateDimension(stringBounder);
            y += dim.getHeight();
            x = Math.max(dim.getWidth(), x);
        }
        return new Dimension2DDouble(x, y);
    }

    private TextBlock createTextBlock(String s) {
        return Display.create(s).create(new FontConfiguration(this.font, HtmlColorUtils.BLACK, HtmlColorUtils.BLUE, true), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    public void draw(UGraphic ug, double x, double y) {
        for (String s : this.strings) {
            TextBlock bloc = this.createTextBlock(s);
            bloc.drawU(ug.apply(new UTranslate(x, y)));
            y += bloc.calculateDimension(ug.getStringBounder()).getHeight();
        }
    }
}

