/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Map;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontPosition;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.SvgAttributes;
import net.sourceforge.plantuml.ugraphic.UFont;

public class FontConfiguration {
    private final EnumSet<FontStyle> styles;
    private final UFont currentFont;
    private final UFont motherFont;
    private final HtmlColor motherColor;
    private final HtmlColor hyperlinkColor;
    private final HtmlColor currentColor;
    private final HtmlColor extendedColor;
    private final FontPosition fontPosition;
    private final SvgAttributes svgAttributes;
    private final boolean hyperlink;
    private final boolean useUnderlineForHyperlink;

    public FontConfiguration(UFont font, HtmlColor color, HtmlColor hyperlinkColor, boolean useUnderlineForHyperlink) {
        this(FontConfiguration.getStyles(font), font, color, font, color, null, FontPosition.NORMAL, new SvgAttributes(), false, hyperlinkColor, useUnderlineForHyperlink);
    }

    public FontConfiguration(ISkinParam skinParam, FontParam fontParam, Stereotype stereo) {
        this(SkinParamUtils.getFont(skinParam, fontParam, stereo), SkinParamUtils.getFontColor(skinParam, fontParam, stereo), skinParam.getHyperlinkColor(), skinParam.useUnderlineForHyperlink());
    }

    public final boolean useUnderlineForHyperlink() {
        return this.useUnderlineForHyperlink;
    }

    public final HtmlColor getHyperlinkColor() {
        return this.hyperlinkColor;
    }

    private static EnumSet<FontStyle> getStyles(UFont font) {
        boolean bold = font.isBold();
        boolean italic = font.isItalic();
        if (bold && italic) {
            return EnumSet.of(FontStyle.ITALIC, FontStyle.BOLD);
        }
        if (bold) {
            return EnumSet.of(FontStyle.BOLD);
        }
        if (italic) {
            return EnumSet.of(FontStyle.ITALIC);
        }
        return EnumSet.noneOf(FontStyle.class);
    }

    public String toString() {
        return this.styles.toString() + " " + this.currentColor;
    }

    private FontConfiguration(EnumSet<FontStyle> styles, UFont motherFont, HtmlColor motherColor, UFont currentFont, HtmlColor currentColor, HtmlColor extendedColor, FontPosition fontPosition, SvgAttributes svgAttributes, boolean hyperlink, HtmlColor hyperlinkColor, boolean useUnderlineForHyperlink) {
        this.styles = styles;
        this.currentFont = currentFont;
        this.motherFont = motherFont;
        this.currentColor = currentColor;
        this.motherColor = motherColor;
        this.extendedColor = extendedColor;
        this.fontPosition = fontPosition;
        this.svgAttributes = svgAttributes;
        this.hyperlink = hyperlink;
        this.hyperlinkColor = hyperlinkColor;
        this.useUnderlineForHyperlink = useUnderlineForHyperlink;
    }

    public FontConfiguration forceFont(UFont newFont, HtmlColor htmlColorForStereotype) {
        if (newFont == null) {
            return this.add(FontStyle.ITALIC);
        }
        FontConfiguration result = new FontConfiguration(this.styles, newFont, this.motherColor, newFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink);
        if (htmlColorForStereotype != null) {
            result = result.changeColor(htmlColorForStereotype);
        }
        return result;
    }

    public FontConfiguration changeAttributes(SvgAttributes toBeAdded) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes.add(toBeAdded), this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink);
    }

    private FontConfiguration withHyperlink() {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, true, this.hyperlinkColor, this.useUnderlineForHyperlink);
    }

    public FontConfiguration changeColor(HtmlColor htmlColor) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, htmlColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink);
    }

    FontConfiguration changeExtendedColor(HtmlColor newExtendedColor) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.currentColor, newExtendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink);
    }

    public FontConfiguration changeSize(float size) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont.deriveSize(size), this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink);
    }

    public FontConfiguration bigger(double delta) {
        return this.changeSize((float)((double)this.currentFont.getSize() + delta));
    }

    public FontConfiguration changeFontPosition(FontPosition fontPosition) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink);
    }

    public FontConfiguration changeFamily(String family) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, new UFont(family, this.currentFont.getStyle(), this.currentFont.getSize()), this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink);
    }

    public FontConfiguration resetFont() {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.motherFont, this.motherColor, null, FontPosition.NORMAL, new SvgAttributes(), this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink);
    }

    FontConfiguration add(FontStyle style) {
        Object r = this.styles.clone();
        ((AbstractCollection)r).add(style);
        return new FontConfiguration((EnumSet<FontStyle>)r, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink);
    }

    public FontConfiguration italic() {
        return this.add(FontStyle.ITALIC);
    }

    public FontConfiguration bold() {
        return this.add(FontStyle.BOLD);
    }

    public FontConfiguration underline() {
        return this.add(FontStyle.UNDERLINE);
    }

    public FontConfiguration hyperlink() {
        if (this.useUnderlineForHyperlink) {
            return this.add(FontStyle.UNDERLINE).withHyperlink();
        }
        return this.withHyperlink();
    }

    FontConfiguration remove(FontStyle style) {
        Object r = this.styles.clone();
        ((AbstractCollection)r).remove((Object)style);
        return new FontConfiguration((EnumSet<FontStyle>)r, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink);
    }

    public UFont getFont() {
        UFont result = this.currentFont;
        for (FontStyle style : this.styles) {
            result = style.mutateFont(result);
        }
        return this.fontPosition.mute(result);
    }

    public HtmlColor getColor() {
        if (this.hyperlink) {
            return this.hyperlinkColor;
        }
        return this.currentColor;
    }

    public HtmlColor getExtendedColor() {
        return this.extendedColor;
    }

    public boolean containsStyle(FontStyle style) {
        return this.styles.contains((Object)style);
    }

    public int getSpace() {
        return this.fontPosition.getSpace();
    }

    public Map<String, String> getAttributes() {
        return this.svgAttributes.attributes();
    }

    public double getSize2D() {
        return this.currentFont.getSize2D();
    }
}

