/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jungle;

import java.awt.geom.Dimension2D;
import java.util.Arrays;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.jungle.GNode;
import net.sourceforge.plantuml.jungle.GTile;
import net.sourceforge.plantuml.jungle.GTileGeometry;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class GTileNode
extends AbstractTextBlock
implements GTile {
    private final TextBlock tb;

    public GTileNode(GNode node) {
        Display display = node.getDisplay();
        SheetBlock1 sheetBlock1 = GTileNode.getTextBlock(display);
        SymbolContext symbolContext = new SymbolContext(HtmlColorUtils.MY_YELLOW, HtmlColorUtils.BLACK);
        this.tb = USymbol.RECTANGLE.asSmall(null, sheetBlock1, TextBlockUtils.empty(0.0, 0.0), symbolContext);
    }

    public static SheetBlock1 getTextBlock(Display display) {
        Rose rose = new Rose();
        SkinParam skinParam = new SkinParam();
        HtmlColor fontColor = rose.getFontColor(skinParam, FontParam.NOTE);
        UFont fontNote = skinParam.getFont(FontParam.NOTE, null, false);
        FontConfiguration fc = new FontConfiguration(fontNote, fontColor, skinParam.getHyperlinkColor(), skinParam.useUnderlineForHyperlink());
        Sheet sheet9 = new CreoleParser(fc, HorizontalAlignment.LEFT, skinParam, CreoleMode.FULL).createSheet(display);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet9, 0.0, 0.0);
        return sheetBlock1;
    }

    @Override
    public void drawU(UGraphic ug) {
        this.tb.drawU(ug);
    }

    @Override
    public GTileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.tb.calculateDimension(stringBounder);
        return new GTileGeometry(dim, Arrays.asList(dim.getHeight() / 2.0));
    }
}

