/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.Cell;
import net.sourceforge.plantuml.salt.Positionner2;
import net.sourceforge.plantuml.salt.element.AbstractElement;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.Grid;
import net.sourceforge.plantuml.salt.element.LeftFirst;
import net.sourceforge.plantuml.salt.element.TableStrategy;
import net.sourceforge.plantuml.salt.element.TopFirst;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ElementPyramid
extends AbstractElement {
    private int rows;
    private int cols;
    private final TableStrategy tableStrategy;
    private final Map<Element, Cell> positions1;
    private final Map<Cell, Element> positions2 = new HashMap<Cell, Element>();
    private double[] rowsStart;
    private double[] colsStart;

    public ElementPyramid(Positionner2 positionner, TableStrategy tableStrategy) {
        this.positions1 = positionner.getAll();
        for (Map.Entry<Element, Cell> ent : this.positions1.entrySet()) {
            this.positions2.put(ent.getValue(), ent.getKey());
        }
        this.rows = positionner.getNbRows();
        this.cols = positionner.getNbCols();
        this.tableStrategy = tableStrategy;
        for (Cell c : this.positions1.values()) {
            this.rows = Math.max(this.rows, c.getMaxRow());
            this.cols = Math.max(this.cols, c.getMaxCol());
        }
    }

    @Override
    public Dimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        this.init(stringBounder);
        return new Dimension2DDouble(this.colsStart[this.colsStart.length - 1], this.rowsStart[this.rowsStart.length - 1]);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, Dimension2D dimToUse) {
        this.init(ug.getStringBounder());
        Grid grid = new Grid(this.rowsStart, this.colsStart, this.tableStrategy);
        for (Map.Entry<Element, Cell> ent : this.positions1.entrySet()) {
            Element elt = ent.getKey();
            Cell cell = ent.getValue();
            double xcell = this.colsStart[cell.getMinCol()];
            double ycell = this.rowsStart[cell.getMinRow()];
            double width = this.colsStart[cell.getMaxCol() + 1] - this.colsStart[cell.getMinCol()] - 1.0;
            double height = this.rowsStart[cell.getMaxRow() + 1] - this.rowsStart[cell.getMinRow()] - 1.0;
            grid.addCell(cell);
            elt.drawU(ug.apply(new UTranslate(xcell + 1.0, ycell + 1.0)), zIndex, new Dimension2DDouble(width, height));
        }
        if (zIndex == 0) {
            grid.drawU(ug, 0.0, 0.0);
        }
    }

    private void init(StringBounder stringBounder) {
        Dimension2D dim;
        Element elt;
        if (this.rowsStart != null) {
            return;
        }
        this.rowsStart = new double[this.rows + 1];
        this.colsStart = new double[this.cols + 1];
        ArrayList<Cell> all = new ArrayList<Cell>(this.positions1.values());
        Collections.sort(all, new LeftFirst());
        for (Cell cell : all) {
            elt = this.positions2.get(cell);
            dim = elt.getPreferredDimension(stringBounder, 0.0, 0.0);
            this.ensureColWidth(cell.getMinCol(), cell.getMaxCol() + 1, dim.getWidth() + 2.0);
        }
        Collections.sort(all, new TopFirst());
        for (Cell cell : all) {
            elt = this.positions2.get(cell);
            dim = elt.getPreferredDimension(stringBounder, 0.0, 0.0);
            this.ensureRowHeight(cell.getMinRow(), cell.getMaxRow() + 1, dim.getHeight() + 2.0);
        }
    }

    private void ensureColWidth(int first, int last, double width) {
        double actual = this.colsStart[last] - this.colsStart[first];
        double missing = width - actual;
        if (missing > 0.0) {
            int i = last;
            while (i < this.colsStart.length) {
                int n = i++;
                this.colsStart[n] = this.colsStart[n] + missing;
            }
        }
    }

    private void ensureRowHeight(int first, int last, double height) {
        double actual = this.rowsStart[last] - this.rowsStart[first];
        double missing = height - actual;
        if (missing > 0.0) {
            int i = last;
            while (i < this.rowsStart.length) {
                int n = i++;
                this.rowsStart[n] = this.rowsStart[n] + missing;
            }
        }
    }

    public final int getNbRows() {
        return this.rows + 1;
    }

    public final int getNbCols() {
        return this.cols + 1;
    }
}

