/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.skin.bluemodern.AbstractComponentBlueModernArrow;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentBlueModernSelfArrow
extends AbstractComponentBlueModernArrow {
    private final double arrowWidth = 45.0;

    public ComponentBlueModernSelfArrow(HtmlColor foregroundColor, FontConfiguration font, Display stringsToDisplay, ArrowConfiguration arrowConfiguration, ISkinSimple spriteContainer) {
        super(foregroundColor, font, stringsToDisplay, arrowConfiguration, spriteContainer);
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        StringBounder stringBounder = ug.getStringBounder();
        int textHeight = (int)this.getTextHeight(stringBounder);
        ug = ug.apply(new UChangeBackColor(this.getForegroundColor())).apply(new UChangeColor(this.getForegroundColor()));
        double x2 = 42.0;
        ug = this.getArrowConfiguration().isDotted() ? this.stroke(ug, 5.0, 2.0) : ug.apply(new UStroke(2.0));
        ug.apply(new UTranslate(0.0, textHeight)).draw(new ULine(42.0, 0.0));
        int textAndArrowHeight = (int)((double)textHeight + this.getArrowOnlyHeight(stringBounder));
        ug.apply(new UTranslate(42.0, textHeight)).draw(new ULine(0.0, textAndArrowHeight - textHeight));
        ug.apply(new UTranslate(42.0, textAndArrowHeight)).draw(new ULine(-40.0, 0.0));
        ug = ug.apply(new UStroke());
        int delta = (int)this.getArrowOnlyHeight(stringBounder);
        if (this.getArrowConfiguration().isAsync()) {
            if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                ug.apply(new UStroke(1.5)).apply(new UTranslate(this.getArrowDeltaX2(), textHeight - this.getArrowDeltaY2() + delta)).draw(new ULine(-this.getArrowDeltaX2(), this.getArrowDeltaY2()));
            }
            if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                ug.apply(new UStroke(1.5)).apply(new UTranslate(this.getArrowDeltaX2(), textHeight + this.getArrowDeltaY2() + delta)).draw(new ULine(-this.getArrowDeltaX2(), -this.getArrowDeltaY2()));
            }
        } else {
            UPolygon polygon = this.getPolygon(textHeight, delta);
            ug.draw(polygon);
        }
        this.getTextBlock().drawU(ug.apply(new UTranslate(this.getMarginX1(), 0.0)));
    }

    private UPolygon getPolygon(int textHeight, int delta) {
        UPolygon polygon = new UPolygon();
        if (this.getArrowConfiguration().getPart() == ArrowPart.TOP_PART) {
            polygon.addPoint(this.getArrowDeltaX(), textHeight - this.getArrowDeltaY() + delta);
            polygon.addPoint(0.0, textHeight + delta);
            polygon.addPoint(this.getArrowDeltaX(), textHeight + delta);
        } else if (this.getArrowConfiguration().getPart() == ArrowPart.BOTTOM_PART) {
            polygon.addPoint(this.getArrowDeltaX(), textHeight + delta);
            polygon.addPoint(0.0, textHeight + delta);
            polygon.addPoint(this.getArrowDeltaX(), textHeight + this.getArrowDeltaY() + delta);
        } else {
            polygon.addPoint(this.getArrowDeltaX(), textHeight - this.getArrowDeltaY() + delta);
            polygon.addPoint(0.0, textHeight + delta);
            polygon.addPoint(this.getArrowDeltaX(), textHeight + this.getArrowDeltaY() + delta);
        }
        return polygon;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + (double)this.getArrowDeltaY() + this.getArrowOnlyHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    private double getArrowOnlyHeight(StringBounder stringBounder) {
        return 13.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return Math.max(this.getTextWidth(stringBounder), 45.0);
    }

    @Override
    public Point2D getStartPoint(StringBounder stringBounder, Dimension2D dimensionToUse) {
        int textHeight = (int)this.getTextHeight(stringBounder);
        return new Point2D.Double(this.getPaddingX(), (double)textHeight + this.getPaddingY());
    }

    @Override
    public Point2D getEndPoint(StringBounder stringBounder, Dimension2D dimensionToUse) {
        int textHeight = (int)this.getTextHeight(stringBounder);
        int textAndArrowHeight = (int)((double)textHeight + this.getArrowOnlyHeight(stringBounder));
        return new Point2D.Double(this.getPaddingX(), (double)textAndArrowHeight + this.getPaddingY());
    }
}

