/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseParticipant
extends AbstractTextualComponent {
    private final HtmlColor back;
    private final HtmlColor foregroundColor;
    private final double deltaShadow;
    private final double roundCorner;
    private final UStroke stroke;

    public ComponentRoseParticipant(SymbolContext biColor, FontConfiguration font, Display stringsToDisplay, ISkinSimple spriteContainer, double roundCorner, UFont fontForStereotype, HtmlColor htmlColorForStereotype) {
        super(stringsToDisplay, font, HorizontalAlignment.CENTER, 7, 7, 7, spriteContainer, 0.0, false, fontForStereotype, htmlColorForStereotype);
        this.back = biColor.getBackColor();
        this.roundCorner = roundCorner;
        this.deltaShadow = biColor.getDeltaShadow();
        this.foregroundColor = biColor.getForeColor();
        this.stroke = biColor.getStroke();
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(new UChangeBackColor(this.back)).apply(new UChangeColor(this.foregroundColor));
        ug = ug.apply(this.stroke);
        URectangle rect = new URectangle(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder), this.roundCorner, this.roundCorner);
        rect.setDeltaShadow(this.deltaShadow);
        ug.draw(rect);
        ug = ug.apply(new UStroke());
        TextBlock textBlock = this.getTextBlock();
        textBlock.drawU(ug.apply(new UTranslate(this.getMarginX1(), this.getMarginY())));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + this.deltaShadow + 1.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + this.deltaShadow;
    }
}

