/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram;

import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.utils.UniqueSequence;

public class StateDiagram
extends AbstractEntityDiagram {
    private boolean hideEmptyDescription = false;

    public boolean checkConcurrentStateOk(Code code) {
        if (!this.leafExist(code)) {
            return true;
        }
        ILeaf existing = this.getLeafsget(code);
        if (this.getCurrentGroup().getGroupType() == GroupType.CONCURRENT_STATE && this.getCurrentGroup() != existing.getParentContainer()) {
            return false;
        }
        return existing.getParentContainer().getGroupType() != GroupType.CONCURRENT_STATE || this.getCurrentGroup() == existing.getParentContainer();
    }

    @Override
    public IEntity getOrCreateLeaf(Code code, LeafType type, USymbol symbol) {
        if (!this.checkConcurrentStateOk(code)) {
            throw new IllegalStateException("Concurrent State " + code);
        }
        if (type == null) {
            if (code.getFullName().startsWith("[*]")) {
                throw new IllegalArgumentException();
            }
            if (this.isGroup(code)) {
                return this.getGroup(code);
            }
            return this.getOrCreateLeafDefault(code, LeafType.STATE, null);
        }
        return this.getOrCreateLeafDefault(code, type, symbol);
    }

    public IEntity getStart() {
        IGroup g = this.getCurrentGroup();
        if (EntityUtils.groupRoot(g)) {
            return this.getOrCreateLeaf(Code.of("*start"), LeafType.CIRCLE_START, null);
        }
        return this.getOrCreateLeaf(Code.of("*start*" + g.getCode().getFullName()), LeafType.CIRCLE_START, null);
    }

    public IEntity getEnd() {
        IGroup p = this.getCurrentGroup();
        if (EntityUtils.groupRoot(p)) {
            return this.getOrCreateLeaf(Code.of("*end"), LeafType.CIRCLE_END, null);
        }
        return this.getOrCreateLeaf(Code.of("*end*" + p.getCode().getFullName()), LeafType.CIRCLE_END, null);
    }

    public IEntity getHistorical() {
        IGroup g = this.getCurrentGroup();
        if (EntityUtils.groupRoot(g)) {
            return this.getOrCreateLeaf(Code.of("*historical"), LeafType.PSEUDO_STATE, null);
        }
        return this.getOrCreateLeaf(Code.of("*historical*" + g.getCode().getFullName()), LeafType.PSEUDO_STATE, null);
    }

    public IEntity getHistorical(Code codeGroup) {
        IGroup g = this.getOrCreateGroup(codeGroup, Display.getWithNewlines(codeGroup), GroupType.STATE, this.getRootGroup());
        IEntity result = this.getOrCreateLeaf(Code.of("*historical*" + g.getCode().getFullName()), LeafType.PSEUDO_STATE, null);
        this.endGroup();
        return result;
    }

    public boolean concurrentState(char direction) {
        IGroup cur = this.getCurrentGroup();
        if (!EntityUtils.groupRoot(cur) && cur.getGroupType() == GroupType.CONCURRENT_STATE) {
            super.endGroup();
        }
        this.getCurrentGroup().setConcurrentSeparator(direction);
        IGroup conc1 = this.getOrCreateGroup(UniqueSequence.getCode("CONC"), Display.create(""), GroupType.CONCURRENT_STATE, this.getCurrentGroup());
        if (!EntityUtils.groupRoot(cur) && cur.getGroupType() == GroupType.STATE) {
            cur.moveEntitiesTo(conc1);
            super.endGroup();
            this.getOrCreateGroup(UniqueSequence.getCode("CONC"), Display.create(""), GroupType.CONCURRENT_STATE, this.getCurrentGroup());
        }
        return true;
    }

    @Override
    public void endGroup() {
        IGroup cur = this.getCurrentGroup();
        if (!EntityUtils.groupRoot(cur) && cur.getGroupType() == GroupType.CONCURRENT_STATE) {
            super.endGroup();
        }
        super.endGroup();
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.STATE;
    }

    public final void setHideEmptyDescription(boolean hideEmptyDescription) {
        this.hideEmptyDescription = hideEmptyDescription;
    }

    @Override
    public final boolean isHideEmptyDescriptionForState() {
        return this.hideEmptyDescription;
    }
}

