/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.image.BufferedImage;
import java.util.List;
import net.sourceforge.plantuml.ugraphic.SpriteGrayLevel;

public class SpriteUtils {
    private SpriteUtils() {
    }

    public static String encode(BufferedImage img, String name, SpriteGrayLevel level) {
        StringBuilder sb = new StringBuilder();
        sb.append("sprite $" + name + " [" + img.getWidth() + "x" + img.getHeight() + "/" + level.getNbColor() + "] {\n");
        List<String> result = level.encode(img);
        for (String s : result) {
            sb.append(s);
            sb.append("\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public static String encodeCompressed(BufferedImage img, String name, SpriteGrayLevel level) {
        StringBuilder sb = new StringBuilder();
        sb.append("sprite $" + name + " [" + img.getWidth() + "x" + img.getHeight() + "/" + level.getNbColor() + "z] ");
        List<String> list = level.encodeZ(img);
        if (list.size() == 1) {
            sb.append(list.get(0));
            sb.append("\n");
        } else {
            sb.append("{\n");
            for (String s : list) {
                sb.append(s);
                sb.append("\n");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }
}

