/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class UMotif {
    private final List<Point2D> points = new ArrayList<Point2D>();

    public UMotif(int ... data) {
        for (int i = 0; i < data.length; i += 2) {
            this.points.add(new Point2D.Double(data[i], data[i + 1]));
        }
    }

    public UMotif(String s) {
        Point2D.Double last = new Point2D.Double();
        for (int i = 0; i < s.length(); ++i) {
            Point2D read = UMotif.convertPoint(s.charAt(i));
            ((Point2D)last).setLocation(((Point2D)last).getX() + read.getX(), ((Point2D)last).getY() + read.getY());
            this.points.add(new Point2D.Double(((Point2D)last).getX(), ((Point2D)last).getY()));
        }
    }

    double getLength() {
        return this.points.get(0).distance(this.points.get(this.points.size() - 1));
    }

    List<Point2D> getPoints() {
        return Collections.unmodifiableList(this.points);
    }

    public DotPath getRectangle(double width, double height) {
        double len = this.getLength();
        int nb1 = (int)(width / len);
        DotPath h1 = this.drawHorizontal(0.0, 0.0, nb1);
        int nb2 = (int)(height / len);
        DotPath v1 = this.drawVertical(h1.getEndPoint().getX(), h1.getEndPoint().getY(), nb2);
        h1 = h1.addAfter(v1);
        return h1;
    }

    static Point2D convertPoint(char c) {
        int v = UMotif.convertFromChar(c);
        int x = v % 7;
        int y = v / 7;
        return new Point2D.Double(x - 3, y - 3);
    }

    static int convertFromChar(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'w') {
            return c - 97 + 26;
        }
        throw new IllegalArgumentException();
    }

    public void drawHorizontal(UGraphic ug, double x, double y, int nb) {
        DotPath path = this.drawHorizontal(x, y, nb);
        ug.draw(path);
    }

    public void drawVertical(UGraphic ug, double x, double y, int nb) {
        DotPath path = this.drawVertical(x, y, nb);
        ug.draw(path);
    }

    DotPath drawHorizontal(double x, double y, int nb) {
        DotPath path = new DotPath();
        for (int i = 0; i < nb; ++i) {
            path = this.addHorizontal(x, y, path);
            x = path.getEndPoint().getX();
            y = path.getEndPoint().getY();
        }
        return path;
    }

    DotPath drawVertical(double x, double y, int nb) {
        DotPath path = new DotPath();
        for (int i = 0; i < nb; ++i) {
            path = this.addVertical(x, y, path);
            x = path.getEndPoint().getX();
            y = path.getEndPoint().getY();
        }
        return path;
    }

    private DotPath addHorizontal(double x, double y, DotPath path) {
        double lastx = 0.0;
        double lasty = 0.0;
        for (Point2D p : this.points) {
            double x1 = lastx + x;
            double y1 = lasty + y;
            double x2 = p.getX() + x;
            double y2 = p.getY() + y;
            path = path.addAfter(new CubicCurve2D.Double(x1, y1, x1, y1, x2, y2, x2, y2));
            lastx = p.getX();
            lasty = p.getY();
        }
        return path;
    }

    private DotPath addVertical(double x, double y, DotPath path) {
        double lastx = 0.0;
        double lasty = 0.0;
        for (Point2D p : this.points) {
            double x1 = lastx + x;
            double y1 = lasty + y;
            double x2 = p.getY() + x;
            double y2 = p.getX() + y;
            path = path.addAfter(new CubicCurve2D.Double(x1, y1, x1, y1, x2, y2, x2, y2));
            lastx = p.getY();
            lasty = p.getX();
        }
        return path;
    }
}

