/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.hand;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.USegment;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import net.sourceforge.plantuml.ugraphic.hand.HandJiggle;

public class UPathHand {
    private final UPath path;
    private final double defaultVariation = 4.0;

    public UPathHand(UPath source) {
        UPath jigglePath = new UPath();
        Point2D.Double last = new Point2D.Double();
        for (USegment segment : source) {
            double y;
            double x;
            USegmentType type = segment.getSegmentType();
            if (type == USegmentType.SEG_MOVETO) {
                x = segment.getCoord()[0];
                y = segment.getCoord()[1];
                jigglePath.moveTo(x, y);
                last = new Point2D.Double(x, y);
                continue;
            }
            if (type == USegmentType.SEG_LINETO) {
                x = segment.getCoord()[0];
                y = segment.getCoord()[1];
                HandJiggle jiggle = new HandJiggle(((Point2D)last).getX(), ((Point2D)last).getY(), 4.0);
                jiggle.lineTo(x, y);
                for (USegment seg2 : jiggle.toUPath()) {
                    if (seg2.getSegmentType() != USegmentType.SEG_LINETO) continue;
                    jigglePath.lineTo(seg2.getCoord()[0], seg2.getCoord()[1]);
                }
                last = new Point2D.Double(x, y);
                continue;
            }
            this.path = source;
            return;
        }
        this.path = jigglePath;
    }

    public UPath getHanddrawn() {
        return this.path;
    }
}

