/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.FailChecksumPolicy;
import org.eclipse.aether.internal.impl.WarnChecksumPolicy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicy;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import org.eclipse.aether.transfer.TransferResource;

@Singleton
@Named
public final class DefaultChecksumPolicyProvider
implements ChecksumPolicyProvider {
    private static final int ORDINAL_IGNORE = 0;
    private static final int ORDINAL_WARN = 1;
    private static final int ORDINAL_FAIL = 2;

    @Override
    public ChecksumPolicy newChecksumPolicy(RepositorySystemSession session2, RemoteRepository repository, TransferResource resource2, String policy) {
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        Objects.requireNonNull(resource2, "resource cannot be null");
        DefaultChecksumPolicyProvider.validatePolicy("policy", policy);
        switch (policy) {
            case "ignore": {
                return null;
            }
            case "fail": {
                return new FailChecksumPolicy(resource2);
            }
            case "warn": {
                return new WarnChecksumPolicy(resource2);
            }
        }
        throw new IllegalArgumentException("Unsupported policy: " + policy);
    }

    @Override
    public String getEffectiveChecksumPolicy(RepositorySystemSession session2, String policy1, String policy2) {
        Objects.requireNonNull(session2, "session cannot be null");
        DefaultChecksumPolicyProvider.validatePolicy("policy1", policy1);
        DefaultChecksumPolicyProvider.validatePolicy("policy2", policy2);
        if (policy1.equals(policy2)) {
            return policy1;
        }
        int ordinal1 = DefaultChecksumPolicyProvider.ordinalOfPolicy(policy1);
        int ordinal2 = DefaultChecksumPolicyProvider.ordinalOfPolicy(policy2);
        if (ordinal2 < ordinal1) {
            return ordinal2 != 1 ? policy2 : "warn";
        }
        return ordinal1 != 1 ? policy1 : "warn";
    }

    private static int ordinalOfPolicy(String policy) {
        switch (policy) {
            case "ignore": {
                return 0;
            }
            case "fail": {
                return 2;
            }
            case "warn": {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unsupported policy: " + policy);
    }

    private static void validatePolicy(String paramName, String policy) {
        Objects.requireNonNull(policy, paramName + "cannot be null");
        switch (policy) {
            case "ignore": 
            case "fail": 
            case "warn": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported policy: " + policy);
            }
        }
    }
}

