/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Configuration;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.sisu.inject.DeferredClass;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.plexus.ConfigurationImpl;
import org.eclipse.sisu.plexus.Hints;
import org.eclipse.sisu.plexus.PlexusBeanMetadata;
import org.eclipse.sisu.plexus.PlexusTypeRegistry;
import org.eclipse.sisu.plexus.PlexusXmlMetadata;
import org.eclipse.sisu.plexus.RequirementImpl;
import org.eclipse.sisu.plexus.Roles;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.Streams;

final class PlexusXmlScanner {
    private final Map<?, ?> variables;
    private final URL plexusXml;
    private final Map<String, PlexusBeanMetadata> metadata;

    PlexusXmlScanner(Map<?, ?> variables, URL plexusXml, Map<String, PlexusBeanMetadata> metadata) {
        this.variables = variables;
        this.plexusXml = plexusXml;
        this.metadata = metadata;
    }

    Map<Component, DeferredClass<?>> scan(ClassSpace space2, boolean root2) {
        PlexusTypeRegistry registry2 = new PlexusTypeRegistry(space2);
        if (this.plexusXml != null) {
            this.parsePlexusXml(this.plexusXml, registry2);
        }
        Enumeration<URL> e2 = root2 ? space2.getResources("META-INF/plexus/components.xml") : space2.findEntries("META-INF/plexus", "components.xml", false);
        while (e2.hasMoreElements()) {
            this.parseComponentsXml(e2.nextElement(), registry2);
        }
        return registry2.getComponents();
    }

    private static Reader filteredXmlReader(InputStream in, Map variables) throws IOException {
        XmlStreamReader reader2 = ReaderFactory.newXmlReader(in);
        if (variables != null) {
            return new InterpolationFilterReader(reader2, variables);
        }
        return reader2;
    }

    private void parsePlexusXml(URL url, PlexusTypeRegistry registry2) {
        try {
            InputStream in = Streams.open(url);
            try {
                MXParser parser = new MXParser();
                parser.setInput(PlexusXmlScanner.filteredXmlReader(in, this.variables));
                parser.nextTag();
                parser.require(2, null, null);
                while (parser.nextTag() == 2) {
                    String name2 = parser.getName();
                    if ("load-on-start".equals(name2)) {
                        while (parser.nextTag() == 2) {
                            PlexusXmlScanner.parseLoadOnStart(parser, registry2);
                        }
                        continue;
                    }
                    if ("components".equals(name2)) {
                        while (parser.nextTag() == 2) {
                            this.parseComponent(parser, registry2);
                        }
                        continue;
                    }
                    parser.skipSubTree();
                }
            }
            finally {
                IOUtil.close(in);
            }
        }
        catch (Exception e2) {
            Logs.trace("Problem parsing: {}", url, e2);
        }
    }

    private void parseComponentsXml(URL url, PlexusTypeRegistry registry2) {
        try {
            InputStream in = Streams.open(url);
            try {
                MXParser parser = new MXParser();
                parser.setInput(PlexusXmlScanner.filteredXmlReader(in, this.variables));
                parser.nextTag();
                parser.require(2, null, null);
                parser.nextTag();
                parser.require(2, null, "components");
                while (parser.nextTag() == 2) {
                    this.parseComponent(parser, registry2);
                }
            }
            finally {
                IOUtil.close(in);
            }
        }
        catch (Exception e2) {
            Logs.trace("Problem parsing: {}", url, e2);
        }
    }

    private static void parseLoadOnStart(MXParser parser, PlexusTypeRegistry registry2) throws XmlPullParserException, IOException {
        if ("component".equals(parser.getName())) {
            String role = null;
            String hint = "";
            while (parser.nextTag() == 2) {
                if ("role".equals(parser.getName())) {
                    role = PlexusXmlScanner.TEXT(parser);
                    continue;
                }
                if ("role-hint".equals(parser.getName())) {
                    hint = PlexusXmlScanner.TEXT(parser);
                    continue;
                }
                parser.skipSubTree();
            }
            if (role == null) {
                throw new XmlPullParserException("Missing <role> element.", parser, null);
            }
            registry2.loadOnStart(role, hint);
        } else {
            parser.skipSubTree();
        }
    }

    private void parseComponent(MXParser parser, PlexusTypeRegistry registry2) throws XmlPullParserException, IOException {
        String role = null;
        String hint = "";
        String instantiationStrategy = "singleton";
        String description = "";
        String implementation = null;
        HashMap<String, Requirement> requirementMap = new HashMap<String, Requirement>();
        HashMap<String, Configuration> configurationMap = new HashMap<String, Configuration>();
        ClassSpace space2 = registry2.getSpace();
        parser.require(2, null, "component");
        while (parser.nextTag() == 2) {
            String name2 = parser.getName();
            if ("requirements".equals(name2)) {
                while (parser.nextTag() == 2) {
                    PlexusXmlScanner.parseRequirement(parser, space2, requirementMap);
                }
                continue;
            }
            if ("configuration".equals(name2)) {
                while (parser.nextTag() == 2) {
                    PlexusXmlScanner.parseConfiguration(parser, configurationMap);
                }
                continue;
            }
            if ("role".equals(name2)) {
                role = PlexusXmlScanner.TEXT(parser).intern();
                continue;
            }
            if ("role-hint".equals(name2)) {
                hint = PlexusXmlScanner.TEXT(parser);
                continue;
            }
            if ("instantiation-strategy".equals(name2)) {
                instantiationStrategy = PlexusXmlScanner.TEXT(parser).intern();
                continue;
            }
            if ("description".equals(name2)) {
                description = PlexusXmlScanner.TEXT(parser);
                continue;
            }
            if ("implementation".equals(name2)) {
                implementation = PlexusXmlScanner.TEXT(parser).intern();
                continue;
            }
            parser.skipSubTree();
        }
        if (implementation == null) {
            throw new XmlPullParserException("Missing <implementation> element.", parser, null);
        }
        if (role == null) {
            role = implementation;
        }
        if ((implementation = registry2.addComponent(role, hint, instantiationStrategy, description, implementation)) != null) {
            this.updatePlexusBeanMetadata(implementation, configurationMap, requirementMap);
        }
    }

    private void updatePlexusBeanMetadata(String implementation, Map<String, Configuration> configurationMap, Map<String, Requirement> requirementMap) {
        if (!(this.metadata == null || configurationMap.isEmpty() && requirementMap.isEmpty())) {
            PlexusXmlMetadata beanMetadata = (PlexusXmlMetadata)this.metadata.get(implementation);
            if (beanMetadata != null) {
                beanMetadata.merge(configurationMap, requirementMap);
            } else {
                this.metadata.put(implementation, new PlexusXmlMetadata(configurationMap, requirementMap));
            }
        }
    }

    private static void parseRequirement(MXParser parser, ClassSpace space2, Map<String, Requirement> requirementMap) throws XmlPullParserException, IOException {
        String role = null;
        ArrayList<String> hintList = new ArrayList<String>();
        String fieldName = null;
        boolean optional = false;
        parser.require(2, null, "requirement");
        while (parser.nextTag() == 2) {
            String name2 = parser.getName();
            if ("role".equals(name2)) {
                role = PlexusXmlScanner.TEXT(parser).intern();
                continue;
            }
            if ("role-hint".equals(name2)) {
                hintList.add(PlexusXmlScanner.TEXT(parser));
                continue;
            }
            if ("role-hints".equals(name2)) {
                while (parser.nextTag() == 2) {
                    hintList.add(PlexusXmlScanner.TEXT(parser));
                }
                continue;
            }
            if ("field-name".equals(name2)) {
                fieldName = PlexusXmlScanner.TEXT(parser);
                continue;
            }
            if ("optional".equals(name2)) {
                optional = Boolean.parseBoolean(PlexusXmlScanner.TEXT(parser));
                continue;
            }
            parser.skipSubTree();
        }
        if (role == null) {
            throw new XmlPullParserException("Missing <role> element.", parser, null);
        }
        if (fieldName == null) {
            fieldName = role;
        }
        requirementMap.put(fieldName, new RequirementImpl(space2.deferLoadClass(role), optional, Hints.canonicalHints(hintList)));
    }

    private static void parseConfiguration(MXParser parser, Map<String, Configuration> configurationMap) throws XmlPullParserException, IOException {
        String name2 = parser.getName();
        String fieldName = Roles.camelizeName(name2);
        StringBuilder buf = new StringBuilder();
        String header = parser.getText().trim();
        int depth = parser.getDepth();
        while (parser.next() != 3 || parser.getDepth() > depth) {
            buf.append(parser.getText().trim());
        }
        if (buf.indexOf("<") == 0 || header.indexOf(61) > 0) {
            buf.insert(0, header);
            if (!header.endsWith("/>")) {
                buf.append("</" + name2 + '>');
            }
        }
        configurationMap.put(fieldName, new ConfigurationImpl(fieldName, buf.toString()));
    }

    private static String TEXT(XmlPullParser parser) throws XmlPullParserException, IOException {
        return parser.nextText().trim();
    }
}

