{ inputs, ... }:
let
  sharedLib = inputs.self.sharedLib;
in
{
  perSystem =
    {
      self',
      lib,
      pkgs,
      ...
    }:
    let
      tapeTestLib = inputs.self.tapeTestLib { inherit self' lib pkgs; };
    in
    {
      checks = tapeTestLib.embeddInFlake {
        repoOpen = {
          extraSetup = [
            ''berg auth login --token TOKEN''
            ''berg --non-interactive repo create --name ${sharedLib.repo} --default-branch ${sharedLib.main}''
          ];
          exec = [
            ''Type "BROWSER=firefox berg repo open ${sharedLib.user}/${sharedLib.repo}"''
            ''Sleep 500ms''
            ''Enter''
            ''Sleep 3s''
          ];
        };
        repoListBranches = {
          extraSetup = [
            ''berg auth login --token TOKEN''
            ''berg --non-interactive repo create --name ${sharedLib.repo} --default-branch ${sharedLib.main}''
            ''berg repo clone ${sharedLib.user}/${sharedLib.repo}''
            ''cd ${sharedLib.repo}''
            ''git checkout -b ${sharedLib.main}''
            ''echo 'Hello, World!' > hello.txt''
            ''git add -A''
            ''git commit -m 'Hello, World!' ''
            ''git push origin ${sharedLib.main}''
            ''git checkout -b foo''
            ''git push origin foo''
            ''git checkout -b bar''
            ''git push origin bar''
          ];
          exec = [
            ''Type "berg repo branch list"''
            ''Sleep 500ms''
            ''Enter''
            ''Sleep 3s''
          ];
        };
        repoDeleteBranch = {
          extraSetup = [
            ''berg auth login --token TOKEN''
            ''berg --non-interactive repo create --name ${sharedLib.repo} --default-branch ${sharedLib.main}''
            ''berg repo clone ${sharedLib.user}/${sharedLib.repo}''
            ''cd ${sharedLib.repo}''
            ''git checkout -b ${sharedLib.main}''
            ''echo 'Hello, World!' > hello.txt''
            ''git add -A''
            ''git commit -m 'Hello, World!' ''
            ''git push origin ${sharedLib.main}''
            ''git checkout -b foo''
            ''git push origin foo''
            ''git checkout -b bar''
            ''git push origin bar''
          ];
          exec = [
            ''Type "berg repo branch list"''
            ''Sleep 500ms''
            ''Enter''
            ''Type "berg repo branch delete foo"''
            ''Sleep 500ms''
            ''Enter''
            ''Type "berg repo branch list"''
            ''Sleep 500ms''
            ''Enter''
            ''Sleep 3s''
          ];
        };
      };
    };
}
