pub mod login;
pub mod logout;

use clap::Subcommand;

use super::GlobalArgs;

/// Authentication subcommands
#[derive(Subcommand, Debug)]
pub enum AuthArgs {
    Login(login::LoginArgs),
    Logout(logout::LogoutArgs),
}

impl AuthArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        match self {
            AuthArgs::Login(args) => args.run(global_args).await,
            AuthArgs::Logout(args) => args.run(global_args).await,
        }
    }
}
