<?php

namespace Concrete\Core\Board\Command;

use Concrete\Core\Entity\Board\Template;
use Concrete\Core\Entity\Site\Site;

trait BoardDetailsTrait
{

    /**
     * @var string
     */
    protected $name = '';

    /**
     * @var string
     */
    protected $sortBy = '';


    /**
     * @var Template
     */
    protected $template;

    /**
     * @var Site
     */
    protected $site;

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return Template\null
     */
    public function getTemplate(): ?Template
    {
        return $this->template;
    }

    /**
     * @param Template $template
     */
    public function setTemplate(Template $template): void
    {
        $this->template = $template;
    }

    /**
     * @return Site|null
     */
    public function getSite(): ?Site
    {
        return $this->site;
    }

    /**
     * @param Site $site
     */
    public function setSite(Site $site): void
    {
        $this->site = $site;
    }

    /**
     * @return string
     */
    public function getSortBy()
    {
        return $this->sortBy;
    }

    /**
     * @param string $sortBy
     */
    public function setSortBy($sortBy)
    {
        $this->sortBy = $sortBy;
    }
    
        
}
