#include "binaurality.h"

extern int line_height;

void binaurality::init () {
  label* lbls [] = {&bin, &justification, &zero, &set, &unset, &toggle, &left, &right, &rnd };
  static const char* strs[] = {"Binaurality?", "Justification?", "0", "Set", "Unset", "Toggle",  "Left", "Right", "Random"};
  static const int ids [] = {-1, -1, -1, 1, 0, 2, 0, 1, 2};
  for (int i = 0; i < 9; ++i) {
    label& li = *lbls[i];
    li.set_text (strs[i]);
    li.id = ids [i]; 
  }
  separation.set ("Separation (Hz)", 0.01f, -MILLION, MILLION);
}

void binaurality::set_pos (int x, int y) {
  widget::set_pos (x, y);
  label* lbw[] = {&bin, &justification};
  label* lbt[] = {&set, &unset, &toggle, &left, &right, &rnd};
  static const int dx = 15, dy = line_height + 5;
  for (int i = 0, k = 0; i < 2; ++i) {
    label& li = *lbw[i];
    li.set_pos (x, y);
    int s = li.extents.right + dx;
    for (int j = 0; j < 3; ++j) {
      label& lk = *lbt [k++];
      lk.set_pos (s, y);
      s = lk.extents.right + dx;
    }
    y -= dy;
  }
  zero.set_pos (x, y);
  separation.set_pos (x + 20, y);
  extents (bin.extents.left, separation.extents.bottom, rnd.extents.right, bin.extents.top);
}

void binaurality::draw () {
  label* b [] = {&bin, &set, &unset, &toggle, &justification, &left, &right, &rnd, &zero};
  for (int i = 0; i < 9; ++i) b[i]->draw ();
  separation.draw ();
}

int binaurality::handle_input () {
  widget* w [] = {&set, &unset, &toggle, &left, &right, &rnd, &zero, &separation};
  for (int i = 0; i < 8; ++i) {
    widget* wi = w[i];
    int ret = wi->handle_input ();
    if (ret) return ret;
  }
  return 0;
}

void binaurality::sutlis (click_listener* l) {
  set.set_listener (l);
  unset.set_listener (l);
  toggle.set_listener (l);
}


void binaurality::justlis (click_listener* l) {
  left.set_listener (l);
  right.set_listener (l);
  rnd.set_listener (l);
}
