# 0.78.0 release notes

**Release date:** 2021-12-25


## How to upgrade

Download and launch the latest version:

<div class="compact" markdown>

- [Linux](../linux.md) (or [Steam on Linux](../linux.md#steam))
- [Windows](../windows.md)
- [macOS](../macos.md)

</div>

At the`Z:\>` prompt, run `config -wc` to write the new configuration file. Any
existing settings will be retained, however, extraneous comments will be
dropped.


## Significant changes

- Added Universal binary for macOS, supporting x86-64 and ARM64 *(Kirk Klobe)*
  (#1240)

- Added a workaround for vsync lag, which is useful for video outputs that
  enforce vsync *(Kirk Klobe)* (#1158)

- Added window size and placement customizations *(John Novak)* (#1272)

- Added full `/help` output text for the `AUTOTYPE`, `BOOT`, `CALL`, `CHOICE`,
  `CLS`, `COPY`, `DIR`, `ECHO`, `EXIT`, `GOTO`, `HELP`, `IF`, `INTRO`, `KEYB`,
  `LS`, `MD`/`MKDIR`, `MEM`, `RD`/`RMDIR`, `REN`/`RENAME`, `RESCAN`, `SHIFT`,
  `SUBST`, and `TYPE` commands *(Wengier)* (#1356)

- Added MSYS2-based release builds and instuctions for those on Windows using
  MSYS2 *(Sherman Perry)* (#1443)

- Merged PCjr composite patch by NewRisingSun. Thanks to *JKapp76* for testing
  and feedback *(NewRisingSun)* (#1122)

- Merged CGA composite improvement patch by reenigne, respectively. Thanks to
  *JKapp76* for testing and feedback *(reenigne)* (#1157)

- Added bash-shell completion. See `contrib/linux/bash-completion/README` for
  adding this to your shell *(FeignInt)* (#1200)

- Added Loguru, a fast cross-platform logging subsystem. Logs are now
  time-stamped and warnings are now colorized *(Kirk Klobe)* (#1225)

- Merged S3 video patch by *s3freak*. This adds more video modes and supports
  up to 8 MiB of video memory, `vmemsize = 8`, when using `machine = svga_s3`.
  Thanks to *Zorix*, *Grounded0*, *Brandon Roberts*, *GranMinigun*, *Kirk
  Klobe*, and *nemo93* for testing *(s3freak)* (#1244)

- Added configurable FluidSynth chorus and reverb settings. Thanks to
  *GranMinigun* for the extensive listening tests *(kcgen)* (#1268)

- Added auto-exit. When an executable that's passed on the command-line exits,
  then so too will the emulator. This is equivalent to manually adding the
  `-exit` command-line flag. Thanks to *Burrito78* for testing *(kcgen)*
  (#1269)

- [Added](https://github.com/dosbox-staging/dosbox-staging/blob/656e98edaf0fd2269c3d74792a568f277180e6d0/README#L422-L466)
  layered and portable configuration file handling. Thanks to *JKapp76*,
  *Grounded0*, and *Burrito78* for testing *(kcgen)*

- Added ENet (reliable UDP) as an option for modem and null-modem transport,
  as well as `SERIAL.COM` for runtime serial-port configuration *(Scott
  Duensing)* (#1398)

- Added support for virtual Ethernet and TCP/IP networking via slirp
  *(Jookia)* (#1419)

- Added support for networking in Windows for Workgroups 3.11
  [from the shell](https://github.com/dosbox-staging/dosbox-staging/pull/1447#issuecomment-1000890397).
  Previously networking in WfW was only possible when booting a real MS-DOS
  installation from a bootable HDD image *(Wengier, nanshiki)* (#1447)

- Added IDE controller support, authored by *joncampbell123* of the DOSBox-X
  project, for CD-ROM image-mounts, which is useful for CD-ROM based games
  that also happen to need a real DOS environment such as Revell's car games,
  like **European Racers** *(joncampbell123, Wengier)* (#1451)


## Bugfixes

- Fixed 32-bit dynamic core crashes *(Kirk Klobe)* (#1205)

- Fixed regression when setting `windowresolution` in the config file. Thanks
  to *arrowgent* for the report and testing *(kcgen)* (#1144)

- Fixed hanging in Mortal Kombat Trilogy when `joysticktype = none`. Thanks to
  *nemo93* for the report and *GranMinigun* for also testing *(kcgen)*
  (#1241)

- Fixed regression during shutdown while using the ALSA sequencer. Thanks to
  *AaronBPaden* for the report and testing *(kcgen)* (#1362)

- Fixed zero-offset PC Speaker issue on Windows 11. Thanks to *ggpettas* for
  reporting *(kcgen)* (#1389)

- Fixed regression that broke video recording. Thanks to *Grounded0* for
  reporting and testing *(kcgen)* (#1400)

- Fixed ability to run an application-provided `help.exe|com` program. Thanks
  to *SmilingSpectre* for reporting *(Wengier)* (#1136)

- Removed VESA modes 320&times;200&times;15/16/24, which were added late in
  the 90s and were not properly supported by some games *(NicknineTheEagle)* (#1457)


## Translation updates

<div class="compact" markdown>

- Italian *(Kappa971)*
- German *(Burrito78)*
- Russian *(GranMinigun)*

</div>

Translations (de, es, fr, it, pl, and ru) are included with the release
package and can be selected using the two-letter country code either via
environment variable (`LANG=de`), config file (`[dosbox] language = it`), or
command-line (`-lang ru`). See Section 14 in the `README` file for more
details.


## Repository authors

To ensure authors are credited for their work, the project records authorship
on all commits in the version control system, including all works from the
upstream DOSBox project, patch authors, and external projects.

<div class="compact" markdown>

| **0.78 author**     | Lines changed |
| ------------------- | ------------- |
| arrowgent           | 361           |
| Brandon Roberts     | 1495          |
| Burrito78           | 1882          |
| Christer Solskogen  | 4             |
| Dan Church          | 2             |
| David Reid          | 6733          |
| Eli Schwartz        | 6             |
| GranMinigun         | 1204          |
| Gregory Pakosz      | 1178          |
| John Novak          | 668           |
| Jookia              | 2296          |
| Kappa971            | 2773          |
| kcgen               | 63022         |
| Kirk Klobe          | 1658          |
| llm                 | 6             |
| NicknineTheEagle    | 30            |
| Patryk Obara        | 103           |
| ripsaw8080          | 59            |
| s3freak             | 648           |
| Scott Duensing      | 7330          |
| Sherman Perry       | 5408          |
| Sjoerd van der Berg | 28            |
| Wengier             | 5430          |
| Yann Collet         | 2438          |
| ykhwong             | 7             |

</div>

During the 0.78 timeframe, DOSBox SVN commits r4466 through r4471 were merged
to the project and authorship is reflected above.


## Wiki authors

<div class="compact" markdown>

| **0.78 wiki author**   | Lines changed |
| ---------------------- | ------------- |
| Alberto Salvia Novella | 164           |
| Burrito78              | 2             |
| Grounded0              | 557           |
| John Novak             | 12            |
| Joshua Fern            | 30            |
| kcgen                  | 243           |
| Kirk Klobe             | 2             |
| LowLevelMahn           | 14            |
| MasterO2               | 395           |
| nemo93                 | 5370          |
| Tobias Gruetzmacher    | 5             |

</div>


## Financial contributors

- **Antti Peltola**: Project sponsor. His combined contribution of 4,000 USD
  spanning the 2021 period to maintainers and the project has allowed the team
  to add a dedicated Apple M1 build host. Thank you!

- **Burrito78**: Project backer. Thank you!

To support our work, join the [Open Collective](https://opencollective.com/dosbox-staging).


## Thank you

We are extremely grateful for all contributions, including the invaluable
improvements merged in from the DOSBox project.

