# ==============================================================================
# PMBS rules
#
# SPDX-FileType: SOURCE
# SPDX-FileCopyrightText: Michael Bäuerle
# SPDX-License-Identifier: BSD-2-Clause
#
# Note: The configuration header must be prepended before use.

# Clear suffix list for inference rules
.SUFFIXES:

# If nothing is specified on the command line, make will use the first rule
all: static cli

# Build static library
static:
	@printf '\n%s\n' 'Building static library ...'
	($(PMBS_SH) ../pmbs/prepare.sh include)
	($(PMBS_SH) ../pmbs/prepare.sh src)
	(cd src && $(MAKE) -f build.mk $@)

# Build command line utility
cli: static
	@printf '\n%s\n' 'Building command line utility ...'
	($(PMBS_SH) ../pmbs/prepare.sh util)
	(cd util && $(MAKE) -f build.mk $@)

# Run test suite
check: static
	@printf '\n%s\n' 'Running test suite ...'
	($(PMBS_SH) ../pmbs/prepare.sh test)
	(cd test && $(MAKE) -f build.mk $@)

# Build documentation
documentation:
	@printf '\n%s\n' 'Building documentation ...'
	($(PMBS_SH) ../pmbs/prepare.sh include)
	($(PMBS_SH) ../pmbs/prepare.sh doc)
	(cd doc && $(MAKE) -f build.mk $@)

# Install files
install: static cli
	@printf '\n%s\n' 'Install files ...'
	($(PMBS_SH) ../pmbs/prepare.sh tool)
	(cd src && $(MAKE) -f build.mk $@)
	(cd util && $(MAKE) -f build.mk $@)

# Uninstall files
uninstall:
	@printf '\n%s\n' 'Uninstall files ...'
	($(PMBS_SH) ../pmbs/prepare.sh src)
	($(PMBS_SH) ../pmbs/prepare.sh util)
	(cd src && $(MAKE) -f build.mk $@)
	(cd util && $(MAKE) -f build.mk $@)

# Unknown target
.DEFAULT:
	@printf '\n%s%s\n' 'Unknown target: ' '"$@"'
