# ==============================================================================
# PMBS fragment for library
#
# SPDX-FileType: SOURCE
# SPDX-FileCopyrightText: Michael Bäuerle
# SPDX-License-Identifier: BSD-2-Clause

# Static library archive name
BXX0_TARGET=$(PMBS_LIB_NAME).a

# Object files for library
# Attention: Old implementations of ar may truncate file names to 15 characters
BXX0_OBJS=base64_decode.o base64_encode.o base64_imap.o base64_url.o \
          basexx_ebcdic.o basexx_vers.o

BXX0_MANS=bxx0_base64_encode.3 bxx0_base64_decode.3 bxx0_base64_imap_from.3 \
          bxx0_base64_imap_to.3 bxx0_base64_url_from.3 bxx0_base64_url_to.3 \
          bxx0_ebcdic_from.3 bxx0_ebcdic_to.3 bxx0_version.3

# Installation directories
BXX0_INSTALL_DIRS=include/$(PMBS_LIB_NAME) lib $(PMBS_PKGCONFIGDIR) \
                  $(PMBS_MANPATH)/man3

# Clear suffix list for inference rules
.SUFFIXES:

.SUFFIXES: .c .o .man_in

# If nothing is specified, make will use the first rule
all: static

install: static
	($(PMBS_SH) -c 'for dir in $(BXX0_INSTALL_DIRS) ; \
             do mkdir -p "$(DESTDIR)$(PMBS_PREFIX)/$$dir" ; done')
	($(PMBS_SH) ../tool/install -c -m 644 \
            ../include/$(PMBS_LIB_NAME)/basexx_version.h \
           "$(DESTDIR)$(PMBS_PREFIX)/include/$(PMBS_LIB_NAME)/basexx_version.h")
	($(PMBS_SH) ../tool/install -c -m 644 \
            ../include/$(PMBS_LIB_NAME)/base64_encode.h \
            "$(DESTDIR)$(PMBS_PREFIX)/include/$(PMBS_LIB_NAME)/base64_encode.h")
	($(PMBS_SH) ../tool/install -c -m 644 \
            ../include/$(PMBS_LIB_NAME)/base64_decode.h \
            "$(DESTDIR)$(PMBS_PREFIX)/include/$(PMBS_LIB_NAME)/base64_decode.h")
	($(PMBS_SH) ../tool/install -c -m 644 ./$(BXX0_TARGET) \
            "$(DESTDIR)$(PMBS_PREFIX)/lib/$(BXX0_TARGET)")
	($(PMBS_SH) ../tool/install -c -m 644 ./$(PMBS_LIB_NAME).pc \
            "$(DESTDIR)$(PMBS_PREFIX)/$(PMBS_PKGCONFIGDIR)/$(PMBS_LIB_NAME).pc")
	($(PMBS_SH) for file in *.3 ; \
            do \
                ../tool/install -c -m 644 $$file \
                    "$(DESTDIR)$(PMBS_PREFIX)/$(PMBS_MANPATH)/$$file "; \
            done

# Bypass potential interactive wrappers for rm
uninstall:
	-(command -p rm -f "$(DESTDIR)$(PMBS_PREFIX)/lib/$(BXX0_TARGET)")
	-(command -p rm -f \
            "$(DESTDIR)$(PMBS_PREFIX)/$(PMBS_PKGCONFIGDIR)/$(PMBS_LIB_NAME).pc")
	-(command -p rm -f \
            "$(DESTDIR)$(PMBS_PREFIX)/$(PMBS_MANPATH)/man3/bxx0_*")

# Build static library with metadata for pkg-config and manual pages
static: $(BXX0_TARGET) $(PMBS_LIB_NAME).pc $(BXX0_MANS)

# Create static library
# POSIX requires a hyphen-minus in front of the options for the ar utility.
# Old BSD-based systems may not support this (set ARFLAGS to "rc" for them).
# Old SysV-based systems may not define the AR macro.
# Old BSD-based systems may need the help of ranlib to create a symbol table
# for the library (errors for ranlib are ignored).
$(BXX0_TARGET): $(BXX0_OBJS)
	if test "x" != "x$(AR)" ; then ar_util=$(AR) ; else ar_util=ar ; fi ; \
            $$ar_util $(ARFLAGS) "$@" $(BXX0_OBJS)
	-ranlib "$@"

# Release version
basexx_vers.c: basexx_vers.c.in
	sed -e 's,@release@,$(PMBS_RELEASE_VERSION),g' <$@.in >$@

# Description for pkg-config
$(PMBS_LIB_NAME).pc: $(PMBS_LIB_NAME).pc.in
	sed -e 's,@prefix@,$(PMBS_PREFIX),g' \
            -e 's,@name@,$(PMBS_LIB_NAME),g' \
            -e 's,@release@,$(PMBS_RELEASE_VERSION),g' \
            <$@.in >$@

.man_in:
	sed -e 's,@package@,$(PMBS_LIB_NAME_BASE),g' \
            -e 's,@version@,$(PMBS_RELEASE_VERSION),g' \
            -e "s,@name@,$*END,g" -e 's,\..END,,g' \
            <$< >$@

.c.o:
	$(CC) -I. -I../include $(CPPFLAGS) $(CFLAGS) -c -o $@ $*.c
