/*
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#ifndef UCIC0_I_ICONV_NAME_H
#define UCIC0_I_ICONV_NAME_H  1

#include "iconv_private.h"


/* Header file for encoding names */


#pragma GCC visibility push(internal)


/*! \cond DO_NOT_DOCUMENT */


/* IANA encoding names are limited to 40 US-ASCII characters */
#define UCIC0_I_NAME_MAX  40U


/*
 * Accept IANA alias names too, if nonzero.
 * Can be disabled to reduce memory footprint.
 */
#define UCIC0_I_NAME_ENABLE_ALIASES  1


/*
 * Accept some nonstandard alias names too, if nonzero.
 * Can be disabled to reduce memory footprint.
 */
#define UCIC0_I_NAME_ENABLE_NONSTANDARD  1


/* Flags to indicate source or target encoding */
#define UCIC0_I_NAME_SOURCE  0
#define UCIC0_I_NAME_TARGET  1


/* Data type for conversion functions */
typedef ucic0_i_bool (*ucic0_i_func)(ucic0_i_state *state);


/* Encoding name/table definition */
struct ucic0_i_name_def
{
    const char   *name;  /* Name of encoding (NUL terminated string) */
    ucic0_i_func  func;  /* Pointer to conversion function */
};


/* Data type for name/table definition */
typedef struct ucic0_i_name_def  ucic0_i_name_def;


/* Name to table mappings */
extern const ucic0_i_name_def ucic0_i_name_tgt[];
extern const ucic0_i_name_def ucic0_i_name_src[];
#if UCIC0_I_NAME_ENABLE_ALIASES
extern const ucic0_i_name_def ucic0_i_name_src_alias[];
#endif  /* UCIC0_I_NAME_ENABLE_ALIASES */
#if UCIC0_I_NAME_ENABLE_NONSTANDARD
extern const ucic0_i_name_def ucic0_i_name_src_nonstd[];
#endif  /* UCIC0_I_NAME_ENABLE_NONSTANDARD */


/*! \endcond */


#pragma GCC visibility pop


#endif  /* UCIC0_I_ICONV_NAME_H */
