/// Macros
#[macro_use]
pub mod macros;

/// Command-line interface.
pub mod cli;

/// Command utilities
pub mod cmd;

/// Commands
pub mod cmds;

/// Collections
pub mod collections;

/// Configuration
pub mod config;

/// Constants
pub mod constants;

/// Display subsystem
pub mod display;

/// Errors
pub mod errors;

/// Variable evaluation
pub mod eval;

/// Git queries
pub mod git;

/// Model objects
pub mod model;

/// Path utilities
pub mod path;

/// Queries, configuration lookups
pub mod query;

/// Command-line syntax conventions
pub mod syntax;
