# RootStore


## Fields

| Field                                                                                                                                                       | Type                                                                                                                                                        | Required                                                                                                                                                    | Description                                                                                                                                                 |
| ----------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `Chains`                                                                                                                                                    | [][components.RootStoreChain](../../models/components/rootstorechain.md)                                                                                    | :heavy_minus_sign:                                                                                                                                          | A path of trusted signing certificates up to a root certificate present in a root store, represented as an ordered list of SHA-256 fingerprints.            |
| `EverValid`                                                                                                                                                 | **bool*                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                          | Whether the certificate has ever been considered valid by the root store.                                                                                   |
| `HadTrustedPath`                                                                                                                                            | **bool*                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                          | Whether there ever existed a trusted path of signing certificates from a certificate present in the root certificate store.                                 |
| `HasTrustedPath`                                                                                                                                            | **bool*                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                          | Whether there currently exists a trusted path of signing certificates from a certificate present in the root certificate store.                             |
| `InRevocationSet`                                                                                                                                           | **bool*                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                          | Whether the certificate is in the revocation set (e.g. OneCRL) associated with the root store.                                                              |
| `IsValid`                                                                                                                                                   | **bool*                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                          | Whether the certificate is currently considered valid by the root store: a summary of the trust path, revoked, blocklisted/allowlisted, and expired fields. |
| `Parents`                                                                                                                                                   | []*string*                                                                                                                                                  | :heavy_minus_sign:                                                                                                                                          | The SHA-256 fingerprints of the certificate's immediate parents in its trust path(s).                                                                       |
| `Type`                                                                                                                                                      | [*components.Type](../../models/components/type.md)                                                                                                         | :heavy_minus_sign:                                                                                                                                          | The certificate's type. Options include root, intermediate, or leaf.                                                                                        |