// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

type LabelSource string

const (
	LabelSourceUnknown    LabelSource = ""
	LabelSourceCensys     LabelSource = "censys"
	LabelSourceRecog      LabelSource = "recog"
	LabelSourceWappalyzer LabelSource = "wappalyzer"
	LabelSourceThirdParty LabelSource = "third_party"
)

func (e LabelSource) ToPointer() *LabelSource {
	return &e
}
func (e *LabelSource) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "censys":
		fallthrough
	case "recog":
		fallthrough
	case "wappalyzer":
		fallthrough
	case "third_party":
		*e = LabelSource(v)
		return nil
	default:
		return fmt.Errorf("invalid value for LabelSource: %v", v)
	}
}

type Label struct {
	Confidence *float64     `json:"confidence,omitempty"`
	Evidence   []Evidence   `json:"evidence,omitempty"`
	Source     *LabelSource `json:"source,omitempty"`
	Value      *string      `json:"value,omitempty"`
}

func (o *Label) GetConfidence() *float64 {
	if o == nil {
		return nil
	}
	return o.Confidence
}

func (o *Label) GetEvidence() []Evidence {
	if o == nil {
		return nil
	}
	return o.Evidence
}

func (o *Label) GetSource() *LabelSource {
	if o == nil {
		return nil
	}
	return o.Source
}

func (o *Label) GetValue() *string {
	if o == nil {
		return nil
	}
	return o.Value
}
