package ikev2

import (
	"encoding/hex"
	"fmt"
	"testing"
)

func TestVendorIDPack(t *testing.T) {
	want := "2b000014c590254e5403cbb71f3d493111d7fcad"
	tempBytes, _ := hex.DecodeString("c590254e5403cbb71f3d493111d7fcad")
	got := IkePackVendorID(PayloadType["VENDOR_ID"], tempBytes)

	if fmt.Sprintf("%02x", got) != want {
		t.Fatalf("[1] %q : %02x != %s", got, got, want)
	}

	want = "2b000014c61baca1f1a60cc10800000000000000"
	tempBytes, _ = hex.DecodeString("c61baca1f1a60cc10800000000000000")
	got = IkePackVendorID(PayloadType["VENDOR_ID"], tempBytes)

	if fmt.Sprintf("%02x", got) != want {
		t.Fatalf("[2] %q : %02x != %s", got, got, want)
	}

	want = "2b0000184048b7d56ebce88525e7de7f00d6c2d3c0000000"
	tempBytes, _ = hex.DecodeString("4048b7d56ebce88525e7de7f00d6c2d3c0000000")
	got = IkePackVendorID(PayloadType["VENDOR_ID"], tempBytes)

	if fmt.Sprintf("%02x", got) != want {
		t.Fatalf("[3] %q : %02x != %s", got, got, want)
	}

	want = "290000144048b7d56ebce88525e7de7f00d6c2d3"
	tempBytes, _ = hex.DecodeString("4048b7d56ebce88525e7de7f00d6c2d3")
	got = IkePackVendorID(PayloadType["NOTIFY"], tempBytes)
	if fmt.Sprintf("%02x", got) != want {
		t.Fatalf("[4] %q : %02x != %s", got, got, want)
	}
}

func TestSecurityAssociationPack(t *testing.T) {
	want := "220000300000002c010100040300000c0100000c800e01000300000802000005030000080300000c000000080400000e"
	defaultTransforms := []IkeTransform{
		{PayloadType["TRANSFORM"], TransformType["ENCRYPTION_ALGORITHM"], EncryptionAlgorithm["ENCR_AES_CBC"], 0x800e0100},
		{PayloadType["TRANSFORM"], TransformType["PSEUDO_RANDOM_FUNCTION"], PseudoRandomFunction["PRF_HMAC_SHA2_256"], 0},
		{PayloadType["TRANSFORM"], TransformType["INTEGRITY_ALGORITHM"], IntegrityAlgorithm["AUTH_HMAC_SHA2_256_128"], 0},
		{PayloadType["NONE"], TransformType["DIFFIE_HELLMAN_GROUP"], DiffieHellmanGroup["DH_GROUP_2048_BIT_MODP"], 0},
	}
	got := IkePackSecurityAssociation(PayloadType["KEY_EXCHANGE"], IkePackProposal(PayloadType["NONE"], 1, 1, defaultTransforms, ""))

	if fmt.Sprintf("%02x", got) != want {
		t.Fatalf("[1] %q : %02x != %s", got, got, want)
	}
}

func TestNotifyPack(t *testing.T) {
	want := "2900001c01004005a6358d813592fdd80a9aaa3390f39c8a5a76b6e4"
	tempBytes, _ := hex.DecodeString("a6358d813592fdd80a9aaa3390f39c8a5a76b6e4")
	got := IkePackNotify(PayloadType["NOTIFY"], NotifyType["NAT_DETECTION_DESTINATION_IP"], tempBytes, 1, 0)
	if fmt.Sprintf("%02x", got) != want {
		t.Fatalf("[1] %q : %02x != %s", got, got, want)
	}

	want = "2b00001c010040044cc324152ba3f68ef649ac1e6f96f33791611db2"
	tempBytes, _ = hex.DecodeString("4cc324152ba3f68ef649ac1e6f96f33791611db2")
	got = IkePackNotify(PayloadType["VENDOR_ID"], NotifyType["NAT_DETECTION_SOURCE_IP"], tempBytes, 1, 0)
	if fmt.Sprintf("%02x", got) != want {
		t.Fatalf("[2] %q : %02x != %s", got, got, want)
	}

	want = "290000080000402e"
	got = IkePackNotify(PayloadType["NOTIFY"], NotifyType["IKEV2_FRAGMENTATION_SUPPORTED"], []byte{}, 0, 0)
	if fmt.Sprintf("%02x", got) != want {
		t.Fatalf("[3] %q : %02x != %s", got, got, want)
	}

	want = "2900000800004016"
	got = IkePackNotify(PayloadType["NOTIFY"], NotifyType["REDIRECT_SUPPORTED"], []byte{}, 0, 0)
	if fmt.Sprintf("%02x", got) != want {
		t.Fatalf("[4] %q : %02x != %s", got, got, want)
	}

	want = "000000100000402f0001000200030004"
	tempBytes, _ = hex.DecodeString("0001000200030004")
	got = IkePackNotify(PayloadType["NONE"], NotifyType["SIGNATURE_HASH_ALGORITHMS"], tempBytes, 0, 0)
	if fmt.Sprintf("%02x", got) != want {
		t.Fatalf("[5] %q : %02x != %s", got, got, want)
	}
}
