// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package osconfig provides access to the OS Config API.
//
// For product documentation, see: https://cloud.google.com/compute/docs/osconfig/rest
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/osconfig/v1"
//	...
//	ctx := context.Background()
//	osconfigService, err := osconfig.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	osconfigService, err := osconfig.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	osconfigService, err := osconfig.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package osconfig // import "google.golang.org/api/osconfig/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "osconfig:v1"
const apiName = "osconfig"
const apiVersion = "v1"
const basePath = "https://osconfig.googleapis.com/"
const basePathTemplate = "https://osconfig.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://osconfig.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	rs.PatchDeployments = NewProjectsPatchDeploymentsService(s)
	rs.PatchJobs = NewProjectsPatchJobsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService

	PatchDeployments *ProjectsPatchDeploymentsService

	PatchJobs *ProjectsPatchJobsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Global = NewProjectsLocationsGlobalService(s)
	rs.Instances = NewProjectsLocationsInstancesService(s)
	rs.OsPolicyAssignments = NewProjectsLocationsOsPolicyAssignmentsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Global *ProjectsLocationsGlobalService

	Instances *ProjectsLocationsInstancesService

	OsPolicyAssignments *ProjectsLocationsOsPolicyAssignmentsService
}

func NewProjectsLocationsGlobalService(s *Service) *ProjectsLocationsGlobalService {
	rs := &ProjectsLocationsGlobalService{s: s}
	return rs
}

type ProjectsLocationsGlobalService struct {
	s *Service
}

func NewProjectsLocationsInstancesService(s *Service) *ProjectsLocationsInstancesService {
	rs := &ProjectsLocationsInstancesService{s: s}
	rs.Inventories = NewProjectsLocationsInstancesInventoriesService(s)
	rs.OsPolicyAssignments = NewProjectsLocationsInstancesOsPolicyAssignmentsService(s)
	rs.VulnerabilityReports = NewProjectsLocationsInstancesVulnerabilityReportsService(s)
	return rs
}

type ProjectsLocationsInstancesService struct {
	s *Service

	Inventories *ProjectsLocationsInstancesInventoriesService

	OsPolicyAssignments *ProjectsLocationsInstancesOsPolicyAssignmentsService

	VulnerabilityReports *ProjectsLocationsInstancesVulnerabilityReportsService
}

func NewProjectsLocationsInstancesInventoriesService(s *Service) *ProjectsLocationsInstancesInventoriesService {
	rs := &ProjectsLocationsInstancesInventoriesService{s: s}
	return rs
}

type ProjectsLocationsInstancesInventoriesService struct {
	s *Service
}

func NewProjectsLocationsInstancesOsPolicyAssignmentsService(s *Service) *ProjectsLocationsInstancesOsPolicyAssignmentsService {
	rs := &ProjectsLocationsInstancesOsPolicyAssignmentsService{s: s}
	rs.Reports = NewProjectsLocationsInstancesOsPolicyAssignmentsReportsService(s)
	return rs
}

type ProjectsLocationsInstancesOsPolicyAssignmentsService struct {
	s *Service

	Reports *ProjectsLocationsInstancesOsPolicyAssignmentsReportsService
}

func NewProjectsLocationsInstancesOsPolicyAssignmentsReportsService(s *Service) *ProjectsLocationsInstancesOsPolicyAssignmentsReportsService {
	rs := &ProjectsLocationsInstancesOsPolicyAssignmentsReportsService{s: s}
	return rs
}

type ProjectsLocationsInstancesOsPolicyAssignmentsReportsService struct {
	s *Service
}

func NewProjectsLocationsInstancesVulnerabilityReportsService(s *Service) *ProjectsLocationsInstancesVulnerabilityReportsService {
	rs := &ProjectsLocationsInstancesVulnerabilityReportsService{s: s}
	return rs
}

type ProjectsLocationsInstancesVulnerabilityReportsService struct {
	s *Service
}

func NewProjectsLocationsOsPolicyAssignmentsService(s *Service) *ProjectsLocationsOsPolicyAssignmentsService {
	rs := &ProjectsLocationsOsPolicyAssignmentsService{s: s}
	rs.Operations = NewProjectsLocationsOsPolicyAssignmentsOperationsService(s)
	return rs
}

type ProjectsLocationsOsPolicyAssignmentsService struct {
	s *Service

	Operations *ProjectsLocationsOsPolicyAssignmentsOperationsService
}

func NewProjectsLocationsOsPolicyAssignmentsOperationsService(s *Service) *ProjectsLocationsOsPolicyAssignmentsOperationsService {
	rs := &ProjectsLocationsOsPolicyAssignmentsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOsPolicyAssignmentsOperationsService struct {
	s *Service
}

func NewProjectsPatchDeploymentsService(s *Service) *ProjectsPatchDeploymentsService {
	rs := &ProjectsPatchDeploymentsService{s: s}
	return rs
}

type ProjectsPatchDeploymentsService struct {
	s *Service
}

func NewProjectsPatchJobsService(s *Service) *ProjectsPatchJobsService {
	rs := &ProjectsPatchJobsService{s: s}
	rs.InstanceDetails = NewProjectsPatchJobsInstanceDetailsService(s)
	return rs
}

type ProjectsPatchJobsService struct {
	s *Service

	InstanceDetails *ProjectsPatchJobsInstanceDetailsService
}

func NewProjectsPatchJobsInstanceDetailsService(s *Service) *ProjectsPatchJobsInstanceDetailsService {
	rs := &ProjectsPatchJobsInstanceDetailsService{s: s}
	return rs
}

type ProjectsPatchJobsInstanceDetailsService struct {
	s *Service
}

// AptSettings: Apt patching is completed by executing `apt-get update &&
// apt-get upgrade`. Additional options can be set to control how this is
// executed.
type AptSettings struct {
	// Excludes: List of packages to exclude from update. These packages will be
	// excluded
	Excludes []string `json:"excludes,omitempty"`
	// ExclusivePackages: An exclusive list of packages to be updated. These are
	// the only packages that will be updated. If these packages are not installed,
	// they will be ignored. This field cannot be specified with any other patch
	// configuration fields.
	ExclusivePackages []string `json:"exclusivePackages,omitempty"`
	// Type: By changing the type to DIST, the patching is performed using `apt-get
	// dist-upgrade` instead.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - By default, upgrade will be performed.
	//   "DIST" - Runs `apt-get dist-upgrade`.
	//   "UPGRADE" - Runs `apt-get upgrade`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Excludes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Excludes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AptSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AptSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CVSSv3: Common Vulnerability Scoring System version 3. For details, see
// https://www.first.org/cvss/specification-document
type CVSSv3 struct {
	// AttackComplexity: This metric describes the conditions beyond the attacker's
	// control that must exist in order to exploit the vulnerability.
	//
	// Possible values:
	//   "ATTACK_COMPLEXITY_UNSPECIFIED" - Invalid value.
	//   "ATTACK_COMPLEXITY_LOW" - Specialized access conditions or extenuating
	// circumstances do not exist. An attacker can expect repeatable success when
	// attacking the vulnerable component.
	//   "ATTACK_COMPLEXITY_HIGH" - A successful attack depends on conditions
	// beyond the attacker's control. That is, a successful attack cannot be
	// accomplished at will, but requires the attacker to invest in some measurable
	// amount of effort in preparation or execution against the vulnerable
	// component before a successful attack can be expected.
	AttackComplexity string `json:"attackComplexity,omitempty"`
	// AttackVector: This metric reflects the context by which vulnerability
	// exploitation is possible.
	//
	// Possible values:
	//   "ATTACK_VECTOR_UNSPECIFIED" - Invalid value.
	//   "ATTACK_VECTOR_NETWORK" - The vulnerable component is bound to the network
	// stack and the set of possible attackers extends beyond the other options
	// listed below, up to and including the entire Internet.
	//   "ATTACK_VECTOR_ADJACENT" - The vulnerable component is bound to the
	// network stack, but the attack is limited at the protocol level to a
	// logically adjacent topology.
	//   "ATTACK_VECTOR_LOCAL" - The vulnerable component is not bound to the
	// network stack and the attacker's path is via read/write/execute
	// capabilities.
	//   "ATTACK_VECTOR_PHYSICAL" - The attack requires the attacker to physically
	// touch or manipulate the vulnerable component.
	AttackVector string `json:"attackVector,omitempty"`
	// AvailabilityImpact: This metric measures the impact to the availability of
	// the impacted component resulting from a successfully exploited
	// vulnerability.
	//
	// Possible values:
	//   "IMPACT_UNSPECIFIED" - Invalid value.
	//   "IMPACT_HIGH" - High impact.
	//   "IMPACT_LOW" - Low impact.
	//   "IMPACT_NONE" - No impact.
	AvailabilityImpact string `json:"availabilityImpact,omitempty"`
	// BaseScore: The base score is a function of the base metric scores.
	// https://www.first.org/cvss/specification-document#Base-Metrics
	BaseScore float64 `json:"baseScore,omitempty"`
	// ConfidentialityImpact: This metric measures the impact to the
	// confidentiality of the information resources managed by a software component
	// due to a successfully exploited vulnerability.
	//
	// Possible values:
	//   "IMPACT_UNSPECIFIED" - Invalid value.
	//   "IMPACT_HIGH" - High impact.
	//   "IMPACT_LOW" - Low impact.
	//   "IMPACT_NONE" - No impact.
	ConfidentialityImpact string `json:"confidentialityImpact,omitempty"`
	// ExploitabilityScore: The Exploitability sub-score equation is derived from
	// the Base Exploitability metrics.
	// https://www.first.org/cvss/specification-document#2-1-Exploitability-Metrics
	ExploitabilityScore float64 `json:"exploitabilityScore,omitempty"`
	// ImpactScore: The Impact sub-score equation is derived from the Base Impact
	// metrics.
	ImpactScore float64 `json:"impactScore,omitempty"`
	// IntegrityImpact: This metric measures the impact to integrity of a
	// successfully exploited vulnerability.
	//
	// Possible values:
	//   "IMPACT_UNSPECIFIED" - Invalid value.
	//   "IMPACT_HIGH" - High impact.
	//   "IMPACT_LOW" - Low impact.
	//   "IMPACT_NONE" - No impact.
	IntegrityImpact string `json:"integrityImpact,omitempty"`
	// PrivilegesRequired: This metric describes the level of privileges an
	// attacker must possess before successfully exploiting the vulnerability.
	//
	// Possible values:
	//   "PRIVILEGES_REQUIRED_UNSPECIFIED" - Invalid value.
	//   "PRIVILEGES_REQUIRED_NONE" - The attacker is unauthorized prior to attack,
	// and therefore does not require any access to settings or files of the
	// vulnerable system to carry out an attack.
	//   "PRIVILEGES_REQUIRED_LOW" - The attacker requires privileges that provide
	// basic user capabilities that could normally affect only settings and files
	// owned by a user. Alternatively, an attacker with Low privileges has the
	// ability to access only non-sensitive resources.
	//   "PRIVILEGES_REQUIRED_HIGH" - The attacker requires privileges that provide
	// significant (e.g., administrative) control over the vulnerable component
	// allowing access to component-wide settings and files.
	PrivilegesRequired string `json:"privilegesRequired,omitempty"`
	// Scope: The Scope metric captures whether a vulnerability in one vulnerable
	// component impacts resources in components beyond its security scope.
	//
	// Possible values:
	//   "SCOPE_UNSPECIFIED" - Invalid value.
	//   "SCOPE_UNCHANGED" - An exploited vulnerability can only affect resources
	// managed by the same security authority.
	//   "SCOPE_CHANGED" - An exploited vulnerability can affect resources beyond
	// the security scope managed by the security authority of the vulnerable
	// component.
	Scope string `json:"scope,omitempty"`
	// UserInteraction: This metric captures the requirement for a human user,
	// other than the attacker, to participate in the successful compromise of the
	// vulnerable component.
	//
	// Possible values:
	//   "USER_INTERACTION_UNSPECIFIED" - Invalid value.
	//   "USER_INTERACTION_NONE" - The vulnerable system can be exploited without
	// interaction from any user.
	//   "USER_INTERACTION_REQUIRED" - Successful exploitation of this
	// vulnerability requires a user to take some action before the vulnerability
	// can be exploited.
	UserInteraction string `json:"userInteraction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttackComplexity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttackComplexity") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CVSSv3) MarshalJSON() ([]byte, error) {
	type NoMethod CVSSv3
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CVSSv3) UnmarshalJSON(data []byte) error {
	type NoMethod CVSSv3
	var s1 struct {
		BaseScore           gensupport.JSONFloat64 `json:"baseScore"`
		ExploitabilityScore gensupport.JSONFloat64 `json:"exploitabilityScore"`
		ImpactScore         gensupport.JSONFloat64 `json:"impactScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BaseScore = float64(s1.BaseScore)
	s.ExploitabilityScore = float64(s1.ExploitabilityScore)
	s.ImpactScore = float64(s1.ImpactScore)
	return nil
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// CancelPatchJobRequest: Message for canceling a patch job.
type CancelPatchJobRequest struct {
}

// Date: Represents a whole or partial calendar date, such as a birthday. The
// time of day and time zone are either specified elsewhere or are
// insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// ExecStep: A step that runs an executable for a PatchJob.
type ExecStep struct {
	// LinuxExecStepConfig: The ExecStepConfig for all Linux VMs targeted by the
	// PatchJob.
	LinuxExecStepConfig *ExecStepConfig `json:"linuxExecStepConfig,omitempty"`
	// WindowsExecStepConfig: The ExecStepConfig for all Windows VMs targeted by
	// the PatchJob.
	WindowsExecStepConfig *ExecStepConfig `json:"windowsExecStepConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LinuxExecStepConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LinuxExecStepConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecStep) MarshalJSON() ([]byte, error) {
	type NoMethod ExecStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecStepConfig: Common configurations for an ExecStep.
type ExecStepConfig struct {
	// AllowedSuccessCodes: Defaults to [0]. A list of possible return values that
	// the execution can return to indicate a success.
	AllowedSuccessCodes []int64 `json:"allowedSuccessCodes,omitempty"`
	// GcsObject: A Cloud Storage object containing the executable.
	GcsObject *GcsObject `json:"gcsObject,omitempty"`
	// Interpreter: The script interpreter to use to run the script. If no
	// interpreter is specified the script will be executed directly, which will
	// likely only succeed for scripts with [shebang lines]
	// (https://en.wikipedia.org/wiki/Shebang_\(Unix\)).
	//
	// Possible values:
	//   "INTERPRETER_UNSPECIFIED" - If the interpreter is not specified, the value
	// defaults to `NONE`.
	//   "NONE" - Indicates that the file is run as follows on each operating
	// system: + For Linux VMs, the file is ran as an executable and the
	// interpreter might be parsed from the [shebang
	// line](https://wikipedia.org/wiki/Shebang_(Unix)) of the file. + For Windows
	// VM, this value is not supported.
	//   "SHELL" - Indicates that the file is run with `/bin/sh` on Linux and `cmd`
	// on Windows.
	//   "POWERSHELL" - Indicates that the file is run with PowerShell.
	Interpreter string `json:"interpreter,omitempty"`
	// LocalPath: An absolute path to the executable on the VM.
	LocalPath string `json:"localPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedSuccessCodes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedSuccessCodes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecStepConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ExecStepConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecutePatchJobRequest: A request message to initiate patching across
// Compute Engine instances.
type ExecutePatchJobRequest struct {
	// Description: Description of the patch job. Length of the description is
	// limited to 1024 characters.
	Description string `json:"description,omitempty"`
	// DisplayName: Display name for this patch job. This does not have to be
	// unique.
	DisplayName string `json:"displayName,omitempty"`
	// DryRun: If this patch is a dry-run only, instances are contacted but will do
	// nothing.
	DryRun bool `json:"dryRun,omitempty"`
	// Duration: Duration of the patch job. After the duration ends, the patch job
	// times out.
	Duration string `json:"duration,omitempty"`
	// InstanceFilter: Required. Instances to patch, either explicitly or filtered
	// by some criteria such as zone or labels.
	InstanceFilter *PatchInstanceFilter `json:"instanceFilter,omitempty"`
	// PatchConfig: Patch configuration being applied. If omitted, instances are
	// patched using the default configurations.
	PatchConfig *PatchConfig `json:"patchConfig,omitempty"`
	// Rollout: Rollout strategy of the patch job.
	Rollout *PatchRollout `json:"rollout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecutePatchJobRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExecutePatchJobRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FixedOrPercent: Message encapsulating a value that can be either absolute
// ("fixed") or relative ("percent") to a value.
type FixedOrPercent struct {
	// Fixed: Specifies a fixed value.
	Fixed int64 `json:"fixed,omitempty"`
	// Percent: Specifies the relative value defined as a percentage, which will be
	// multiplied by a reference value.
	Percent int64 `json:"percent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fixed") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fixed") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FixedOrPercent) MarshalJSON() ([]byte, error) {
	type NoMethod FixedOrPercent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GcsObject: Cloud Storage object representation.
type GcsObject struct {
	// Bucket: Required. Bucket of the Cloud Storage object.
	Bucket string `json:"bucket,omitempty"`
	// GenerationNumber: Required. Generation number of the Cloud Storage object.
	// This is used to ensure that the ExecStep specified by this PatchJob does not
	// change.
	GenerationNumber int64 `json:"generationNumber,omitempty,string"`
	// Object: Required. Name of the Cloud Storage object.
	Object string `json:"object,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GcsObject) MarshalJSON() ([]byte, error) {
	type NoMethod GcsObject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooSettings: Googet patching is performed by running `googet update`.
type GooSettings struct {
}

// GoogleCloudOsconfigV1__OSPolicyAssignmentOperationMetadata: OS policy
// assignment operation metadata provided by OS policy assignment API methods
// that return long running operations.
type GoogleCloudOsconfigV1__OSPolicyAssignmentOperationMetadata struct {
	// ApiMethod: The OS policy assignment API method.
	//
	// Possible values:
	//   "API_METHOD_UNSPECIFIED" - Invalid value
	//   "CREATE" - Create OS policy assignment API method
	//   "UPDATE" - Update OS policy assignment API method
	//   "DELETE" - Delete OS policy assignment API method
	ApiMethod string `json:"apiMethod,omitempty"`
	// OsPolicyAssignment: Reference to the `OSPolicyAssignment` API resource.
	// Format:
	// `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_polic
	// y_assignment_id@revision_id}`
	OsPolicyAssignment string `json:"osPolicyAssignment,omitempty"`
	// RolloutStartTime: Rollout start time
	RolloutStartTime string `json:"rolloutStartTime,omitempty"`
	// RolloutState: State of the rollout
	//
	// Possible values:
	//   "ROLLOUT_STATE_UNSPECIFIED" - Invalid value
	//   "IN_PROGRESS" - The rollout is in progress.
	//   "CANCELLING" - The rollout is being cancelled.
	//   "CANCELLED" - The rollout is cancelled.
	//   "SUCCEEDED" - The rollout has completed successfully.
	RolloutState string `json:"rolloutState,omitempty"`
	// RolloutUpdateTime: Rollout update time
	RolloutUpdateTime string `json:"rolloutUpdateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiMethod") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiMethod") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOsconfigV1__OSPolicyAssignmentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOsconfigV1__OSPolicyAssignmentOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudOsconfigV2beta__OperationMetadata: Represents the metadata of the
// long-running operation.
type GoogleCloudOsconfigV2beta__OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation. Operations that have been cancelled
	// successfully have Operation.error value with a google.rpc.Status.code of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOsconfigV2beta__OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOsconfigV2beta__OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Inventory: This API resource represents the available inventory data for a
// Compute Engine virtual machine (VM) instance at a given point in time. You
// can use this API resource to determine the inventory data of your VM. For
// more information, see Information provided by OS inventory management
// (https://cloud.google.com/compute/docs/instances/os-inventory-management#data-collected).
type Inventory struct {
	// Items: Inventory items related to the VM keyed by an opaque unique
	// identifier for each inventory item. The identifier is unique to each
	// distinct and addressable inventory item and will change, when there is a new
	// package version.
	Items map[string]InventoryItem `json:"items,omitempty"`
	// Name: Output only. The `Inventory` API resource name. Format:
	// `projects/{project_number}/locations/{location}/instances/{instance_id}/inven
	// tory`
	Name string `json:"name,omitempty"`
	// OsInfo: Base level operating system information for the VM.
	OsInfo *InventoryOsInfo `json:"osInfo,omitempty"`
	// UpdateTime: Output only. Timestamp of the last reported inventory for the
	// VM.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Inventory) MarshalJSON() ([]byte, error) {
	type NoMethod Inventory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InventoryItem: A single piece of inventory on a VM.
type InventoryItem struct {
	// AvailablePackage: Software package available to be installed on the VM
	// instance.
	AvailablePackage *InventorySoftwarePackage `json:"availablePackage,omitempty"`
	// CreateTime: When this inventory item was first detected.
	CreateTime string `json:"createTime,omitempty"`
	// Id: Identifier for this item, unique across items for this VM.
	Id string `json:"id,omitempty"`
	// InstalledPackage: Software package present on the VM instance.
	InstalledPackage *InventorySoftwarePackage `json:"installedPackage,omitempty"`
	// OriginType: The origin of this inventory item.
	//
	// Possible values:
	//   "ORIGIN_TYPE_UNSPECIFIED" - Invalid. An origin type must be specified.
	//   "INVENTORY_REPORT" - This inventory item was discovered as the result of
	// the agent reporting inventory via the reporting API.
	OriginType string `json:"originType,omitempty"`
	// Type: The specific type of inventory, correlating to its specific details.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Invalid. A type must be specified.
	//   "INSTALLED_PACKAGE" - This represents a package that is installed on the
	// VM.
	//   "AVAILABLE_PACKAGE" - This represents an update that is available for a
	// package.
	Type string `json:"type,omitempty"`
	// UpdateTime: When this inventory item was last modified.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvailablePackage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvailablePackage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InventoryItem) MarshalJSON() ([]byte, error) {
	type NoMethod InventoryItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InventoryOsInfo: Operating system information for the VM.
type InventoryOsInfo struct {
	// Architecture: The system architecture of the operating system.
	Architecture string `json:"architecture,omitempty"`
	// Hostname: The VM hostname.
	Hostname string `json:"hostname,omitempty"`
	// KernelRelease: The kernel release of the operating system.
	KernelRelease string `json:"kernelRelease,omitempty"`
	// KernelVersion: The kernel version of the operating system.
	KernelVersion string `json:"kernelVersion,omitempty"`
	// LongName: The operating system long name. For example 'Debian GNU/Linux 9'
	// or 'Microsoft Window Server 2019 Datacenter'.
	LongName string `json:"longName,omitempty"`
	// OsconfigAgentVersion: The current version of the OS Config agent running on
	// the VM.
	OsconfigAgentVersion string `json:"osconfigAgentVersion,omitempty"`
	// ShortName: The operating system short name. For example, 'windows' or
	// 'debian'.
	ShortName string `json:"shortName,omitempty"`
	// Version: The version of the operating system.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Architecture") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Architecture") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InventoryOsInfo) MarshalJSON() ([]byte, error) {
	type NoMethod InventoryOsInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InventorySoftwarePackage: Software package information of the operating
// system.
type InventorySoftwarePackage struct {
	// AptPackage: Details of an APT package. For details about the apt package
	// manager, see https://wiki.debian.org/Apt.
	AptPackage *InventoryVersionedPackage `json:"aptPackage,omitempty"`
	// CosPackage: Details of a COS package.
	CosPackage *InventoryVersionedPackage `json:"cosPackage,omitempty"`
	// GoogetPackage: Details of a Googet package. For details about the googet
	// package manager, see https://github.com/google/googet.
	GoogetPackage *InventoryVersionedPackage `json:"googetPackage,omitempty"`
	// QfePackage: Details of a Windows Quick Fix engineering package. See
	// https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
	// for info in Windows Quick Fix Engineering.
	QfePackage *InventoryWindowsQuickFixEngineeringPackage `json:"qfePackage,omitempty"`
	// WindowsApplication: Details of Windows Application.
	WindowsApplication *InventoryWindowsApplication `json:"windowsApplication,omitempty"`
	// WuaPackage: Details of a Windows Update package. See
	// https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for information
	// about Windows Update.
	WuaPackage *InventoryWindowsUpdatePackage `json:"wuaPackage,omitempty"`
	// YumPackage: Yum package info. For details about the yum package manager, see
	// https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
	YumPackage *InventoryVersionedPackage `json:"yumPackage,omitempty"`
	// ZypperPackage: Details of a Zypper package. For details about the Zypper
	// package manager, see https://en.opensuse.org/SDB:Zypper_manual.
	ZypperPackage *InventoryVersionedPackage `json:"zypperPackage,omitempty"`
	// ZypperPatch: Details of a Zypper patch. For details about the Zypper package
	// manager, see https://en.opensuse.org/SDB:Zypper_manual.
	ZypperPatch *InventoryZypperPatch `json:"zypperPatch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AptPackage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AptPackage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InventorySoftwarePackage) MarshalJSON() ([]byte, error) {
	type NoMethod InventorySoftwarePackage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InventoryVersionedPackage: Information related to the a standard versioned
// package. This includes package info for APT, Yum, Zypper, and Googet package
// managers.
type InventoryVersionedPackage struct {
	// Architecture: The system architecture this package is intended for.
	Architecture string `json:"architecture,omitempty"`
	// PackageName: The name of the package.
	PackageName string `json:"packageName,omitempty"`
	// Version: The version of the package.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Architecture") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Architecture") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InventoryVersionedPackage) MarshalJSON() ([]byte, error) {
	type NoMethod InventoryVersionedPackage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InventoryWindowsApplication: Contains information about a Windows
// application that is retrieved from the Windows Registry. For more
// information about these fields, see:
// https://docs.microsoft.com/en-us/windows/win32/msi/uninstall-registry-key
type InventoryWindowsApplication struct {
	// DisplayName: The name of the application or product.
	DisplayName string `json:"displayName,omitempty"`
	// DisplayVersion: The version of the product or application in string format.
	DisplayVersion string `json:"displayVersion,omitempty"`
	// HelpLink: The internet address for technical support.
	HelpLink string `json:"helpLink,omitempty"`
	// InstallDate: The last time this product received service. The value of this
	// property is replaced each time a patch is applied or removed from the
	// product or the command-line option is used to repair the product.
	InstallDate *Date `json:"installDate,omitempty"`
	// Publisher: The name of the manufacturer for the product or application.
	Publisher string `json:"publisher,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InventoryWindowsApplication) MarshalJSON() ([]byte, error) {
	type NoMethod InventoryWindowsApplication
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InventoryWindowsQuickFixEngineeringPackage: Information related to a Quick
// Fix Engineering package. Fields are taken from Windows QuickFixEngineering
// Interface and match the source names:
// https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
type InventoryWindowsQuickFixEngineeringPackage struct {
	// Caption: A short textual description of the QFE update.
	Caption string `json:"caption,omitempty"`
	// Description: A textual description of the QFE update.
	Description string `json:"description,omitempty"`
	// HotFixId: Unique identifier associated with a particular QFE update.
	HotFixId string `json:"hotFixId,omitempty"`
	// InstallTime: Date that the QFE update was installed. Mapped from
	// installed_on field.
	InstallTime string `json:"installTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Caption") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Caption") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InventoryWindowsQuickFixEngineeringPackage) MarshalJSON() ([]byte, error) {
	type NoMethod InventoryWindowsQuickFixEngineeringPackage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InventoryWindowsUpdatePackage: Details related to a Windows Update package.
// Field data and names are taken from Windows Update API IUpdate Interface:
// https://docs.microsoft.com/en-us/windows/win32/api/_wua/ Descriptive fields
// like title, and description are localized based on the locale of the VM
// being updated.
type InventoryWindowsUpdatePackage struct {
	// Categories: The categories that are associated with this update package.
	Categories []*InventoryWindowsUpdatePackageWindowsUpdateCategory `json:"categories,omitempty"`
	// Description: The localized description of the update package.
	Description string `json:"description,omitempty"`
	// KbArticleIds: A collection of Microsoft Knowledge Base article IDs that are
	// associated with the update package.
	KbArticleIds []string `json:"kbArticleIds,omitempty"`
	// LastDeploymentChangeTime: The last published date of the update, in (UTC)
	// date and time.
	LastDeploymentChangeTime string `json:"lastDeploymentChangeTime,omitempty"`
	// MoreInfoUrls: A collection of URLs that provide more information about the
	// update package.
	MoreInfoUrls []string `json:"moreInfoUrls,omitempty"`
	// RevisionNumber: The revision number of this update package.
	RevisionNumber int64 `json:"revisionNumber,omitempty"`
	// SupportUrl: A hyperlink to the language-specific support information for the
	// update.
	SupportUrl string `json:"supportUrl,omitempty"`
	// Title: The localized title of the update package.
	Title string `json:"title,omitempty"`
	// UpdateId: Gets the identifier of an update package. Stays the same across
	// revisions.
	UpdateId string `json:"updateId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Categories") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Categories") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InventoryWindowsUpdatePackage) MarshalJSON() ([]byte, error) {
	type NoMethod InventoryWindowsUpdatePackage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InventoryWindowsUpdatePackageWindowsUpdateCategory: Categories specified by
// the Windows Update.
type InventoryWindowsUpdatePackageWindowsUpdateCategory struct {
	// Id: The identifier of the windows update category.
	Id string `json:"id,omitempty"`
	// Name: The name of the windows update category.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InventoryWindowsUpdatePackageWindowsUpdateCategory) MarshalJSON() ([]byte, error) {
	type NoMethod InventoryWindowsUpdatePackageWindowsUpdateCategory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InventoryZypperPatch: Details related to a Zypper Patch.
type InventoryZypperPatch struct {
	// Category: The category of the patch.
	Category string `json:"category,omitempty"`
	// PatchName: The name of the patch.
	PatchName string `json:"patchName,omitempty"`
	// Severity: The severity specified for this patch
	Severity string `json:"severity,omitempty"`
	// Summary: Any summary information provided about this patch.
	Summary string `json:"summary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Category") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InventoryZypperPatch) MarshalJSON() ([]byte, error) {
	type NoMethod InventoryZypperPatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListInventoriesResponse: A response message for listing inventory data for
// all VMs in a specified location.
type ListInventoriesResponse struct {
	// Inventories: List of inventory objects.
	Inventories []*Inventory `json:"inventories,omitempty"`
	// NextPageToken: The pagination token to retrieve the next page of inventory
	// objects.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Inventories") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Inventories") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListInventoriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListInventoriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOSPolicyAssignmentReportsResponse: A response message for listing OS
// Policy assignment reports including the page of results and page token.
type ListOSPolicyAssignmentReportsResponse struct {
	// NextPageToken: The pagination token to retrieve the next page of OS policy
	// assignment report objects.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// OsPolicyAssignmentReports: List of OS policy assignment reports.
	OsPolicyAssignmentReports []*OSPolicyAssignmentReport `json:"osPolicyAssignmentReports,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOSPolicyAssignmentReportsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOSPolicyAssignmentReportsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOSPolicyAssignmentRevisionsResponse: A response message for listing all
// revisions for a OS policy assignment.
type ListOSPolicyAssignmentRevisionsResponse struct {
	// NextPageToken: The pagination token to retrieve the next page of OS policy
	// assignment revisions.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// OsPolicyAssignments: The OS policy assignment revisions
	OsPolicyAssignments []*OSPolicyAssignment `json:"osPolicyAssignments,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOSPolicyAssignmentRevisionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOSPolicyAssignmentRevisionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOSPolicyAssignmentsResponse: A response message for listing all
// assignments under given parent.
type ListOSPolicyAssignmentsResponse struct {
	// NextPageToken: The pagination token to retrieve the next page of OS policy
	// assignments.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// OsPolicyAssignments: The list of assignments
	OsPolicyAssignments []*OSPolicyAssignment `json:"osPolicyAssignments,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOSPolicyAssignmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOSPolicyAssignmentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPatchDeploymentsResponse: A response message for listing patch
// deployments.
type ListPatchDeploymentsResponse struct {
	// NextPageToken: A pagination token that can be used to get the next page of
	// patch deployments.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PatchDeployments: The list of patch deployments.
	PatchDeployments []*PatchDeployment `json:"patchDeployments,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPatchDeploymentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPatchDeploymentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPatchJobInstanceDetailsResponse: A response message for listing the
// instances details for a patch job.
type ListPatchJobInstanceDetailsResponse struct {
	// NextPageToken: A pagination token that can be used to get the next page of
	// results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PatchJobInstanceDetails: A list of instance status.
	PatchJobInstanceDetails []*PatchJobInstanceDetails `json:"patchJobInstanceDetails,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPatchJobInstanceDetailsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPatchJobInstanceDetailsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPatchJobsResponse: A response message for listing patch jobs.
type ListPatchJobsResponse struct {
	// NextPageToken: A pagination token that can be used to get the next page of
	// results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PatchJobs: The list of patch jobs.
	PatchJobs []*PatchJob `json:"patchJobs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPatchJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPatchJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListVulnerabilityReportsResponse: A response message for listing
// vulnerability reports for all VM instances in the specified location.
type ListVulnerabilityReportsResponse struct {
	// NextPageToken: The pagination token to retrieve the next page of
	// vulnerabilityReports object.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// VulnerabilityReports: List of vulnerabilityReport objects.
	VulnerabilityReports []*VulnerabilityReport `json:"vulnerabilityReports,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListVulnerabilityReportsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListVulnerabilityReportsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MonthlySchedule: Represents a monthly schedule. An example of a valid
// monthly schedule is "on the third Tuesday of the month" or "on the 15th of
// the month".
type MonthlySchedule struct {
	// MonthDay: Required. One day of the month. 1-31 indicates the 1st to the 31st
	// day. -1 indicates the last day of the month. Months without the target day
	// will be skipped. For example, a schedule to run "every month on the 31st"
	// will not run in February, April, June, etc.
	MonthDay int64 `json:"monthDay,omitempty"`
	// WeekDayOfMonth: Required. Week day in a month.
	WeekDayOfMonth *WeekDayOfMonth `json:"weekDayOfMonth,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MonthDay") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MonthDay") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MonthlySchedule) MarshalJSON() ([]byte, error) {
	type NoMethod MonthlySchedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicy: An OS policy defines the desired state configuration for a VM.
type OSPolicy struct {
	// AllowNoResourceGroupMatch: This flag determines the OS policy compliance
	// status when none of the resource groups within the policy are applicable for
	// a VM. Set this value to `true` if the policy needs to be reported as
	// compliant even if the policy has nothing to validate or enforce.
	AllowNoResourceGroupMatch bool `json:"allowNoResourceGroupMatch,omitempty"`
	// Description: Policy description. Length of the description is limited to
	// 1024 characters.
	Description string `json:"description,omitempty"`
	// Id: Required. The id of the OS policy with the following restrictions: *
	// Must contain only lowercase letters, numbers, and hyphens. * Must start with
	// a letter. * Must be between 1-63 characters. * Must end with a number or a
	// letter. * Must be unique within the assignment.
	Id string `json:"id,omitempty"`
	// Mode: Required. Policy mode
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Invalid mode
	//   "VALIDATION" - This mode checks if the configuration resources in the
	// policy are in their desired state. No actions are performed if they are not
	// in the desired state. This mode is used for reporting purposes.
	//   "ENFORCEMENT" - This mode checks if the configuration resources in the
	// policy are in their desired state, and if not, enforces the desired state.
	Mode string `json:"mode,omitempty"`
	// ResourceGroups: Required. List of resource groups for the policy. For a
	// particular VM, resource groups are evaluated in the order specified and the
	// first resource group that is applicable is selected and the rest are
	// ignored. If none of the resource groups are applicable for a VM, the VM is
	// considered to be non-compliant w.r.t this policy. This behavior can be
	// toggled by the flag `allow_no_resource_group_match`
	ResourceGroups []*OSPolicyResourceGroup `json:"resourceGroups,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowNoResourceGroupMatch")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowNoResourceGroupMatch") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyAssignment: OS policy assignment is an API resource that is used to
// apply a set of OS policies to a dynamically targeted group of Compute Engine
// VM instances. An OS policy is used to define the desired state configuration
// for a Compute Engine VM instance through a set of configuration resources
// that provide capabilities such as installing or removing software packages,
// or executing a script. For more information about the OS policy resource
// definitions and examples, see OS policy and OS policy assignment
// (https://cloud.google.com/compute/docs/os-configuration-management/working-with-os-policies).
type OSPolicyAssignment struct {
	// Baseline: Output only. Indicates that this revision has been successfully
	// rolled out in this zone and new VMs will be assigned OS policies from this
	// revision. For a given OS policy assignment, there is only one revision with
	// a value of `true` for this field.
	Baseline bool `json:"baseline,omitempty"`
	// Deleted: Output only. Indicates that this revision deletes the OS policy
	// assignment.
	Deleted bool `json:"deleted,omitempty"`
	// Description: OS policy assignment description. Length of the description is
	// limited to 1024 characters.
	Description string `json:"description,omitempty"`
	// Etag: The etag for this OS policy assignment. If this is provided on update,
	// it must match the server's etag.
	Etag string `json:"etag,omitempty"`
	// InstanceFilter: Required. Filter to select VMs.
	InstanceFilter *OSPolicyAssignmentInstanceFilter `json:"instanceFilter,omitempty"`
	// Name: Resource name. Format:
	// `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_polic
	// y_assignment_id}` This field is ignored when you create an OS policy
	// assignment.
	Name string `json:"name,omitempty"`
	// OsPolicies: Required. List of OS policies to be applied to the VMs.
	OsPolicies []*OSPolicy `json:"osPolicies,omitempty"`
	// Reconciling: Output only. Indicates that reconciliation is in progress for
	// the revision. This value is `true` when the `rollout_state` is one of: *
	// IN_PROGRESS * CANCELLING
	Reconciling bool `json:"reconciling,omitempty"`
	// RevisionCreateTime: Output only. The timestamp that the revision was
	// created.
	RevisionCreateTime string `json:"revisionCreateTime,omitempty"`
	// RevisionId: Output only. The assignment revision ID A new revision is
	// committed whenever a rollout is triggered for a OS policy assignment
	RevisionId string `json:"revisionId,omitempty"`
	// Rollout: Required. Rollout to deploy the OS policy assignment. A rollout is
	// triggered in the following situations: 1) OSPolicyAssignment is created. 2)
	// OSPolicyAssignment is updated and the update contains changes to one of the
	// following fields: - instance_filter - os_policies 3) OSPolicyAssignment is
	// deleted.
	Rollout *OSPolicyAssignmentRollout `json:"rollout,omitempty"`
	// RolloutState: Output only. OS policy assignment rollout state
	//
	// Possible values:
	//   "ROLLOUT_STATE_UNSPECIFIED" - Invalid value
	//   "IN_PROGRESS" - The rollout is in progress.
	//   "CANCELLING" - The rollout is being cancelled.
	//   "CANCELLED" - The rollout is cancelled.
	//   "SUCCEEDED" - The rollout has completed successfully.
	RolloutState string `json:"rolloutState,omitempty"`
	// Uid: Output only. Server generated unique id for the OS policy assignment
	// resource.
	Uid string `json:"uid,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Baseline") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Baseline") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyAssignment) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyAssignment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyAssignmentInstanceFilter: Filters to select target VMs for an
// assignment. If more than one filter criteria is specified below, a VM will
// be selected if and only if it satisfies all of them.
type OSPolicyAssignmentInstanceFilter struct {
	// All: Target all VMs in the project. If true, no other criteria is permitted.
	All bool `json:"all,omitempty"`
	// ExclusionLabels: List of label sets used for VM exclusion. If the list has
	// more than one label set, the VM is excluded if any of the label sets are
	// applicable for the VM.
	ExclusionLabels []*OSPolicyAssignmentLabelSet `json:"exclusionLabels,omitempty"`
	// InclusionLabels: List of label sets used for VM inclusion. If the list has
	// more than one `LabelSet`, the VM is included if any of the label sets are
	// applicable for the VM.
	InclusionLabels []*OSPolicyAssignmentLabelSet `json:"inclusionLabels,omitempty"`
	// Inventories: List of inventories to select VMs. A VM is selected if its
	// inventory data matches at least one of the following inventories.
	Inventories []*OSPolicyAssignmentInstanceFilterInventory `json:"inventories,omitempty"`
	// ForceSendFields is a list of field names (e.g. "All") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "All") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyAssignmentInstanceFilter) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyAssignmentInstanceFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyAssignmentInstanceFilterInventory: VM inventory details.
type OSPolicyAssignmentInstanceFilterInventory struct {
	// OsShortName: Required. The OS short name
	OsShortName string `json:"osShortName,omitempty"`
	// OsVersion: The OS version Prefix matches are supported if asterisk(*) is
	// provided as the last character. For example, to match all versions with a
	// major version of `7`, specify the following value for this field `7.*` An
	// empty string matches all OS versions.
	OsVersion string `json:"osVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OsShortName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OsShortName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyAssignmentInstanceFilterInventory) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyAssignmentInstanceFilterInventory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyAssignmentLabelSet: Message representing label set. * A label is a
// key value pair set for a VM. * A LabelSet is a set of labels. * Labels
// within a LabelSet are ANDed. In other words, a LabelSet is applicable for a
// VM only if it matches all the labels in the LabelSet. * Example: A LabelSet
// with 2 labels: `env=prod` and `type=webserver` will only be applicable for
// those VMs with both labels present.
type OSPolicyAssignmentLabelSet struct {
	// Labels: Labels are identified by key/value pairs in this map. A VM should
	// contain all the key/value pairs specified in this map to be selected.
	Labels map[string]string `json:"labels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyAssignmentLabelSet) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyAssignmentLabelSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyAssignmentOperationMetadata: OS policy assignment operation metadata
// provided by OS policy assignment API methods that return long running
// operations.
type OSPolicyAssignmentOperationMetadata struct {
	// ApiMethod: The OS policy assignment API method.
	//
	// Possible values:
	//   "API_METHOD_UNSPECIFIED" - Invalid value
	//   "CREATE" - Create OS policy assignment API method
	//   "UPDATE" - Update OS policy assignment API method
	//   "DELETE" - Delete OS policy assignment API method
	ApiMethod string `json:"apiMethod,omitempty"`
	// OsPolicyAssignment: Reference to the `OSPolicyAssignment` API resource.
	// Format:
	// `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_polic
	// y_assignment_id@revision_id}`
	OsPolicyAssignment string `json:"osPolicyAssignment,omitempty"`
	// RolloutStartTime: Rollout start time
	RolloutStartTime string `json:"rolloutStartTime,omitempty"`
	// RolloutState: State of the rollout
	//
	// Possible values:
	//   "ROLLOUT_STATE_UNSPECIFIED" - Invalid value
	//   "IN_PROGRESS" - The rollout is in progress.
	//   "CANCELLING" - The rollout is being cancelled.
	//   "CANCELLED" - The rollout is cancelled.
	//   "SUCCEEDED" - The rollout has completed successfully.
	RolloutState string `json:"rolloutState,omitempty"`
	// RolloutUpdateTime: Rollout update time
	RolloutUpdateTime string `json:"rolloutUpdateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiMethod") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiMethod") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyAssignmentOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyAssignmentOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyAssignmentReport: A report of the OS policy assignment status for a
// given instance.
type OSPolicyAssignmentReport struct {
	// Instance: The Compute Engine VM instance name.
	Instance string `json:"instance,omitempty"`
	// LastRunId: Unique identifier of the last attempted run to apply the OS
	// policies associated with this assignment on the VM. This ID is logged by the
	// OS Config agent while applying the OS policies associated with this
	// assignment on the VM. NOTE: If the service is unable to successfully connect
	// to the agent for this run, then this id will not be available in the agent
	// logs.
	LastRunId string `json:"lastRunId,omitempty"`
	// Name: The `OSPolicyAssignmentReport` API resource name. Format:
	// `projects/{project_number}/locations/{location}/instances/{instance_id}/osPol
	// icyAssignments/{os_policy_assignment_id}/report`
	Name string `json:"name,omitempty"`
	// OsPolicyAssignment: Reference to the `OSPolicyAssignment` API resource that
	// the `OSPolicy` belongs to. Format:
	// `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_polic
	// y_assignment_id@revision_id}`
	OsPolicyAssignment string `json:"osPolicyAssignment,omitempty"`
	// OsPolicyCompliances: Compliance data for each `OSPolicy` that is applied to
	// the VM.
	OsPolicyCompliances []*OSPolicyAssignmentReportOSPolicyCompliance `json:"osPolicyCompliances,omitempty"`
	// UpdateTime: Timestamp for when the report was last generated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instance") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyAssignmentReport) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyAssignmentReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyAssignmentReportOSPolicyCompliance: Compliance data for an OS policy
type OSPolicyAssignmentReportOSPolicyCompliance struct {
	// ComplianceState: The compliance state of the OS policy.
	//
	// Possible values:
	//   "UNKNOWN" - The policy is in an unknown compliance state. Refer to the
	// field `compliance_state_reason` to learn the exact reason for the policy to
	// be in this compliance state.
	//   "COMPLIANT" - Policy is compliant. The policy is compliant if all the
	// underlying resources are also compliant.
	//   "NON_COMPLIANT" - Policy is non-compliant. The policy is non-compliant if
	// one or more underlying resources are non-compliant.
	ComplianceState string `json:"complianceState,omitempty"`
	// ComplianceStateReason: The reason for the OS policy to be in an unknown
	// compliance state. This field is always populated when `compliance_state` is
	// `UNKNOWN`. If populated, the field can contain one of the following values:
	// * `vm-not-running`: The VM was not running. *
	// `os-policies-not-supported-by-agent`: The version of the OS Config agent
	// running on the VM does not support running OS policies. *
	// `no-agent-detected`: The OS Config agent is not detected for the VM. *
	// `resource-execution-errors`: The OS Config agent encountered errors while
	// executing one or more resources in the policy. See
	// `os_policy_resource_compliances` for details. * `task-timeout`: The task
	// sent to the agent to apply the policy timed out. * `unexpected-agent-state`:
	// The OS Config agent did not report the final status of the task that
	// attempted to apply the policy. Instead, the agent unexpectedly started
	// working on a different task. This mostly happens when the agent or VM
	// unexpectedly restarts while applying OS policies. *
	// `internal-service-errors`: Internal service errors were encountered while
	// attempting to apply the policy. * `os-policy-execution-pending`: OS policy
	// was assigned to the given VM, but was not executed yet. Typically this is a
	// transient condition that will go away after the next policy execution cycle.
	ComplianceStateReason string `json:"complianceStateReason,omitempty"`
	// OsPolicyId: The OS policy id
	OsPolicyId string `json:"osPolicyId,omitempty"`
	// OsPolicyResourceCompliances: Compliance data for each resource within the
	// policy that is applied to the VM.
	OsPolicyResourceCompliances []*OSPolicyAssignmentReportOSPolicyComplianceOSPolicyResourceCompliance `json:"osPolicyResourceCompliances,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ComplianceState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComplianceState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyAssignmentReportOSPolicyCompliance) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyAssignmentReportOSPolicyCompliance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyAssignmentReportOSPolicyComplianceOSPolicyResourceCompliance:
// Compliance data for an OS policy resource.
type OSPolicyAssignmentReportOSPolicyComplianceOSPolicyResourceCompliance struct {
	// ComplianceState: The compliance state of the resource.
	//
	// Possible values:
	//   "UNKNOWN" - The resource is in an unknown compliance state. To get more
	// details about why the policy is in this state, review the output of the
	// `compliance_state_reason` field.
	//   "COMPLIANT" - Resource is compliant.
	//   "NON_COMPLIANT" - Resource is non-compliant.
	ComplianceState string `json:"complianceState,omitempty"`
	// ComplianceStateReason: A reason for the resource to be in the given
	// compliance state. This field is always populated when `compliance_state` is
	// `UNKNOWN`. The following values are supported when `compliance_state ==
	// UNKNOWN` * `execution-errors`: Errors were encountered by the agent while
	// executing the resource and the compliance state couldn't be determined. *
	// `execution-skipped-by-agent`: Resource execution was skipped by the agent
	// because errors were encountered while executing prior resources in the OS
	// policy. * `os-policy-execution-attempt-failed`: The execution of the OS
	// policy containing this resource failed and the compliance state couldn't be
	// determined. * `os-policy-execution-pending`: OS policy that owns this
	// resource was assigned to the given VM, but was not executed yet.
	ComplianceStateReason string `json:"complianceStateReason,omitempty"`
	// ConfigSteps: Ordered list of configuration completed by the agent for the OS
	// policy resource.
	ConfigSteps []*OSPolicyAssignmentReportOSPolicyComplianceOSPolicyResourceComplianceOSPolicyResourceConfigStep `json:"configSteps,omitempty"`
	// ExecResourceOutput: ExecResource specific output.
	ExecResourceOutput *OSPolicyAssignmentReportOSPolicyComplianceOSPolicyResourceComplianceExecResourceOutput `json:"execResourceOutput,omitempty"`
	// OsPolicyResourceId: The ID of the OS policy resource.
	OsPolicyResourceId string `json:"osPolicyResourceId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ComplianceState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComplianceState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyAssignmentReportOSPolicyComplianceOSPolicyResourceCompliance) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyAssignmentReportOSPolicyComplianceOSPolicyResourceCompliance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyAssignmentReportOSPolicyComplianceOSPolicyResourceComplianceExecResou
// rceOutput: ExecResource specific output.
type OSPolicyAssignmentReportOSPolicyComplianceOSPolicyResourceComplianceExecResourceOutput struct {
	// EnforcementOutput: Output from enforcement phase output file (if run).
	// Output size is limited to 100K bytes.
	EnforcementOutput string `json:"enforcementOutput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnforcementOutput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnforcementOutput") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyAssignmentReportOSPolicyComplianceOSPolicyResourceComplianceExecResourceOutput) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyAssignmentReportOSPolicyComplianceOSPolicyResourceComplianceExecResourceOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyAssignmentReportOSPolicyComplianceOSPolicyResourceComplianceOSPolicyR
// esourceConfigStep: Step performed by the OS Config agent for configuring an
// `OSPolicy` resource to its desired state.
type OSPolicyAssignmentReportOSPolicyComplianceOSPolicyResourceComplianceOSPolicyResourceConfigStep struct {
	// ErrorMessage: An error message recorded during the execution of this step.
	// Only populated if errors were encountered during this step execution.
	ErrorMessage string `json:"errorMessage,omitempty"`
	// Type: Configuration step type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "VALIDATION" - Checks for resource conflicts such as schema errors.
	//   "DESIRED_STATE_CHECK" - Checks the current status of the desired state for
	// a resource.
	//   "DESIRED_STATE_ENFORCEMENT" - Enforces the desired state for a resource
	// that is not in desired state.
	//   "DESIRED_STATE_CHECK_POST_ENFORCEMENT" - Re-checks the status of the
	// desired state. This check is done for a resource after the enforcement of
	// all OS policies. This step is used to determine the final desired state
	// status for the resource. It accounts for any resources that might have
	// drifted from their desired state due to side effects from executing other
	// resources.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorMessage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorMessage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyAssignmentReportOSPolicyComplianceOSPolicyResourceComplianceOSPolicyResourceConfigStep) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyAssignmentReportOSPolicyComplianceOSPolicyResourceComplianceOSPolicyResourceConfigStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyAssignmentRollout: Message to configure the rollout at the zonal
// level for the OS policy assignment.
type OSPolicyAssignmentRollout struct {
	// DisruptionBudget: Required. The maximum number (or percentage) of VMs per
	// zone to disrupt at any given moment.
	DisruptionBudget *FixedOrPercent `json:"disruptionBudget,omitempty"`
	// MinWaitDuration: Required. This determines the minimum duration of time to
	// wait after the configuration changes are applied through the current
	// rollout. A VM continues to count towards the `disruption_budget` at least
	// until this duration of time has passed after configuration changes are
	// applied.
	MinWaitDuration string `json:"minWaitDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisruptionBudget") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisruptionBudget") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyAssignmentRollout) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyAssignmentRollout
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyInventoryFilter: Filtering criteria to select VMs based on inventory
// details.
type OSPolicyInventoryFilter struct {
	// OsShortName: Required. The OS short name
	OsShortName string `json:"osShortName,omitempty"`
	// OsVersion: The OS version Prefix matches are supported if asterisk(*) is
	// provided as the last character. For example, to match all versions with a
	// major version of `7`, specify the following value for this field `7.*` An
	// empty string matches all OS versions.
	OsVersion string `json:"osVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OsShortName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OsShortName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyInventoryFilter) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyInventoryFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResource: An OS policy resource is used to define the desired state
// configuration and provides a specific functionality like installing/removing
// packages, executing a script etc. The system ensures that resources are
// always in their desired state by taking necessary actions if they have
// drifted from their desired state.
type OSPolicyResource struct {
	// Exec: Exec resource
	Exec *OSPolicyResourceExecResource `json:"exec,omitempty"`
	// File: File resource
	File *OSPolicyResourceFileResource `json:"file,omitempty"`
	// Id: Required. The id of the resource with the following restrictions: * Must
	// contain only lowercase letters, numbers, and hyphens. * Must start with a
	// letter. * Must be between 1-63 characters. * Must end with a number or a
	// letter. * Must be unique within the OS policy.
	Id string `json:"id,omitempty"`
	// Pkg: Package resource
	Pkg *OSPolicyResourcePackageResource `json:"pkg,omitempty"`
	// Repository: Package repository resource
	Repository *OSPolicyResourceRepositoryResource `json:"repository,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Exec") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Exec") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResource) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourceExecResource: A resource that allows executing scripts on
// the VM. The `ExecResource` has 2 stages: `validate` and `enforce` and both
// stages accept a script as an argument to execute. When the `ExecResource` is
// applied by the agent, it first executes the script in the `validate` stage.
// The `validate` stage can signal that the `ExecResource` is already in the
// desired state by returning an exit code of `100`. If the `ExecResource` is
// not in the desired state, it should return an exit code of `101`. Any other
// exit code returned by this stage is considered an error. If the
// `ExecResource` is not in the desired state based on the exit code from the
// `validate` stage, the agent proceeds to execute the script from the
// `enforce` stage. If the `ExecResource` is already in the desired state, the
// `enforce` stage will not be run. Similar to `validate` stage, the `enforce`
// stage should return an exit code of `100` to indicate that the resource in
// now in its desired state. Any other exit code is considered an error. NOTE:
// An exit code of `100` was chosen over `0` (and `101` vs `1`) to have an
// explicit indicator of `in desired state`, `not in desired state` and errors.
// Because, for example, Powershell will always return an exit code of `0`
// unless an `exit` statement is provided in the script. So, for reasons of
// consistency and being explicit, exit codes `100` and `101` were chosen.
type OSPolicyResourceExecResource struct {
	// Enforce: What to run to bring this resource into the desired state. An exit
	// code of 100 indicates "success", any other exit code indicates a failure
	// running enforce.
	Enforce *OSPolicyResourceExecResourceExec `json:"enforce,omitempty"`
	// Validate: Required. What to run to validate this resource is in the desired
	// state. An exit code of 100 indicates "in desired state", and exit code of
	// 101 indicates "not in desired state". Any other exit code indicates a
	// failure running validate.
	Validate *OSPolicyResourceExecResourceExec `json:"validate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enforce") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enforce") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourceExecResource) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourceExecResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourceExecResourceExec: A file or script to execute.
type OSPolicyResourceExecResourceExec struct {
	// Args: Optional arguments to pass to the source during execution.
	Args []string `json:"args,omitempty"`
	// File: A remote or local file.
	File *OSPolicyResourceFile `json:"file,omitempty"`
	// Interpreter: Required. The script interpreter to use.
	//
	// Possible values:
	//   "INTERPRETER_UNSPECIFIED" - Invalid value, the request will return
	// validation error.
	//   "NONE" - If an interpreter is not specified, the source is executed
	// directly. This execution, without an interpreter, only succeeds for
	// executables and scripts that have shebang lines.
	//   "SHELL" - Indicates that the script runs with `/bin/sh` on Linux and
	// `cmd.exe` on Windows.
	//   "POWERSHELL" - Indicates that the script runs with PowerShell.
	Interpreter string `json:"interpreter,omitempty"`
	// OutputFilePath: Only recorded for enforce Exec. Path to an output file (that
	// is created by this Exec) whose content will be recorded in
	// OSPolicyResourceCompliance after a successful run. Absence or failure to
	// read this file will result in this ExecResource being non-compliant. Output
	// file size is limited to 500K bytes.
	OutputFilePath string `json:"outputFilePath,omitempty"`
	// Script: An inline script. The size of the script is limited to 32KiB.
	Script string `json:"script,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Args") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Args") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourceExecResourceExec) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourceExecResourceExec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourceFile: A remote or local file.
type OSPolicyResourceFile struct {
	// AllowInsecure: Defaults to false. When false, files are subject to
	// validations based on the file type: Remote: A checksum must be specified.
	// Cloud Storage: An object generation number must be specified.
	AllowInsecure bool `json:"allowInsecure,omitempty"`
	// Gcs: A Cloud Storage object.
	Gcs *OSPolicyResourceFileGcs `json:"gcs,omitempty"`
	// LocalPath: A local path within the VM to use.
	LocalPath string `json:"localPath,omitempty"`
	// Remote: A generic remote file.
	Remote *OSPolicyResourceFileRemote `json:"remote,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowInsecure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowInsecure") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourceFile) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourceFile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourceFileGcs: Specifies a file available as a Cloud Storage
// Object.
type OSPolicyResourceFileGcs struct {
	// Bucket: Required. Bucket of the Cloud Storage object.
	Bucket string `json:"bucket,omitempty"`
	// Generation: Generation number of the Cloud Storage object.
	Generation int64 `json:"generation,omitempty,string"`
	// Object: Required. Name of the Cloud Storage object.
	Object string `json:"object,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourceFileGcs) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourceFileGcs
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourceFileRemote: Specifies a file available via some URI.
type OSPolicyResourceFileRemote struct {
	// Sha256Checksum: SHA256 checksum of the remote file.
	Sha256Checksum string `json:"sha256Checksum,omitempty"`
	// Uri: Required. URI from which to fetch the object. It should contain both
	// the protocol and path following the format `{protocol}://{location}`.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Sha256Checksum") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Sha256Checksum") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourceFileRemote) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourceFileRemote
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourceFileResource: A resource that manages the state of a file.
type OSPolicyResourceFileResource struct {
	// Content: A a file with this content. The size of the content is limited to
	// 32KiB.
	Content string `json:"content,omitempty"`
	// File: A remote or local source.
	File *OSPolicyResourceFile `json:"file,omitempty"`
	// Path: Required. The absolute path of the file within the VM.
	Path string `json:"path,omitempty"`
	// Permissions: Consists of three octal digits which represent, in order, the
	// permissions of the owner, group, and other users for the file (similarly to
	// the numeric mode used in the linux chmod utility). Each digit represents a
	// three bit number with the 4 bit corresponding to the read permissions, the 2
	// bit corresponds to the write bit, and the one bit corresponds to the execute
	// permission. Default behavior is 755. Below are some examples of permissions
	// and their associated values: read, write, and execute: 7 read and execute: 5
	// read and write: 6 read only: 4
	Permissions string `json:"permissions,omitempty"`
	// State: Required. Desired state of the file.
	//
	// Possible values:
	//   "DESIRED_STATE_UNSPECIFIED" - Unspecified is invalid.
	//   "PRESENT" - Ensure file at path is present.
	//   "ABSENT" - Ensure file at path is absent.
	//   "CONTENTS_MATCH" - Ensure the contents of the file at path matches. If the
	// file does not exist it will be created.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourceFileResource) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourceFileResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourceGroup: Resource groups provide a mechanism to group OS
// policy resources. Resource groups enable OS policy authors to create a
// single OS policy to be applied to VMs running different operating Systems.
// When the OS policy is applied to a target VM, the appropriate resource group
// within the OS policy is selected based on the `OSFilter` specified within
// the resource group.
type OSPolicyResourceGroup struct {
	// InventoryFilters: List of inventory filters for the resource group. The
	// resources in this resource group are applied to the target VM if it
	// satisfies at least one of the following inventory filters. For example, to
	// apply this resource group to VMs running either `RHEL` or `CentOS` operating
	// systems, specify 2 items for the list with following values:
	// inventory_filters[0].os_short_name='rhel' and
	// inventory_filters[1].os_short_name='centos' If the list is empty, this
	// resource group will be applied to the target VM unconditionally.
	InventoryFilters []*OSPolicyInventoryFilter `json:"inventoryFilters,omitempty"`
	// Resources: Required. List of resources configured for this resource group.
	// The resources are executed in the exact order specified here.
	Resources []*OSPolicyResource `json:"resources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InventoryFilters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InventoryFilters") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourceGroup) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourceGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourcePackageResource: A resource that manages a system package.
type OSPolicyResourcePackageResource struct {
	// Apt: A package managed by Apt.
	Apt *OSPolicyResourcePackageResourceAPT `json:"apt,omitempty"`
	// Deb: A deb package file.
	Deb *OSPolicyResourcePackageResourceDeb `json:"deb,omitempty"`
	// DesiredState: Required. The desired state the agent should maintain for this
	// package.
	//
	// Possible values:
	//   "DESIRED_STATE_UNSPECIFIED" - Unspecified is invalid.
	//   "INSTALLED" - Ensure that the package is installed.
	//   "REMOVED" - The agent ensures that the package is not installed and
	// uninstalls it if detected.
	DesiredState string `json:"desiredState,omitempty"`
	// Googet: A package managed by GooGet.
	Googet *OSPolicyResourcePackageResourceGooGet `json:"googet,omitempty"`
	// Msi: An MSI package.
	Msi *OSPolicyResourcePackageResourceMSI `json:"msi,omitempty"`
	// Rpm: An rpm package file.
	Rpm *OSPolicyResourcePackageResourceRPM `json:"rpm,omitempty"`
	// Yum: A package managed by YUM.
	Yum *OSPolicyResourcePackageResourceYUM `json:"yum,omitempty"`
	// Zypper: A package managed by Zypper.
	Zypper *OSPolicyResourcePackageResourceZypper `json:"zypper,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Apt") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Apt") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourcePackageResource) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourcePackageResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourcePackageResourceAPT: A package managed by APT. - install:
// `apt-get update && apt-get -y install [name]` - remove: `apt-get -y remove
// [name]`
type OSPolicyResourcePackageResourceAPT struct {
	// Name: Required. Package name.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourcePackageResourceAPT) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourcePackageResourceAPT
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourcePackageResourceDeb: A deb package file. dpkg packages only
// support INSTALLED state.
type OSPolicyResourcePackageResourceDeb struct {
	// PullDeps: Whether dependencies should also be installed. - install when
	// false: `dpkg -i package` - install when true: `apt-get update && apt-get -y
	// install package.deb`
	PullDeps bool `json:"pullDeps,omitempty"`
	// Source: Required. A deb package.
	Source *OSPolicyResourceFile `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PullDeps") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PullDeps") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourcePackageResourceDeb) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourcePackageResourceDeb
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourcePackageResourceGooGet: A package managed by GooGet. -
// install: `googet -noconfirm install package` - remove: `googet -noconfirm
// remove package`
type OSPolicyResourcePackageResourceGooGet struct {
	// Name: Required. Package name.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourcePackageResourceGooGet) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourcePackageResourceGooGet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourcePackageResourceMSI: An MSI package. MSI packages only
// support INSTALLED state.
type OSPolicyResourcePackageResourceMSI struct {
	// Properties: Additional properties to use during installation. This should be
	// in the format of Property=Setting. Appended to the defaults of
	// `ACTION=INSTALL REBOOT=ReallySuppress`.
	Properties []string `json:"properties,omitempty"`
	// Source: Required. The MSI package.
	Source *OSPolicyResourceFile `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Properties") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Properties") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourcePackageResourceMSI) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourcePackageResourceMSI
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourcePackageResourceRPM: An RPM package file. RPM packages only
// support INSTALLED state.
type OSPolicyResourcePackageResourceRPM struct {
	// PullDeps: Whether dependencies should also be installed. - install when
	// false: `rpm --upgrade --replacepkgs package.rpm` - install when true: `yum
	// -y install package.rpm` or `zypper -y install package.rpm`
	PullDeps bool `json:"pullDeps,omitempty"`
	// Source: Required. An rpm package.
	Source *OSPolicyResourceFile `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PullDeps") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PullDeps") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourcePackageResourceRPM) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourcePackageResourceRPM
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourcePackageResourceYUM: A package managed by YUM. - install:
// `yum -y install package` - remove: `yum -y remove package`
type OSPolicyResourcePackageResourceYUM struct {
	// Name: Required. Package name.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourcePackageResourceYUM) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourcePackageResourceYUM
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourcePackageResourceZypper: A package managed by Zypper. -
// install: `zypper -y install package` - remove: `zypper -y rm package`
type OSPolicyResourcePackageResourceZypper struct {
	// Name: Required. Package name.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourcePackageResourceZypper) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourcePackageResourceZypper
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourceRepositoryResource: A resource that manages a package
// repository.
type OSPolicyResourceRepositoryResource struct {
	// Apt: An Apt Repository.
	Apt *OSPolicyResourceRepositoryResourceAptRepository `json:"apt,omitempty"`
	// Goo: A Goo Repository.
	Goo *OSPolicyResourceRepositoryResourceGooRepository `json:"goo,omitempty"`
	// Yum: A Yum Repository.
	Yum *OSPolicyResourceRepositoryResourceYumRepository `json:"yum,omitempty"`
	// Zypper: A Zypper Repository.
	Zypper *OSPolicyResourceRepositoryResourceZypperRepository `json:"zypper,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Apt") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Apt") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourceRepositoryResource) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourceRepositoryResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourceRepositoryResourceAptRepository: Represents a single apt
// package repository. These will be added to a repo file that will be managed
// at `/etc/apt/sources.list.d/google_osconfig.list`.
type OSPolicyResourceRepositoryResourceAptRepository struct {
	// ArchiveType: Required. Type of archive files in this repository.
	//
	// Possible values:
	//   "ARCHIVE_TYPE_UNSPECIFIED" - Unspecified is invalid.
	//   "DEB" - Deb indicates that the archive contains binary files.
	//   "DEB_SRC" - Deb-src indicates that the archive contains source files.
	ArchiveType string `json:"archiveType,omitempty"`
	// Components: Required. List of components for this repository. Must contain
	// at least one item.
	Components []string `json:"components,omitempty"`
	// Distribution: Required. Distribution of this repository.
	Distribution string `json:"distribution,omitempty"`
	// GpgKey: URI of the key file for this repository. The agent maintains a
	// keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
	GpgKey string `json:"gpgKey,omitempty"`
	// Uri: Required. URI for this repository.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArchiveType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArchiveType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourceRepositoryResourceAptRepository) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourceRepositoryResourceAptRepository
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourceRepositoryResourceGooRepository: Represents a Goo package
// repository. These are added to a repo file that is managed at
// `C:/ProgramData/GooGet/repos/google_osconfig.repo`.
type OSPolicyResourceRepositoryResourceGooRepository struct {
	// Name: Required. The name of the repository.
	Name string `json:"name,omitempty"`
	// Url: Required. The url of the repository.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourceRepositoryResourceGooRepository) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourceRepositoryResourceGooRepository
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourceRepositoryResourceYumRepository: Represents a single yum
// package repository. These are added to a repo file that is managed at
// `/etc/yum.repos.d/google_osconfig.repo`.
type OSPolicyResourceRepositoryResourceYumRepository struct {
	// BaseUrl: Required. The location of the repository directory.
	BaseUrl string `json:"baseUrl,omitempty"`
	// DisplayName: The display name of the repository.
	DisplayName string `json:"displayName,omitempty"`
	// GpgKeys: URIs of GPG keys.
	GpgKeys []string `json:"gpgKeys,omitempty"`
	// Id: Required. A one word, unique name for this repository. This is the `repo
	// id` in the yum config file and also the `display_name` if `display_name` is
	// omitted. This id is also used as the unique identifier when checking for
	// resource conflicts.
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseUrl") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourceRepositoryResourceYumRepository) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourceRepositoryResourceYumRepository
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OSPolicyResourceRepositoryResourceZypperRepository: Represents a single
// zypper package repository. These are added to a repo file that is managed at
// `/etc/zypp/repos.d/google_osconfig.repo`.
type OSPolicyResourceRepositoryResourceZypperRepository struct {
	// BaseUrl: Required. The location of the repository directory.
	BaseUrl string `json:"baseUrl,omitempty"`
	// DisplayName: The display name of the repository.
	DisplayName string `json:"displayName,omitempty"`
	// GpgKeys: URIs of GPG keys.
	GpgKeys []string `json:"gpgKeys,omitempty"`
	// Id: Required. A one word, unique name for this repository. This is the `repo
	// id` in the zypper config file and also the `display_name` if `display_name`
	// is omitted. This id is also used as the unique identifier when checking for
	// GuestPolicy conflicts.
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseUrl") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OSPolicyResourceRepositoryResourceZypperRepository) MarshalJSON() ([]byte, error) {
	type NoMethod OSPolicyResourceRepositoryResourceZypperRepository
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OneTimeSchedule: Sets the time for a one time patch deployment. Timestamp is
// in RFC3339 (https://www.ietf.org/rfc/rfc3339.txt) text format.
type OneTimeSchedule struct {
	// ExecuteTime: Required. The desired patch job execution time.
	ExecuteTime string `json:"executeTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExecuteTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExecuteTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OneTimeSchedule) MarshalJSON() ([]byte, error) {
	type NoMethod OneTimeSchedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PatchConfig: Patch configuration specifications. Contains details on how to
// apply the patch(es) to a VM instance.
type PatchConfig struct {
	// Apt: Apt update settings. Use this setting to override the default `apt`
	// patch rules.
	Apt *AptSettings `json:"apt,omitempty"`
	// Goo: Goo update settings. Use this setting to override the default `goo`
	// patch rules.
	Goo *GooSettings `json:"goo,omitempty"`
	// MigInstancesAllowed: Allows the patch job to run on Managed instance groups
	// (MIGs).
	MigInstancesAllowed bool `json:"migInstancesAllowed,omitempty"`
	// PostStep: The `ExecStep` to run after the patch update.
	PostStep *ExecStep `json:"postStep,omitempty"`
	// PreStep: The `ExecStep` to run before the patch update.
	PreStep *ExecStep `json:"preStep,omitempty"`
	// RebootConfig: Post-patch reboot settings.
	//
	// Possible values:
	//   "REBOOT_CONFIG_UNSPECIFIED" - The default behavior is DEFAULT.
	//   "DEFAULT" - The agent decides if a reboot is necessary by checking signals
	// such as registry keys on Windows or `/var/run/reboot-required` on APT based
	// systems. On RPM based systems, a set of core system package install times
	// are compared with system boot time.
	//   "ALWAYS" - Always reboot the machine after the update completes.
	//   "NEVER" - Never reboot the machine after the update completes.
	RebootConfig string `json:"rebootConfig,omitempty"`
	// WindowsUpdate: Windows update settings. Use this override the default
	// windows patch rules.
	WindowsUpdate *WindowsUpdateSettings `json:"windowsUpdate,omitempty"`
	// Yum: Yum update settings. Use this setting to override the default `yum`
	// patch rules.
	Yum *YumSettings `json:"yum,omitempty"`
	// Zypper: Zypper update settings. Use this setting to override the default
	// `zypper` patch rules.
	Zypper *ZypperSettings `json:"zypper,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Apt") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Apt") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PatchConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PatchConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PatchDeployment: Patch deployments are configurations that individual patch
// jobs use to complete a patch. These configurations include instance filter,
// package repository settings, and a schedule. For more information about
// creating and managing patch deployments, see Scheduling patch jobs
// (https://cloud.google.com/compute/docs/os-patch-management/schedule-patch-jobs).
type PatchDeployment struct {
	// CreateTime: Output only. Time the patch deployment was created. Timestamp is
	// in RFC3339 (https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Description of the patch deployment. Length of the
	// description is limited to 1024 characters.
	Description string `json:"description,omitempty"`
	// Duration: Optional. Duration of the patch. After the duration ends, the
	// patch times out.
	Duration string `json:"duration,omitempty"`
	// InstanceFilter: Required. VM instances to patch.
	InstanceFilter *PatchInstanceFilter `json:"instanceFilter,omitempty"`
	// LastExecuteTime: Output only. The last time a patch job was started by this
	// deployment. Timestamp is in RFC3339 (https://www.ietf.org/rfc/rfc3339.txt)
	// text format.
	LastExecuteTime string `json:"lastExecuteTime,omitempty"`
	// Name: Unique name for the patch deployment resource in a project. The patch
	// deployment name is in the form:
	// `projects/{project_id}/patchDeployments/{patch_deployment_id}`. This field
	// is ignored when you create a new patch deployment.
	Name string `json:"name,omitempty"`
	// OneTimeSchedule: Required. Schedule a one-time execution.
	OneTimeSchedule *OneTimeSchedule `json:"oneTimeSchedule,omitempty"`
	// PatchConfig: Optional. Patch configuration that is applied.
	PatchConfig *PatchConfig `json:"patchConfig,omitempty"`
	// RecurringSchedule: Required. Schedule recurring executions.
	RecurringSchedule *RecurringSchedule `json:"recurringSchedule,omitempty"`
	// Rollout: Optional. Rollout strategy of the patch job.
	Rollout *PatchRollout `json:"rollout,omitempty"`
	// State: Output only. Current state of the patch deployment.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "ACTIVE" - Active value means that patch deployment generates Patch Jobs.
	//   "PAUSED" - Paused value means that patch deployment does not generate
	// Patch jobs. Requires user action to move in and out from this state.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Time the patch deployment was last updated.
	// Timestamp is in RFC3339 (https://www.ietf.org/rfc/rfc3339.txt) text format.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PatchDeployment) MarshalJSON() ([]byte, error) {
	type NoMethod PatchDeployment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PatchInstanceFilter: A filter to target VM instances for patching. The
// targeted VMs must meet all criteria specified. So if both labels and zones
// are specified, the patch job targets only VMs with those labels and in those
// zones.
type PatchInstanceFilter struct {
	// All: Target all VM instances in the project. If true, no other criteria is
	// permitted.
	All bool `json:"all,omitempty"`
	// GroupLabels: Targets VM instances matching ANY of these GroupLabels. This
	// allows targeting of disparate groups of VM instances.
	GroupLabels []*PatchInstanceFilterGroupLabel `json:"groupLabels,omitempty"`
	// InstanceNamePrefixes: Targets VMs whose name starts with one of these
	// prefixes. Similar to labels, this is another way to group VMs when targeting
	// configs, for example prefix="prod-".
	InstanceNamePrefixes []string `json:"instanceNamePrefixes,omitempty"`
	// Instances: Targets any of the VM instances specified. Instances are
	// specified by their URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`,
	// `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or
	// `https://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/ins
	// tances/[INSTANCE_NAME]`
	Instances []string `json:"instances,omitempty"`
	// Zones: Targets VM instances in ANY of these zones. Leave empty to target VM
	// instances in any zone.
	Zones []string `json:"zones,omitempty"`
	// ForceSendFields is a list of field names (e.g. "All") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "All") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PatchInstanceFilter) MarshalJSON() ([]byte, error) {
	type NoMethod PatchInstanceFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PatchInstanceFilterGroupLabel: Targets a group of VM instances by using
// their assigned labels
// (https://cloud.google.com/compute/docs/labeling-resources). Labels are
// key-value pairs. A `GroupLabel` is a combination of labels that is used to
// target VMs for a patch job. For example, a patch job can target VMs that
// have the following `GroupLabel`: `{"env":"test", "app":"web"}`. This means
// that the patch job is applied to VMs that have both the labels `env=test`
// and `app=web`.
type PatchInstanceFilterGroupLabel struct {
	// Labels: Compute Engine instance labels that must be present for a VM
	// instance to be targeted by this filter.
	Labels map[string]string `json:"labels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PatchInstanceFilterGroupLabel) MarshalJSON() ([]byte, error) {
	type NoMethod PatchInstanceFilterGroupLabel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PatchJob: A high level representation of a patch job that is either in
// progress or has completed. Instance details are not included in the job. To
// paginate through instance details, use `ListPatchJobInstanceDetails`. For
// more information about patch jobs, see Creating patch jobs
// (https://cloud.google.com/compute/docs/os-patch-management/create-patch-job).
type PatchJob struct {
	// CreateTime: Time this patch job was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Description of the patch job. Length of the description is
	// limited to 1024 characters.
	Description string `json:"description,omitempty"`
	// DisplayName: Display name for this patch job. This is not a unique
	// identifier.
	DisplayName string `json:"displayName,omitempty"`
	// DryRun: If this patch job is a dry run, the agent reports that it has
	// finished without running any updates on the VM instance.
	DryRun bool `json:"dryRun,omitempty"`
	// Duration: Duration of the patch job. After the duration ends, the patch job
	// times out.
	Duration string `json:"duration,omitempty"`
	// ErrorMessage: If this patch job failed, this message provides information
	// about the failure.
	ErrorMessage string `json:"errorMessage,omitempty"`
	// InstanceDetailsSummary: Summary of instance details.
	InstanceDetailsSummary *PatchJobInstanceDetailsSummary `json:"instanceDetailsSummary,omitempty"`
	// InstanceFilter: Instances to patch.
	InstanceFilter *PatchInstanceFilter `json:"instanceFilter,omitempty"`
	// Name: Unique identifier for this patch job in the form
	// `projects/*/patchJobs/*`
	Name string `json:"name,omitempty"`
	// PatchConfig: Patch configuration being applied.
	PatchConfig *PatchConfig `json:"patchConfig,omitempty"`
	// PatchDeployment: Output only. Name of the patch deployment that created this
	// patch job.
	PatchDeployment string `json:"patchDeployment,omitempty"`
	// PercentComplete: Reflects the overall progress of the patch job in the range
	// of 0.0 being no progress to 100.0 being complete.
	PercentComplete float64 `json:"percentComplete,omitempty"`
	// Rollout: Rollout strategy being applied.
	Rollout *PatchRollout `json:"rollout,omitempty"`
	// State: The current state of the PatchJob.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State must be specified.
	//   "STARTED" - The patch job was successfully initiated.
	//   "INSTANCE_LOOKUP" - The patch job is looking up instances to run the patch
	// on.
	//   "PATCHING" - Instances are being patched.
	//   "SUCCEEDED" - Patch job completed successfully.
	//   "COMPLETED_WITH_ERRORS" - Patch job completed but there were errors.
	//   "CANCELED" - The patch job was canceled.
	//   "TIMED_OUT" - The patch job timed out.
	State string `json:"state,omitempty"`
	// UpdateTime: Last time this patch job was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PatchJob) MarshalJSON() ([]byte, error) {
	type NoMethod PatchJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *PatchJob) UnmarshalJSON(data []byte) error {
	type NoMethod PatchJob
	var s1 struct {
		PercentComplete gensupport.JSONFloat64 `json:"percentComplete"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.PercentComplete = float64(s1.PercentComplete)
	return nil
}

// PatchJobInstanceDetails: Patch details for a VM instance. For more
// information about reviewing VM instance details, see Listing all VM instance
// details for a specific patch job
// (https://cloud.google.com/compute/docs/os-patch-management/manage-patch-jobs#list-instance-details).
type PatchJobInstanceDetails struct {
	// AttemptCount: The number of times the agent that the agent attempts to apply
	// the patch.
	AttemptCount int64 `json:"attemptCount,omitempty,string"`
	// FailureReason: If the patch fails, this field provides the reason.
	FailureReason string `json:"failureReason,omitempty"`
	// InstanceSystemId: The unique identifier for the instance. This identifier is
	// defined by the server.
	InstanceSystemId string `json:"instanceSystemId,omitempty"`
	// Name: The instance name in the form `projects/*/zones/*/instances/*`
	Name string `json:"name,omitempty"`
	// State: Current state of instance patch.
	//
	// Possible values:
	//   "PATCH_STATE_UNSPECIFIED" - Unspecified.
	//   "PENDING" - The instance is not yet notified.
	//   "INACTIVE" - Instance is inactive and cannot be patched.
	//   "NOTIFIED" - The instance is notified that it should be patched.
	//   "STARTED" - The instance has started the patching process.
	//   "DOWNLOADING_PATCHES" - The instance is downloading patches.
	//   "APPLYING_PATCHES" - The instance is applying patches.
	//   "REBOOTING" - The instance is rebooting.
	//   "SUCCEEDED" - The instance has completed applying patches.
	//   "SUCCEEDED_REBOOT_REQUIRED" - The instance has completed applying patches
	// but a reboot is required.
	//   "FAILED" - The instance has failed to apply the patch.
	//   "ACKED" - The instance acked the notification and will start shortly.
	//   "TIMED_OUT" - The instance exceeded the time out while applying the patch.
	//   "RUNNING_PRE_PATCH_STEP" - The instance is running the pre-patch step.
	//   "RUNNING_POST_PATCH_STEP" - The instance is running the post-patch step.
	//   "NO_AGENT_DETECTED" - The service could not detect the presence of the
	// agent. Check to ensure that the agent is installed, running, and able to
	// communicate with the service.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttemptCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttemptCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PatchJobInstanceDetails) MarshalJSON() ([]byte, error) {
	type NoMethod PatchJobInstanceDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PatchJobInstanceDetailsSummary: A summary of the current patch state across
// all instances that this patch job affects. Contains counts of instances in
// different states. These states map to `InstancePatchState`. List patch job
// instance details to see the specific states of each instance.
type PatchJobInstanceDetailsSummary struct {
	// AckedInstanceCount: Number of instances that have acked and will start
	// shortly.
	AckedInstanceCount int64 `json:"ackedInstanceCount,omitempty,string"`
	// ApplyingPatchesInstanceCount: Number of instances that are applying patches.
	ApplyingPatchesInstanceCount int64 `json:"applyingPatchesInstanceCount,omitempty,string"`
	// DownloadingPatchesInstanceCount: Number of instances that are downloading
	// patches.
	DownloadingPatchesInstanceCount int64 `json:"downloadingPatchesInstanceCount,omitempty,string"`
	// FailedInstanceCount: Number of instances that failed.
	FailedInstanceCount int64 `json:"failedInstanceCount,omitempty,string"`
	// InactiveInstanceCount: Number of instances that are inactive.
	InactiveInstanceCount int64 `json:"inactiveInstanceCount,omitempty,string"`
	// NoAgentDetectedInstanceCount: Number of instances that do not appear to be
	// running the agent. Check to ensure that the agent is installed, running, and
	// able to communicate with the service.
	NoAgentDetectedInstanceCount int64 `json:"noAgentDetectedInstanceCount,omitempty,string"`
	// NotifiedInstanceCount: Number of instances notified about patch job.
	NotifiedInstanceCount int64 `json:"notifiedInstanceCount,omitempty,string"`
	// PendingInstanceCount: Number of instances pending patch job.
	PendingInstanceCount int64 `json:"pendingInstanceCount,omitempty,string"`
	// PostPatchStepInstanceCount: Number of instances that are running the
	// post-patch step.
	PostPatchStepInstanceCount int64 `json:"postPatchStepInstanceCount,omitempty,string"`
	// PrePatchStepInstanceCount: Number of instances that are running the
	// pre-patch step.
	PrePatchStepInstanceCount int64 `json:"prePatchStepInstanceCount,omitempty,string"`
	// RebootingInstanceCount: Number of instances rebooting.
	RebootingInstanceCount int64 `json:"rebootingInstanceCount,omitempty,string"`
	// StartedInstanceCount: Number of instances that have started.
	StartedInstanceCount int64 `json:"startedInstanceCount,omitempty,string"`
	// SucceededInstanceCount: Number of instances that have completed
	// successfully.
	SucceededInstanceCount int64 `json:"succeededInstanceCount,omitempty,string"`
	// SucceededRebootRequiredInstanceCount: Number of instances that require
	// reboot.
	SucceededRebootRequiredInstanceCount int64 `json:"succeededRebootRequiredInstanceCount,omitempty,string"`
	// TimedOutInstanceCount: Number of instances that exceeded the time out while
	// applying the patch.
	TimedOutInstanceCount int64 `json:"timedOutInstanceCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AckedInstanceCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AckedInstanceCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PatchJobInstanceDetailsSummary) MarshalJSON() ([]byte, error) {
	type NoMethod PatchJobInstanceDetailsSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PatchRollout: Patch rollout configuration specifications. Contains details
// on the concurrency control when applying patch(es) to all targeted VMs.
type PatchRollout struct {
	// DisruptionBudget: The maximum number (or percentage) of VMs per zone to
	// disrupt at any given moment. The number of VMs calculated from multiplying
	// the percentage by the total number of VMs in a zone is rounded up. During
	// patching, a VM is considered disrupted from the time the agent is notified
	// to begin until patching has completed. This disruption time includes the
	// time to complete reboot and any post-patch steps. A VM contributes to the
	// disruption budget if its patching operation fails either when applying the
	// patches, running pre or post patch steps, or if it fails to respond with a
	// success notification before timing out. VMs that are not running or do not
	// have an active agent do not count toward this disruption budget. For
	// zone-by-zone rollouts, if the disruption budget in a zone is exceeded, the
	// patch job stops, because continuing to the next zone requires completion of
	// the patch process in the previous zone. For example, if the disruption
	// budget has a fixed value of `10`, and 8 VMs fail to patch in the current
	// zone, the patch job continues to patch 2 VMs at a time until the zone is
	// completed. When that zone is completed successfully, patching begins with 10
	// VMs at a time in the next zone. If 10 VMs in the next zone fail to patch,
	// the patch job stops.
	DisruptionBudget *FixedOrPercent `json:"disruptionBudget,omitempty"`
	// Mode: Mode of the patch rollout.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Mode must be specified.
	//   "ZONE_BY_ZONE" - Patches are applied one zone at a time. The patch job
	// begins in the region with the lowest number of targeted VMs. Within the
	// region, patching begins in the zone with the lowest number of targeted VMs.
	// If multiple regions (or zones within a region) have the same number of
	// targeted VMs, a tie-breaker is achieved by sorting the regions or zones in
	// alphabetical order.
	//   "CONCURRENT_ZONES" - Patches are applied to VMs in all zones at the same
	// time.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisruptionBudget") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisruptionBudget") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PatchRollout) MarshalJSON() ([]byte, error) {
	type NoMethod PatchRollout
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PausePatchDeploymentRequest: A request message for pausing a patch
// deployment.
type PausePatchDeploymentRequest struct {
}

// ProjectFeatureSettings: ProjectFeatureSettings represents the VM Manager
// feature settings in a project. For more information, see Enable full VM
// Manager functionality.
type ProjectFeatureSettings struct {
	// Name: Required. Immutable. Name specifies the URL for the
	// ProjectFeatureSettings resource:
	// projects/project_id/locations/global/projectFeatureSettings.
	Name string `json:"name,omitempty"`
	// PatchAndConfigFeatureSet: Set PatchAndConfigFeatureSet for the project.
	//
	// Possible values:
	//   "PATCH_AND_CONFIG_FEATURE_SET_UNSPECIFIED" - Not specified placeholder
	//   "OSCONFIG_B" - Enables only the basic set of VM Manager features in the
	// project.
	//   "OSCONFIG_C" - Enables all VM Manager features in the project.
	PatchAndConfigFeatureSet string `json:"patchAndConfigFeatureSet,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProjectFeatureSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ProjectFeatureSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RecurringSchedule: Sets the time for recurring patch deployments.
type RecurringSchedule struct {
	// EndTime: Optional. The end time at which a recurring patch deployment
	// schedule is no longer active.
	EndTime string `json:"endTime,omitempty"`
	// Frequency: Required. The frequency unit of this recurring schedule.
	//
	// Possible values:
	//   "FREQUENCY_UNSPECIFIED" - Invalid. A frequency must be specified.
	//   "WEEKLY" - Indicates that the frequency of recurrence should be expressed
	// in terms of weeks.
	//   "MONTHLY" - Indicates that the frequency of recurrence should be expressed
	// in terms of months.
	//   "DAILY" - Indicates that the frequency of recurrence should be expressed
	// in terms of days.
	Frequency string `json:"frequency,omitempty"`
	// LastExecuteTime: Output only. The time the last patch job ran successfully.
	LastExecuteTime string `json:"lastExecuteTime,omitempty"`
	// Monthly: Required. Schedule with monthly executions.
	Monthly *MonthlySchedule `json:"monthly,omitempty"`
	// NextExecuteTime: Output only. The time the next patch job is scheduled to
	// run.
	NextExecuteTime string `json:"nextExecuteTime,omitempty"`
	// StartTime: Optional. The time that the recurring schedule becomes effective.
	// Defaults to `create_time` of the patch deployment.
	StartTime string `json:"startTime,omitempty"`
	// TimeOfDay: Required. Time of the day to run a recurring deployment.
	TimeOfDay *TimeOfDay `json:"timeOfDay,omitempty"`
	// TimeZone: Required. Defines the time zone that `time_of_day` is relative to.
	// The rules for daylight saving time are determined by the chosen time zone.
	TimeZone *TimeZone `json:"timeZone,omitempty"`
	// Weekly: Required. Schedule with weekly executions.
	Weekly *WeeklySchedule `json:"weekly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RecurringSchedule) MarshalJSON() ([]byte, error) {
	type NoMethod RecurringSchedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResumePatchDeploymentRequest: A request message for resuming a patch
// deployment.
type ResumePatchDeploymentRequest struct {
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimeOfDay: Represents a time of day. The date and time zone are either not
// significant or are specified elsewhere. An API may choose to allow leap
// seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
type TimeOfDay struct {
	// Hours: Hours of a day in 24 hour format. Must be greater than or equal to 0
	// and typically must be less than or equal to 23. An API may choose to allow
	// the value "24:00:00" for scenarios like business closing time.
	Hours int64 `json:"hours,omitempty"`
	// Minutes: Minutes of an hour. Must be greater than or equal to 0 and less
	// than or equal to 59.
	Minutes int64 `json:"minutes,omitempty"`
	// Nanos: Fractions of seconds, in nanoseconds. Must be greater than or equal
	// to 0 and less than or equal to 999,999,999.
	Nanos int64 `json:"nanos,omitempty"`
	// Seconds: Seconds of a minute. Must be greater than or equal to 0 and
	// typically must be less than or equal to 59. An API may allow the value 60 if
	// it allows leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hours") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hours") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeOfDay) MarshalJSON() ([]byte, error) {
	type NoMethod TimeOfDay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimeZone: Represents a time zone from the IANA Time Zone Database
// (https://www.iana.org/time-zones).
type TimeZone struct {
	// Id: IANA Time Zone Database time zone. For example "America/New_York".
	Id string `json:"id,omitempty"`
	// Version: Optional. IANA Time Zone Database version number. For example
	// "2019a".
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeZone) MarshalJSON() ([]byte, error) {
	type NoMethod TimeZone
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VulnerabilityReport: This API resource represents the vulnerability report
// for a specified Compute Engine virtual machine (VM) instance at a given
// point in time. For more information, see Vulnerability reports
// (https://cloud.google.com/compute/docs/instances/os-inventory-management#vulnerability-reports).
type VulnerabilityReport struct {
	// Name: Output only. The `vulnerabilityReport` API resource name. Format:
	// `projects/{project_number}/locations/{location}/instances/{instance_id}/vulne
	// rabilityReport`
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The timestamp for when the last vulnerability
	// report was generated for the VM.
	UpdateTime string `json:"updateTime,omitempty"`
	// Vulnerabilities: Output only. List of vulnerabilities affecting the VM.
	Vulnerabilities []*VulnerabilityReportVulnerability `json:"vulnerabilities,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VulnerabilityReport) MarshalJSON() ([]byte, error) {
	type NoMethod VulnerabilityReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VulnerabilityReportVulnerability: A vulnerability affecting the VM instance.
type VulnerabilityReportVulnerability struct {
	// AvailableInventoryItemIds: Corresponds to the `AVAILABLE_PACKAGE` inventory
	// item on the VM. If the vulnerability report was not updated after the VM
	// inventory update, these values might not display in VM inventory. If there
	// is no available fix, the field is empty. The `inventory_item` value
	// specifies the latest `SoftwarePackage` available to the VM that fixes the
	// vulnerability.
	AvailableInventoryItemIds []string `json:"availableInventoryItemIds,omitempty"`
	// CreateTime: The timestamp for when the vulnerability was first detected.
	CreateTime string `json:"createTime,omitempty"`
	// Details: Contains metadata as per the upstream feed of the operating system
	// and NVD.
	Details *VulnerabilityReportVulnerabilityDetails `json:"details,omitempty"`
	// InstalledInventoryItemIds: Corresponds to the `INSTALLED_PACKAGE` inventory
	// item on the VM. This field displays the inventory items affected by this
	// vulnerability. If the vulnerability report was not updated after the VM
	// inventory update, these values might not display in VM inventory. For some
	// distros, this field may be empty.
	InstalledInventoryItemIds []string `json:"installedInventoryItemIds,omitempty"`
	// Items: List of items affected by the vulnerability.
	Items []*VulnerabilityReportVulnerabilityItem `json:"items,omitempty"`
	// UpdateTime: The timestamp for when the vulnerability was last modified.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvailableInventoryItemIds")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvailableInventoryItemIds") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VulnerabilityReportVulnerability) MarshalJSON() ([]byte, error) {
	type NoMethod VulnerabilityReportVulnerability
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VulnerabilityReportVulnerabilityDetails: Contains metadata information for
// the vulnerability. This information is collected from the upstream feed of
// the operating system.
type VulnerabilityReportVulnerabilityDetails struct {
	// Cve: The CVE of the vulnerability. CVE cannot be empty and the combination
	// of should be unique across vulnerabilities for a VM.
	Cve string `json:"cve,omitempty"`
	// CvssV2Score: The CVSS V2 score of this vulnerability. CVSS V2 score is on a
	// scale of 0 - 10 where 0 indicates low severity and 10 indicates high
	// severity.
	CvssV2Score float64 `json:"cvssV2Score,omitempty"`
	// CvssV3: The full description of the CVSSv3 for this vulnerability from NVD.
	CvssV3 *CVSSv3 `json:"cvssV3,omitempty"`
	// Description: The note or description describing the vulnerability from the
	// distro.
	Description string `json:"description,omitempty"`
	// References: Corresponds to the references attached to the
	// `VulnerabilityDetails`.
	References []*VulnerabilityReportVulnerabilityDetailsReference `json:"references,omitempty"`
	// Severity: Assigned severity/impact ranking from the distro.
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cve") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cve") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VulnerabilityReportVulnerabilityDetails) MarshalJSON() ([]byte, error) {
	type NoMethod VulnerabilityReportVulnerabilityDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *VulnerabilityReportVulnerabilityDetails) UnmarshalJSON(data []byte) error {
	type NoMethod VulnerabilityReportVulnerabilityDetails
	var s1 struct {
		CvssV2Score gensupport.JSONFloat64 `json:"cvssV2Score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CvssV2Score = float64(s1.CvssV2Score)
	return nil
}

// VulnerabilityReportVulnerabilityDetailsReference: A reference for this
// vulnerability.
type VulnerabilityReportVulnerabilityDetailsReference struct {
	// Source: The source of the reference e.g. NVD.
	Source string `json:"source,omitempty"`
	// Url: The url of the reference.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Source") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Source") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VulnerabilityReportVulnerabilityDetailsReference) MarshalJSON() ([]byte, error) {
	type NoMethod VulnerabilityReportVulnerabilityDetailsReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VulnerabilityReportVulnerabilityItem: OS inventory item that is affected by
// a vulnerability or fixed as a result of a vulnerability.
type VulnerabilityReportVulnerabilityItem struct {
	// AvailableInventoryItemId: Corresponds to the `AVAILABLE_PACKAGE` inventory
	// item on the VM. If the vulnerability report was not updated after the VM
	// inventory update, these values might not display in VM inventory. If there
	// is no available fix, the field is empty. The `inventory_item` value
	// specifies the latest `SoftwarePackage` available to the VM that fixes the
	// vulnerability.
	AvailableInventoryItemId string `json:"availableInventoryItemId,omitempty"`
	// FixedCpeUri: The recommended CPE URI (https://cpe.mitre.org/specification/)
	// update that contains a fix for this vulnerability.
	FixedCpeUri string `json:"fixedCpeUri,omitempty"`
	// InstalledInventoryItemId: Corresponds to the `INSTALLED_PACKAGE` inventory
	// item on the VM. This field displays the inventory items affected by this
	// vulnerability. If the vulnerability report was not updated after the VM
	// inventory update, these values might not display in VM inventory. For some
	// operating systems, this field might be empty.
	InstalledInventoryItemId string `json:"installedInventoryItemId,omitempty"`
	// UpstreamFix: The upstream OS patch, packages or KB that fixes the
	// vulnerability.
	UpstreamFix string `json:"upstreamFix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvailableInventoryItemId")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvailableInventoryItemId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VulnerabilityReportVulnerabilityItem) MarshalJSON() ([]byte, error) {
	type NoMethod VulnerabilityReportVulnerabilityItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WeekDayOfMonth: Represents one week day in a month. An example is "the 4th
// Sunday".
type WeekDayOfMonth struct {
	// DayOfWeek: Required. A day of the week.
	//
	// Possible values:
	//   "DAY_OF_WEEK_UNSPECIFIED" - The day of the week is unspecified.
	//   "MONDAY" - Monday
	//   "TUESDAY" - Tuesday
	//   "WEDNESDAY" - Wednesday
	//   "THURSDAY" - Thursday
	//   "FRIDAY" - Friday
	//   "SATURDAY" - Saturday
	//   "SUNDAY" - Sunday
	DayOfWeek string `json:"dayOfWeek,omitempty"`
	// DayOffset: Optional. Represents the number of days before or after the given
	// week day of month that the patch deployment is scheduled for. For example if
	// `week_ordinal` and `day_of_week` values point to the second Tuesday of the
	// month and the `day_offset` value is set to `3`, patch deployment takes place
	// three days after the second Tuesday of the month. If this value is negative,
	// for example -5, patches are deployed five days before the second Tuesday of
	// the month. Allowed values are in range [-30, 30].
	DayOffset int64 `json:"dayOffset,omitempty"`
	// WeekOrdinal: Required. Week number in a month. 1-4 indicates the 1st to 4th
	// week of the month. -1 indicates the last week of the month.
	WeekOrdinal int64 `json:"weekOrdinal,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DayOfWeek") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DayOfWeek") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WeekDayOfMonth) MarshalJSON() ([]byte, error) {
	type NoMethod WeekDayOfMonth
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WeeklySchedule: Represents a weekly schedule.
type WeeklySchedule struct {
	// DayOfWeek: Required. Day of the week.
	//
	// Possible values:
	//   "DAY_OF_WEEK_UNSPECIFIED" - The day of the week is unspecified.
	//   "MONDAY" - Monday
	//   "TUESDAY" - Tuesday
	//   "WEDNESDAY" - Wednesday
	//   "THURSDAY" - Thursday
	//   "FRIDAY" - Friday
	//   "SATURDAY" - Saturday
	//   "SUNDAY" - Sunday
	DayOfWeek string `json:"dayOfWeek,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DayOfWeek") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DayOfWeek") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WeeklySchedule) MarshalJSON() ([]byte, error) {
	type NoMethod WeeklySchedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WindowsUpdateSettings: Windows patching is performed using the Windows
// Update Agent.
type WindowsUpdateSettings struct {
	// Classifications: Only apply updates of these windows update classifications.
	// If empty, all updates are applied.
	//
	// Possible values:
	//   "CLASSIFICATION_UNSPECIFIED" - Invalid. If classifications are included,
	// they must be specified.
	//   "CRITICAL" - "A widely released fix for a specific problem that addresses
	// a critical, non-security-related bug." [1]
	//   "SECURITY" - "A widely released fix for a product-specific,
	// security-related vulnerability. Security vulnerabilities are rated by their
	// severity. The severity rating is indicated in the Microsoft security
	// bulletin as critical, important, moderate, or low." [1]
	//   "DEFINITION" - "A widely released and frequent software update that
	// contains additions to a product's definition database. Definition databases
	// are often used to detect objects that have specific attributes, such as
	// malicious code, phishing websites, or junk mail." [1]
	//   "DRIVER" - "Software that controls the input and output of a device." [1]
	//   "FEATURE_PACK" - "New product functionality that is first distributed
	// outside the context of a product release and that is typically included in
	// the next full product release." [1]
	//   "SERVICE_PACK" - "A tested, cumulative set of all hotfixes, security
	// updates, critical updates, and updates. Additionally, service packs may
	// contain additional fixes for problems that are found internally since the
	// release of the product. Service packs my also contain a limited number of
	// customer-requested design changes or features." [1]
	//   "TOOL" - "A utility or feature that helps complete a task or set of
	// tasks." [1]
	//   "UPDATE_ROLLUP" - "A tested, cumulative set of hotfixes, security updates,
	// critical updates, and updates that are packaged together for easy
	// deployment. A rollup generally targets a specific area, such as security, or
	// a component of a product, such as Internet Information Services (IIS)." [1]
	//   "UPDATE" - "A widely released fix for a specific problem. An update
	// addresses a noncritical, non-security-related bug." [1]
	Classifications []string `json:"classifications,omitempty"`
	// Excludes: List of KBs to exclude from update.
	Excludes []string `json:"excludes,omitempty"`
	// ExclusivePatches: An exclusive list of kbs to be updated. These are the only
	// patches that will be updated. This field must not be used with other patch
	// configurations.
	ExclusivePatches []string `json:"exclusivePatches,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Classifications") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Classifications") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WindowsUpdateSettings) MarshalJSON() ([]byte, error) {
	type NoMethod WindowsUpdateSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// YumSettings: Yum patching is performed by executing `yum update`. Additional
// options can be set to control how this is executed. Note that not all
// settings are supported on all platforms.
type YumSettings struct {
	// Excludes: List of packages to exclude from update. These packages are
	// excluded by using the yum `--exclude` flag.
	Excludes []string `json:"excludes,omitempty"`
	// ExclusivePackages: An exclusive list of packages to be updated. These are
	// the only packages that will be updated. If these packages are not installed,
	// they will be ignored. This field must not be specified with any other patch
	// configuration fields.
	ExclusivePackages []string `json:"exclusivePackages,omitempty"`
	// Minimal: Will cause patch to run `yum update-minimal` instead.
	Minimal bool `json:"minimal,omitempty"`
	// Security: Adds the `--security` flag to `yum update`. Not supported on all
	// platforms.
	Security bool `json:"security,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Excludes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Excludes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s YumSettings) MarshalJSON() ([]byte, error) {
	type NoMethod YumSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ZypperSettings: Zypper patching is performed by running `zypper patch`. See
// also https://en.opensuse.org/SDB:Zypper_manual.
type ZypperSettings struct {
	// Categories: Install only patches with these categories. Common categories
	// include security, recommended, and feature.
	Categories []string `json:"categories,omitempty"`
	// Excludes: List of patches to exclude from update.
	Excludes []string `json:"excludes,omitempty"`
	// ExclusivePatches: An exclusive list of patches to be updated. These are the
	// only patches that will be installed using 'zypper patch patch:' command.
	// This field must not be used with any other patch configuration fields.
	ExclusivePatches []string `json:"exclusivePatches,omitempty"`
	// Severities: Install only patches with these severities. Common severities
	// include critical, important, moderate, and low.
	Severities []string `json:"severities,omitempty"`
	// WithOptional: Adds the `--with-optional` flag to `zypper patch`.
	WithOptional bool `json:"withOptional,omitempty"`
	// WithUpdate: Adds the `--with-update` flag, to `zypper patch`.
	WithUpdate bool `json:"withUpdate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Categories") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Categories") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ZypperSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ZypperSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsGlobalGetProjectFeatureSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetProjectFeatureSettings: GetProjectFeatureSettings returns the VM Manager
// feature settings for a project.
//
//   - name: Name specifies the URL for the ProjectFeatureSettings resource:
//     projects/project_id/locations/global/projectFeatureSettings.
func (r *ProjectsLocationsGlobalService) GetProjectFeatureSettings(name string) *ProjectsLocationsGlobalGetProjectFeatureSettingsCall {
	c := &ProjectsLocationsGlobalGetProjectFeatureSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlobalGetProjectFeatureSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalGetProjectFeatureSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGlobalGetProjectFeatureSettingsCall) IfNoneMatch(entityTag string) *ProjectsLocationsGlobalGetProjectFeatureSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlobalGetProjectFeatureSettingsCall) Context(ctx context.Context) *ProjectsLocationsGlobalGetProjectFeatureSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlobalGetProjectFeatureSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalGetProjectFeatureSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.locations.global.getProjectFeatureSettings", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.locations.global.getProjectFeatureSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *ProjectFeatureSettings.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsGlobalGetProjectFeatureSettingsCall) Do(opts ...googleapi.CallOption) (*ProjectFeatureSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ProjectFeatureSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.locations.global.getProjectFeatureSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlobalUpdateProjectFeatureSettingsCall struct {
	s                      *Service
	name                   string
	projectfeaturesettings *ProjectFeatureSettings
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// UpdateProjectFeatureSettings: UpdateProjectFeatureSettings sets the VM
// Manager features for a project.
//
//   - name: Immutable. Name specifies the URL for the ProjectFeatureSettings
//     resource: projects/project_id/locations/global/projectFeatureSettings.
func (r *ProjectsLocationsGlobalService) UpdateProjectFeatureSettings(name string, projectfeaturesettings *ProjectFeatureSettings) *ProjectsLocationsGlobalUpdateProjectFeatureSettingsCall {
	c := &ProjectsLocationsGlobalUpdateProjectFeatureSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.projectfeaturesettings = projectfeaturesettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask that
// controls which fields of the ProjectFeatureSettings should be updated.
func (c *ProjectsLocationsGlobalUpdateProjectFeatureSettingsCall) UpdateMask(updateMask string) *ProjectsLocationsGlobalUpdateProjectFeatureSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlobalUpdateProjectFeatureSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalUpdateProjectFeatureSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlobalUpdateProjectFeatureSettingsCall) Context(ctx context.Context) *ProjectsLocationsGlobalUpdateProjectFeatureSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlobalUpdateProjectFeatureSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalUpdateProjectFeatureSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.projectfeaturesettings)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.locations.global.updateProjectFeatureSettings", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.locations.global.updateProjectFeatureSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *ProjectFeatureSettings.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsGlobalUpdateProjectFeatureSettingsCall) Do(opts ...googleapi.CallOption) (*ProjectFeatureSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ProjectFeatureSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.locations.global.updateProjectFeatureSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesInventoriesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get inventory data for the specified VM instance. If the VM has no
// associated inventory, the message `NOT_FOUND` is returned.
//
//   - name: API resource name for inventory resource. Format:
//     `projects/{project}/locations/{location}/instances/{instance}/inventory`
//     For `{project}`, either `project-number` or `project-id` can be provided.
//     For `{instance}`, either Compute Engine `instance-id` or `instance-name`
//     can be provided.
func (r *ProjectsLocationsInstancesInventoriesService) Get(name string) *ProjectsLocationsInstancesInventoriesGetCall {
	c := &ProjectsLocationsInstancesInventoriesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": Inventory view indicating what
// information should be included in the inventory resource. If unspecified,
// the default view is BASIC.
//
// Possible values:
//
//	"INVENTORY_VIEW_UNSPECIFIED" - The default value. The API defaults to the
//
// BASIC view.
//
//	"BASIC" - Returns the basic inventory information that includes `os_info`.
//	"FULL" - Returns all fields.
func (c *ProjectsLocationsInstancesInventoriesGetCall) View(view string) *ProjectsLocationsInstancesInventoriesGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesInventoriesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesInventoriesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInstancesInventoriesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsInstancesInventoriesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesInventoriesGetCall) Context(ctx context.Context) *ProjectsLocationsInstancesInventoriesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesInventoriesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesInventoriesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.locations.instances.inventories.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.locations.instances.inventories.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Inventory.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesInventoriesGetCall) Do(opts ...googleapi.CallOption) (*Inventory, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Inventory{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.locations.instances.inventories.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesInventoriesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List inventory data for all VM instances in the specified zone.
//
//   - parent: The parent resource name. Format:
//     `projects/{project}/locations/{location}/instances/-` For `{project}`,
//     either `project-number` or `project-id` can be provided.
func (r *ProjectsLocationsInstancesInventoriesService) List(parent string) *ProjectsLocationsInstancesInventoriesListCall {
	c := &ProjectsLocationsInstancesInventoriesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": If provided, this field
// specifies the criteria that must be met by a `Inventory` API resource to be
// included in the response.
func (c *ProjectsLocationsInstancesInventoriesListCall) Filter(filter string) *ProjectsLocationsInstancesInventoriesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return.
func (c *ProjectsLocationsInstancesInventoriesListCall) PageSize(pageSize int64) *ProjectsLocationsInstancesInventoriesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A pagination token
// returned from a previous call to `ListInventories` that indicates where this
// listing should continue from.
func (c *ProjectsLocationsInstancesInventoriesListCall) PageToken(pageToken string) *ProjectsLocationsInstancesInventoriesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": Inventory view indicating what
// information should be included in the inventory resource. If unspecified,
// the default view is BASIC.
//
// Possible values:
//
//	"INVENTORY_VIEW_UNSPECIFIED" - The default value. The API defaults to the
//
// BASIC view.
//
//	"BASIC" - Returns the basic inventory information that includes `os_info`.
//	"FULL" - Returns all fields.
func (c *ProjectsLocationsInstancesInventoriesListCall) View(view string) *ProjectsLocationsInstancesInventoriesListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesInventoriesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesInventoriesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInstancesInventoriesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsInstancesInventoriesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesInventoriesListCall) Context(ctx context.Context) *ProjectsLocationsInstancesInventoriesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesInventoriesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesInventoriesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/inventories")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.locations.instances.inventories.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.locations.instances.inventories.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListInventoriesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesInventoriesListCall) Do(opts ...googleapi.CallOption) (*ListInventoriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListInventoriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.locations.instances.inventories.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsInstancesInventoriesListCall) Pages(ctx context.Context, f func(*ListInventoriesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsInstancesOsPolicyAssignmentsReportsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get the OS policy assignment report for the specified Compute Engine VM
// instance.
//
//   - name: API resource name for OS policy assignment report. Format:
//     `/projects/{project}/locations/{location}/instances/{instance}/osPolicyAssi
//     gnments/{assignment}/report` For `{project}`, either `project-number` or
//     `project-id` can be provided. For `{instance_id}`, either Compute Engine
//     `instance-id` or `instance-name` can be provided. For `{assignment_id}`,
//     the OSPolicyAssignment id must be provided.
func (r *ProjectsLocationsInstancesOsPolicyAssignmentsReportsService) Get(name string) *ProjectsLocationsInstancesOsPolicyAssignmentsReportsGetCall {
	c := &ProjectsLocationsInstancesOsPolicyAssignmentsReportsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesOsPolicyAssignmentsReportsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesOsPolicyAssignmentsReportsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInstancesOsPolicyAssignmentsReportsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsInstancesOsPolicyAssignmentsReportsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesOsPolicyAssignmentsReportsGetCall) Context(ctx context.Context) *ProjectsLocationsInstancesOsPolicyAssignmentsReportsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesOsPolicyAssignmentsReportsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesOsPolicyAssignmentsReportsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.locations.instances.osPolicyAssignments.reports.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.locations.instances.osPolicyAssignments.reports.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *OSPolicyAssignmentReport.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesOsPolicyAssignmentsReportsGetCall) Do(opts ...googleapi.CallOption) (*OSPolicyAssignmentReport, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OSPolicyAssignmentReport{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.locations.instances.osPolicyAssignments.reports.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List OS policy assignment reports for all Compute Engine VM instances
// in the specified zone.
//
//   - parent: The parent resource name. Format:
//     `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssig
//     nments/{assignment}/reports` For `{project}`, either `project-number` or
//     `project-id` can be provided. For `{instance}`, either `instance-name`,
//     `instance-id`, or `-` can be provided. If '-' is provided, the response
//     will include OSPolicyAssignmentReports for all instances in the
//     project/location. For `{assignment}`, either `assignment-id` or `-` can be
//     provided. If '-' is provided, the response will include
//     OSPolicyAssignmentReports for all OSPolicyAssignments in the
//     project/location. Either {instance} or {assignment} must be `-`. For
//     example:
//     `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssig
//     nments/-/reports` returns all reports for the instance
//     `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{a
//     ssignment-id}/reports` returns all the reports for the given assignment
//     across all instances.
//     `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/
//     reports` returns all the reports for all assignments across all instances.
func (r *ProjectsLocationsInstancesOsPolicyAssignmentsReportsService) List(parent string) *ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall {
	c := &ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": If provided, this field
// specifies the criteria that must be met by the `OSPolicyAssignmentReport`
// API resource that is included in the response.
func (c *ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall) Filter(filter string) *ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return.
func (c *ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall) PageSize(pageSize int64) *ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A pagination token
// returned from a previous call to the `ListOSPolicyAssignmentReports` method
// that indicates where this listing should continue from.
func (c *ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall) PageToken(pageToken string) *ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall) Context(ctx context.Context) *ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/reports")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.locations.instances.osPolicyAssignments.reports.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.locations.instances.osPolicyAssignments.reports.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOSPolicyAssignmentReportsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall) Do(opts ...googleapi.CallOption) (*ListOSPolicyAssignmentReportsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOSPolicyAssignmentReportsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.locations.instances.osPolicyAssignments.reports.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsInstancesOsPolicyAssignmentsReportsListCall) Pages(ctx context.Context, f func(*ListOSPolicyAssignmentReportsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsInstancesVulnerabilityReportsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the vulnerability report for the specified VM instance. Only VMs
// with inventory data have vulnerability reports associated with them.
//
//   - name: API resource name for vulnerability resource. Format:
//     `projects/{project}/locations/{location}/instances/{instance}/vulnerability
//     Report` For `{project}`, either `project-number` or `project-id` can be
//     provided. For `{instance}`, either Compute Engine `instance-id` or
//     `instance-name` can be provided.
func (r *ProjectsLocationsInstancesVulnerabilityReportsService) Get(name string) *ProjectsLocationsInstancesVulnerabilityReportsGetCall {
	c := &ProjectsLocationsInstancesVulnerabilityReportsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesVulnerabilityReportsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesVulnerabilityReportsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInstancesVulnerabilityReportsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsInstancesVulnerabilityReportsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesVulnerabilityReportsGetCall) Context(ctx context.Context) *ProjectsLocationsInstancesVulnerabilityReportsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesVulnerabilityReportsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesVulnerabilityReportsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.locations.instances.vulnerabilityReports.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.locations.instances.vulnerabilityReports.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *VulnerabilityReport.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsInstancesVulnerabilityReportsGetCall) Do(opts ...googleapi.CallOption) (*VulnerabilityReport, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &VulnerabilityReport{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.locations.instances.vulnerabilityReports.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsInstancesVulnerabilityReportsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List vulnerability reports for all VM instances in the specified zone.
//
//   - parent: The parent resource name. Format:
//     `projects/{project}/locations/{location}/instances/-` For `{project}`,
//     either `project-number` or `project-id` can be provided.
func (r *ProjectsLocationsInstancesVulnerabilityReportsService) List(parent string) *ProjectsLocationsInstancesVulnerabilityReportsListCall {
	c := &ProjectsLocationsInstancesVulnerabilityReportsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": This field supports filtering
// by the severity level for the vulnerability. For a list of severity levels,
// see Severity levels for vulnerabilities
// (https://cloud.google.com/container-analysis/docs/container-scanning-overview#severity_levels_for_vulnerabilities).
// The filter field follows the rules described in the AIP-160
// (https://google.aip.dev/160) guidelines as follows: + **Filter for a
// specific severity type**: you can list reports that contain vulnerabilities
// that are classified as medium by specifying
// `vulnerabilities.details.severity:MEDIUM`. + **Filter for a range of
// severities** : you can list reports that have vulnerabilities that are
// classified as critical or high by specifying
// `vulnerabilities.details.severity:HIGH OR
// vulnerabilities.details.severity:CRITICAL`
func (c *ProjectsLocationsInstancesVulnerabilityReportsListCall) Filter(filter string) *ProjectsLocationsInstancesVulnerabilityReportsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return.
func (c *ProjectsLocationsInstancesVulnerabilityReportsListCall) PageSize(pageSize int64) *ProjectsLocationsInstancesVulnerabilityReportsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A pagination token
// returned from a previous call to `ListVulnerabilityReports` that indicates
// where this listing should continue from.
func (c *ProjectsLocationsInstancesVulnerabilityReportsListCall) PageToken(pageToken string) *ProjectsLocationsInstancesVulnerabilityReportsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInstancesVulnerabilityReportsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsInstancesVulnerabilityReportsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsInstancesVulnerabilityReportsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsInstancesVulnerabilityReportsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInstancesVulnerabilityReportsListCall) Context(ctx context.Context) *ProjectsLocationsInstancesVulnerabilityReportsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInstancesVulnerabilityReportsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInstancesVulnerabilityReportsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/vulnerabilityReports")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.locations.instances.vulnerabilityReports.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.locations.instances.vulnerabilityReports.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListVulnerabilityReportsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsInstancesVulnerabilityReportsListCall) Do(opts ...googleapi.CallOption) (*ListVulnerabilityReportsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListVulnerabilityReportsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.locations.instances.vulnerabilityReports.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsInstancesVulnerabilityReportsListCall) Pages(ctx context.Context, f func(*ListVulnerabilityReportsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsOsPolicyAssignmentsCreateCall struct {
	s                  *Service
	parent             string
	ospolicyassignment *OSPolicyAssignment
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Create: Create an OS policy assignment. This method also creates the first
// revision of the OS policy assignment. This method returns a long running
// operation (LRO) that contains the rollout details. The rollout can be
// cancelled by cancelling the LRO. For more information, see Method:
// projects.locations.osPolicyAssignments.operations.cancel
// (https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
//
//   - parent: The parent resource name in the form:
//     projects/{project}/locations/{location}. Note: Specify the zone of your
//     VMs as the location.
func (r *ProjectsLocationsOsPolicyAssignmentsService) Create(parent string, ospolicyassignment *OSPolicyAssignment) *ProjectsLocationsOsPolicyAssignmentsCreateCall {
	c := &ProjectsLocationsOsPolicyAssignmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.ospolicyassignment = ospolicyassignment
	return c
}

// OsPolicyAssignmentId sets the optional parameter "osPolicyAssignmentId":
// Required. The logical name of the OS policy assignment in the project with
// the following restrictions: * Must contain only lowercase letters, numbers,
// and hyphens. * Must start with a letter. * Must be between 1-63 characters.
// * Must end with a number or a letter. * Must be unique within the project.
func (c *ProjectsLocationsOsPolicyAssignmentsCreateCall) OsPolicyAssignmentId(osPolicyAssignmentId string) *ProjectsLocationsOsPolicyAssignmentsCreateCall {
	c.urlParams_.Set("osPolicyAssignmentId", osPolicyAssignmentId)
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Restricted to 36 ASCII characters. A random UUID is
// recommended. This request is only idempotent if a `request_id` is provided.
func (c *ProjectsLocationsOsPolicyAssignmentsCreateCall) RequestId(requestId string) *ProjectsLocationsOsPolicyAssignmentsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOsPolicyAssignmentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsOsPolicyAssignmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOsPolicyAssignmentsCreateCall) Context(ctx context.Context) *ProjectsLocationsOsPolicyAssignmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOsPolicyAssignmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOsPolicyAssignmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.ospolicyassignment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/osPolicyAssignments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.locations.osPolicyAssignments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.locations.osPolicyAssignments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOsPolicyAssignmentsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.locations.osPolicyAssignments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOsPolicyAssignmentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete the OS policy assignment. This method creates a new revision
// of the OS policy assignment. This method returns a long running operation
// (LRO) that contains the rollout details. The rollout can be cancelled by
// cancelling the LRO. If the LRO completes and is not cancelled, all revisions
// associated with the OS policy assignment are deleted. For more information,
// see Method: projects.locations.osPolicyAssignments.operations.cancel
// (https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
//
// - name: The name of the OS policy assignment to be deleted.
func (r *ProjectsLocationsOsPolicyAssignmentsService) Delete(name string) *ProjectsLocationsOsPolicyAssignmentsDeleteCall {
	c := &ProjectsLocationsOsPolicyAssignmentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Restricted to 36 ASCII characters. A random UUID is
// recommended. This request is only idempotent if a `request_id` is provided.
func (c *ProjectsLocationsOsPolicyAssignmentsDeleteCall) RequestId(requestId string) *ProjectsLocationsOsPolicyAssignmentsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOsPolicyAssignmentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOsPolicyAssignmentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOsPolicyAssignmentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOsPolicyAssignmentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOsPolicyAssignmentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOsPolicyAssignmentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.locations.osPolicyAssignments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.locations.osPolicyAssignments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOsPolicyAssignmentsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.locations.osPolicyAssignments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOsPolicyAssignmentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve an existing OS policy assignment. This method always returns
// the latest revision. In order to retrieve a previous revision of the
// assignment, also provide the revision ID in the `name` parameter.
//
//   - name: The resource name of OS policy assignment. Format:
//     `projects/{project}/locations/{location}/osPolicyAssignments/{os_policy_ass
//     ignment}@{revisionId}`.
func (r *ProjectsLocationsOsPolicyAssignmentsService) Get(name string) *ProjectsLocationsOsPolicyAssignmentsGetCall {
	c := &ProjectsLocationsOsPolicyAssignmentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOsPolicyAssignmentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOsPolicyAssignmentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOsPolicyAssignmentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOsPolicyAssignmentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOsPolicyAssignmentsGetCall) Context(ctx context.Context) *ProjectsLocationsOsPolicyAssignmentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOsPolicyAssignmentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOsPolicyAssignmentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.locations.osPolicyAssignments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.locations.osPolicyAssignments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *OSPolicyAssignment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOsPolicyAssignmentsGetCall) Do(opts ...googleapi.CallOption) (*OSPolicyAssignment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OSPolicyAssignment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.locations.osPolicyAssignments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOsPolicyAssignmentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List the OS policy assignments under the parent resource. For each OS
// policy assignment, the latest revision is returned.
//
// - parent: The parent resource name.
func (r *ProjectsLocationsOsPolicyAssignmentsService) List(parent string) *ProjectsLocationsOsPolicyAssignmentsListCall {
	c := &ProjectsLocationsOsPolicyAssignmentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// assignments to return.
func (c *ProjectsLocationsOsPolicyAssignmentsListCall) PageSize(pageSize int64) *ProjectsLocationsOsPolicyAssignmentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A pagination token
// returned from a previous call to `ListOSPolicyAssignments` that indicates
// where this listing should continue from.
func (c *ProjectsLocationsOsPolicyAssignmentsListCall) PageToken(pageToken string) *ProjectsLocationsOsPolicyAssignmentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOsPolicyAssignmentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOsPolicyAssignmentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOsPolicyAssignmentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOsPolicyAssignmentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOsPolicyAssignmentsListCall) Context(ctx context.Context) *ProjectsLocationsOsPolicyAssignmentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOsPolicyAssignmentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOsPolicyAssignmentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/osPolicyAssignments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.locations.osPolicyAssignments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.locations.osPolicyAssignments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOSPolicyAssignmentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOsPolicyAssignmentsListCall) Do(opts ...googleapi.CallOption) (*ListOSPolicyAssignmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOSPolicyAssignmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.locations.osPolicyAssignments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOsPolicyAssignmentsListCall) Pages(ctx context.Context, f func(*ListOSPolicyAssignmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsOsPolicyAssignmentsListRevisionsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListRevisions: List the OS policy assignment revisions for a given OS policy
// assignment.
//
// - name: The name of the OS policy assignment to list revisions for.
func (r *ProjectsLocationsOsPolicyAssignmentsService) ListRevisions(name string) *ProjectsLocationsOsPolicyAssignmentsListRevisionsCall {
	c := &ProjectsLocationsOsPolicyAssignmentsListRevisionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// revisions to return.
func (c *ProjectsLocationsOsPolicyAssignmentsListRevisionsCall) PageSize(pageSize int64) *ProjectsLocationsOsPolicyAssignmentsListRevisionsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A pagination token
// returned from a previous call to `ListOSPolicyAssignmentRevisions` that
// indicates where this listing should continue from.
func (c *ProjectsLocationsOsPolicyAssignmentsListRevisionsCall) PageToken(pageToken string) *ProjectsLocationsOsPolicyAssignmentsListRevisionsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOsPolicyAssignmentsListRevisionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsOsPolicyAssignmentsListRevisionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOsPolicyAssignmentsListRevisionsCall) IfNoneMatch(entityTag string) *ProjectsLocationsOsPolicyAssignmentsListRevisionsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOsPolicyAssignmentsListRevisionsCall) Context(ctx context.Context) *ProjectsLocationsOsPolicyAssignmentsListRevisionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOsPolicyAssignmentsListRevisionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOsPolicyAssignmentsListRevisionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:listRevisions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.locations.osPolicyAssignments.listRevisions", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.locations.osPolicyAssignments.listRevisions" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOSPolicyAssignmentRevisionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOsPolicyAssignmentsListRevisionsCall) Do(opts ...googleapi.CallOption) (*ListOSPolicyAssignmentRevisionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOSPolicyAssignmentRevisionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.locations.osPolicyAssignments.listRevisions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOsPolicyAssignmentsListRevisionsCall) Pages(ctx context.Context, f func(*ListOSPolicyAssignmentRevisionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsOsPolicyAssignmentsPatchCall struct {
	s                  *Service
	name               string
	ospolicyassignment *OSPolicyAssignment
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Patch: Update an existing OS policy assignment. This method creates a new
// revision of the OS policy assignment. This method returns a long running
// operation (LRO) that contains the rollout details. The rollout can be
// cancelled by cancelling the LRO. For more information, see Method:
// projects.locations.osPolicyAssignments.operations.cancel
// (https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
//
//   - name: Resource name. Format:
//     `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_pol
//     icy_assignment_id}` This field is ignored when you create an OS policy
//     assignment.
func (r *ProjectsLocationsOsPolicyAssignmentsService) Patch(name string, ospolicyassignment *OSPolicyAssignment) *ProjectsLocationsOsPolicyAssignmentsPatchCall {
	c := &ProjectsLocationsOsPolicyAssignmentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.ospolicyassignment = ospolicyassignment
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to true, and
// the OS policy assignment is not found, a new OS policy assignment will be
// created. In this situation, `update_mask` is ignored.
func (c *ProjectsLocationsOsPolicyAssignmentsPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsOsPolicyAssignmentsPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// RequestId sets the optional parameter "requestId": A unique identifier for
// this request. Restricted to 36 ASCII characters. A random UUID is
// recommended. This request is only idempotent if a `request_id` is provided.
func (c *ProjectsLocationsOsPolicyAssignmentsPatchCall) RequestId(requestId string) *ProjectsLocationsOsPolicyAssignmentsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask that
// controls which fields of the assignment should be updated.
func (c *ProjectsLocationsOsPolicyAssignmentsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsOsPolicyAssignmentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOsPolicyAssignmentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsOsPolicyAssignmentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOsPolicyAssignmentsPatchCall) Context(ctx context.Context) *ProjectsLocationsOsPolicyAssignmentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOsPolicyAssignmentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOsPolicyAssignmentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.ospolicyassignment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.locations.osPolicyAssignments.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.locations.osPolicyAssignments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOsPolicyAssignmentsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.locations.osPolicyAssignments.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOsPolicyAssignmentsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOsPolicyAssignmentsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *ProjectsLocationsOsPolicyAssignmentsOperationsCancelCall {
	c := &ProjectsLocationsOsPolicyAssignmentsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOsPolicyAssignmentsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOsPolicyAssignmentsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOsPolicyAssignmentsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOsPolicyAssignmentsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOsPolicyAssignmentsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOsPolicyAssignmentsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.locations.osPolicyAssignments.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.locations.osPolicyAssignments.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOsPolicyAssignmentsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.locations.osPolicyAssignments.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOsPolicyAssignmentsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOsPolicyAssignmentsOperationsService) Get(name string) *ProjectsLocationsOsPolicyAssignmentsOperationsGetCall {
	c := &ProjectsLocationsOsPolicyAssignmentsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOsPolicyAssignmentsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOsPolicyAssignmentsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOsPolicyAssignmentsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOsPolicyAssignmentsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOsPolicyAssignmentsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOsPolicyAssignmentsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOsPolicyAssignmentsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOsPolicyAssignmentsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.locations.osPolicyAssignments.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.locations.osPolicyAssignments.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOsPolicyAssignmentsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.locations.osPolicyAssignments.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPatchDeploymentsCreateCall struct {
	s               *Service
	parent          string
	patchdeployment *PatchDeployment
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Create an OS Config patch deployment.
//
//   - parent: The project to apply this patch deployment to in the form
//     `projects/*`.
func (r *ProjectsPatchDeploymentsService) Create(parent string, patchdeployment *PatchDeployment) *ProjectsPatchDeploymentsCreateCall {
	c := &ProjectsPatchDeploymentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.patchdeployment = patchdeployment
	return c
}

// PatchDeploymentId sets the optional parameter "patchDeploymentId": Required.
// A name for the patch deployment in the project. When creating a name the
// following rules apply: * Must contain only lowercase letters, numbers, and
// hyphens. * Must start with a letter. * Must be between 1-63 characters. *
// Must end with a number or a letter. * Must be unique within the project.
func (c *ProjectsPatchDeploymentsCreateCall) PatchDeploymentId(patchDeploymentId string) *ProjectsPatchDeploymentsCreateCall {
	c.urlParams_.Set("patchDeploymentId", patchDeploymentId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPatchDeploymentsCreateCall) Fields(s ...googleapi.Field) *ProjectsPatchDeploymentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPatchDeploymentsCreateCall) Context(ctx context.Context) *ProjectsPatchDeploymentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPatchDeploymentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPatchDeploymentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.patchdeployment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/patchDeployments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.patchDeployments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.patchDeployments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *PatchDeployment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsPatchDeploymentsCreateCall) Do(opts ...googleapi.CallOption) (*PatchDeployment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PatchDeployment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.patchDeployments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPatchDeploymentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete an OS Config patch deployment.
//
//   - name: The resource name of the patch deployment in the form
//     `projects/*/patchDeployments/*`.
func (r *ProjectsPatchDeploymentsService) Delete(name string) *ProjectsPatchDeploymentsDeleteCall {
	c := &ProjectsPatchDeploymentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPatchDeploymentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsPatchDeploymentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPatchDeploymentsDeleteCall) Context(ctx context.Context) *ProjectsPatchDeploymentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPatchDeploymentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPatchDeploymentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.patchDeployments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.patchDeployments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsPatchDeploymentsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.patchDeployments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPatchDeploymentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get an OS Config patch deployment.
//
//   - name: The resource name of the patch deployment in the form
//     `projects/*/patchDeployments/*`.
func (r *ProjectsPatchDeploymentsService) Get(name string) *ProjectsPatchDeploymentsGetCall {
	c := &ProjectsPatchDeploymentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPatchDeploymentsGetCall) Fields(s ...googleapi.Field) *ProjectsPatchDeploymentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsPatchDeploymentsGetCall) IfNoneMatch(entityTag string) *ProjectsPatchDeploymentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPatchDeploymentsGetCall) Context(ctx context.Context) *ProjectsPatchDeploymentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPatchDeploymentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPatchDeploymentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.patchDeployments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.patchDeployments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *PatchDeployment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsPatchDeploymentsGetCall) Do(opts ...googleapi.CallOption) (*PatchDeployment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PatchDeployment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.patchDeployments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPatchDeploymentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Get a page of OS Config patch deployments.
//
// - parent: The resource name of the parent in the form `projects/*`.
func (r *ProjectsPatchDeploymentsService) List(parent string) *ProjectsPatchDeploymentsListCall {
	c := &ProjectsPatchDeploymentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of patch
// deployments to return. Default is 100.
func (c *ProjectsPatchDeploymentsListCall) PageSize(pageSize int64) *ProjectsPatchDeploymentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A pagination token
// returned from a previous call to ListPatchDeployments that indicates where
// this listing should continue from.
func (c *ProjectsPatchDeploymentsListCall) PageToken(pageToken string) *ProjectsPatchDeploymentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPatchDeploymentsListCall) Fields(s ...googleapi.Field) *ProjectsPatchDeploymentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsPatchDeploymentsListCall) IfNoneMatch(entityTag string) *ProjectsPatchDeploymentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPatchDeploymentsListCall) Context(ctx context.Context) *ProjectsPatchDeploymentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPatchDeploymentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPatchDeploymentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/patchDeployments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.patchDeployments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.patchDeployments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPatchDeploymentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsPatchDeploymentsListCall) Do(opts ...googleapi.CallOption) (*ListPatchDeploymentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPatchDeploymentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.patchDeployments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsPatchDeploymentsListCall) Pages(ctx context.Context, f func(*ListPatchDeploymentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsPatchDeploymentsPatchCall struct {
	s               *Service
	name            string
	patchdeployment *PatchDeployment
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Update an OS Config patch deployment.
//
//   - name: Unique name for the patch deployment resource in a project. The
//     patch deployment name is in the form:
//     `projects/{project_id}/patchDeployments/{patch_deployment_id}`. This field
//     is ignored when you create a new patch deployment.
func (r *ProjectsPatchDeploymentsService) Patch(name string, patchdeployment *PatchDeployment) *ProjectsPatchDeploymentsPatchCall {
	c := &ProjectsPatchDeploymentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.patchdeployment = patchdeployment
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask that
// controls which fields of the patch deployment should be updated.
func (c *ProjectsPatchDeploymentsPatchCall) UpdateMask(updateMask string) *ProjectsPatchDeploymentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPatchDeploymentsPatchCall) Fields(s ...googleapi.Field) *ProjectsPatchDeploymentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPatchDeploymentsPatchCall) Context(ctx context.Context) *ProjectsPatchDeploymentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPatchDeploymentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPatchDeploymentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.patchdeployment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.patchDeployments.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.patchDeployments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *PatchDeployment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsPatchDeploymentsPatchCall) Do(opts ...googleapi.CallOption) (*PatchDeployment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PatchDeployment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.patchDeployments.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPatchDeploymentsPauseCall struct {
	s                           *Service
	name                        string
	pausepatchdeploymentrequest *PausePatchDeploymentRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Pause: Change state of patch deployment to "PAUSED". Patch deployment in
// paused state doesn't generate patch jobs.
//
//   - name: The resource name of the patch deployment in the form
//     `projects/*/patchDeployments/*`.
func (r *ProjectsPatchDeploymentsService) Pause(name string, pausepatchdeploymentrequest *PausePatchDeploymentRequest) *ProjectsPatchDeploymentsPauseCall {
	c := &ProjectsPatchDeploymentsPauseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.pausepatchdeploymentrequest = pausepatchdeploymentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPatchDeploymentsPauseCall) Fields(s ...googleapi.Field) *ProjectsPatchDeploymentsPauseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPatchDeploymentsPauseCall) Context(ctx context.Context) *ProjectsPatchDeploymentsPauseCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPatchDeploymentsPauseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPatchDeploymentsPauseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.pausepatchdeploymentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:pause")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.patchDeployments.pause", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.patchDeployments.pause" call.
// Any non-2xx status code is an error. Response headers are in either
// *PatchDeployment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsPatchDeploymentsPauseCall) Do(opts ...googleapi.CallOption) (*PatchDeployment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PatchDeployment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.patchDeployments.pause", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPatchDeploymentsResumeCall struct {
	s                            *Service
	name                         string
	resumepatchdeploymentrequest *ResumePatchDeploymentRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Resume: Change state of patch deployment back to "ACTIVE". Patch deployment
// in active state continues to generate patch jobs.
//
//   - name: The resource name of the patch deployment in the form
//     `projects/*/patchDeployments/*`.
func (r *ProjectsPatchDeploymentsService) Resume(name string, resumepatchdeploymentrequest *ResumePatchDeploymentRequest) *ProjectsPatchDeploymentsResumeCall {
	c := &ProjectsPatchDeploymentsResumeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.resumepatchdeploymentrequest = resumepatchdeploymentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPatchDeploymentsResumeCall) Fields(s ...googleapi.Field) *ProjectsPatchDeploymentsResumeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPatchDeploymentsResumeCall) Context(ctx context.Context) *ProjectsPatchDeploymentsResumeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPatchDeploymentsResumeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPatchDeploymentsResumeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.resumepatchdeploymentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:resume")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.patchDeployments.resume", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.patchDeployments.resume" call.
// Any non-2xx status code is an error. Response headers are in either
// *PatchDeployment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsPatchDeploymentsResumeCall) Do(opts ...googleapi.CallOption) (*PatchDeployment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PatchDeployment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.patchDeployments.resume", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPatchJobsCancelCall struct {
	s                     *Service
	name                  string
	cancelpatchjobrequest *CancelPatchJobRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Cancel: Cancel a patch job. The patch job must be active. Canceled patch
// jobs cannot be restarted.
//
// - name: Name of the patch in the form `projects/*/patchJobs/*`.
func (r *ProjectsPatchJobsService) Cancel(name string, cancelpatchjobrequest *CancelPatchJobRequest) *ProjectsPatchJobsCancelCall {
	c := &ProjectsPatchJobsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.cancelpatchjobrequest = cancelpatchjobrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPatchJobsCancelCall) Fields(s ...googleapi.Field) *ProjectsPatchJobsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPatchJobsCancelCall) Context(ctx context.Context) *ProjectsPatchJobsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPatchJobsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPatchJobsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.cancelpatchjobrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.patchJobs.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.patchJobs.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *PatchJob.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsPatchJobsCancelCall) Do(opts ...googleapi.CallOption) (*PatchJob, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PatchJob{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.patchJobs.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPatchJobsExecuteCall struct {
	s                      *Service
	parent                 string
	executepatchjobrequest *ExecutePatchJobRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Execute: Patch VM instances by creating and running a patch job.
//
// - parent: The project in which to run this patch in the form `projects/*`.
func (r *ProjectsPatchJobsService) Execute(parent string, executepatchjobrequest *ExecutePatchJobRequest) *ProjectsPatchJobsExecuteCall {
	c := &ProjectsPatchJobsExecuteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.executepatchjobrequest = executepatchjobrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPatchJobsExecuteCall) Fields(s ...googleapi.Field) *ProjectsPatchJobsExecuteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPatchJobsExecuteCall) Context(ctx context.Context) *ProjectsPatchJobsExecuteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPatchJobsExecuteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPatchJobsExecuteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.executepatchjobrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/patchJobs:execute")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.patchJobs.execute", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.patchJobs.execute" call.
// Any non-2xx status code is an error. Response headers are in either
// *PatchJob.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsPatchJobsExecuteCall) Do(opts ...googleapi.CallOption) (*PatchJob, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PatchJob{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.patchJobs.execute", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPatchJobsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get the patch job. This can be used to track the progress of an ongoing
// patch job or review the details of completed jobs.
//
// - name: Name of the patch in the form `projects/*/patchJobs/*`.
func (r *ProjectsPatchJobsService) Get(name string) *ProjectsPatchJobsGetCall {
	c := &ProjectsPatchJobsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPatchJobsGetCall) Fields(s ...googleapi.Field) *ProjectsPatchJobsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsPatchJobsGetCall) IfNoneMatch(entityTag string) *ProjectsPatchJobsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPatchJobsGetCall) Context(ctx context.Context) *ProjectsPatchJobsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPatchJobsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPatchJobsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.patchJobs.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.patchJobs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *PatchJob.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsPatchJobsGetCall) Do(opts ...googleapi.CallOption) (*PatchJob, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PatchJob{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.patchJobs.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPatchJobsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Get a list of patch jobs.
//
// - parent: In the form of `projects/*`.
func (r *ProjectsPatchJobsService) List(parent string) *ProjectsPatchJobsListCall {
	c := &ProjectsPatchJobsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": If provided, this field
// specifies the criteria that must be met by patch jobs to be included in the
// response. Currently, filtering is only available on the patch_deployment
// field.
func (c *ProjectsPatchJobsListCall) Filter(filter string) *ProjectsPatchJobsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// instance status to return.
func (c *ProjectsPatchJobsListCall) PageSize(pageSize int64) *ProjectsPatchJobsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A pagination token
// returned from a previous call that indicates where this listing should
// continue from.
func (c *ProjectsPatchJobsListCall) PageToken(pageToken string) *ProjectsPatchJobsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPatchJobsListCall) Fields(s ...googleapi.Field) *ProjectsPatchJobsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsPatchJobsListCall) IfNoneMatch(entityTag string) *ProjectsPatchJobsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPatchJobsListCall) Context(ctx context.Context) *ProjectsPatchJobsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPatchJobsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPatchJobsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/patchJobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.patchJobs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.patchJobs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPatchJobsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsPatchJobsListCall) Do(opts ...googleapi.CallOption) (*ListPatchJobsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPatchJobsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.patchJobs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsPatchJobsListCall) Pages(ctx context.Context, f func(*ListPatchJobsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsPatchJobsInstanceDetailsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Get a list of instance details for a given patch job.
//
//   - parent: The parent for the instances are in the form of
//     `projects/*/patchJobs/*`.
func (r *ProjectsPatchJobsInstanceDetailsService) List(parent string) *ProjectsPatchJobsInstanceDetailsListCall {
	c := &ProjectsPatchJobsInstanceDetailsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters results listed in the response. This field supports filtering
// results by instance zone, name, state, or `failure_reason`.
func (c *ProjectsPatchJobsInstanceDetailsListCall) Filter(filter string) *ProjectsPatchJobsInstanceDetailsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// instance details records to return. Default is 100.
func (c *ProjectsPatchJobsInstanceDetailsListCall) PageSize(pageSize int64) *ProjectsPatchJobsInstanceDetailsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A pagination token
// returned from a previous call that indicates where this listing should
// continue from.
func (c *ProjectsPatchJobsInstanceDetailsListCall) PageToken(pageToken string) *ProjectsPatchJobsInstanceDetailsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPatchJobsInstanceDetailsListCall) Fields(s ...googleapi.Field) *ProjectsPatchJobsInstanceDetailsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsPatchJobsInstanceDetailsListCall) IfNoneMatch(entityTag string) *ProjectsPatchJobsInstanceDetailsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPatchJobsInstanceDetailsListCall) Context(ctx context.Context) *ProjectsPatchJobsInstanceDetailsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPatchJobsInstanceDetailsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPatchJobsInstanceDetailsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/instanceDetails")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "osconfig.projects.patchJobs.instanceDetails.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "osconfig.projects.patchJobs.instanceDetails.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPatchJobInstanceDetailsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsPatchJobsInstanceDetailsListCall) Do(opts ...googleapi.CallOption) (*ListPatchJobInstanceDetailsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPatchJobInstanceDetailsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "osconfig.projects.patchJobs.instanceDetails.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsPatchJobsInstanceDetailsListCall) Pages(ctx context.Context, f func(*ListPatchJobInstanceDetailsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
