/* scram.h --- Prototypes for SCRAM mechanism
 * Copyright (C) 2009-2025 Simon Josefsson
 *
 * This file is part of GNU SASL Library.
 *
 * GNU SASL Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * GNU SASL Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNU SASL Library; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 */

#ifndef SCRAM_H
# define SCRAM_H

# include <gsasl.h>

# ifdef USE_SCRAM_SHA1

#  define GSASL_SCRAM_SHA1_NAME "SCRAM-SHA-1"
#  define GSASL_SCRAM_SHA1_PLUS_NAME "SCRAM-SHA-1-PLUS"

extern Gsasl_mechanism _gsasl_scram_sha1_mechanism;
extern Gsasl_mechanism _gsasl_scram_sha1_plus_mechanism;

int _gsasl_scram_sha1_client_start (Gsasl_session * sctx, void **mech_data);

int
_gsasl_scram_sha1_plus_client_start (Gsasl_session * sctx, void **mech_data);

int
_gsasl_scram_client_step (Gsasl_session * sctx,
			  void *mech_data,
			  const char *input, size_t input_len,
			  char **output, size_t *output_len);

void _gsasl_scram_client_finish (Gsasl_session * sctx, void *mech_data);


int _gsasl_scram_sha1_server_start (Gsasl_session * sctx, void **mech_data);

int
_gsasl_scram_sha1_plus_server_start (Gsasl_session * sctx, void **mech_data);

int _gsasl_scram_server_step (Gsasl_session * sctx,
			      void *mech_data,
			      const char *input,
			      size_t input_len,
			      char **output, size_t *output_len);

void _gsasl_scram_server_finish (Gsasl_session * sctx, void *mech_data);

# endif

# ifdef USE_SCRAM_SHA256

#  define GSASL_SCRAM_SHA256_NAME "SCRAM-SHA-256"
#  define GSASL_SCRAM_SHA256_PLUS_NAME "SCRAM-SHA-256-PLUS"

extern Gsasl_mechanism _gsasl_scram_sha256_mechanism;
extern Gsasl_mechanism _gsasl_scram_sha256_plus_mechanism;

int _gsasl_scram_sha256_client_start (Gsasl_session * sctx, void **mech_data);

int
_gsasl_scram_sha256_plus_client_start (Gsasl_session * sctx,
				       void **mech_data);

int
_gsasl_scram_client_step (Gsasl_session * sctx,
			  void *mech_data,
			  const char *input, size_t input_len,
			  char **output, size_t *output_len);

void _gsasl_scram_client_finish (Gsasl_session * sctx, void *mech_data);


int _gsasl_scram_sha256_server_start (Gsasl_session * sctx, void **mech_data);

int
_gsasl_scram_sha256_plus_server_start (Gsasl_session * sctx,
				       void **mech_data);

int _gsasl_scram_server_step (Gsasl_session * sctx,
			      void *mech_data,
			      const char *input,
			      size_t input_len,
			      char **output, size_t *output_len);

void _gsasl_scram_server_finish (Gsasl_session * sctx, void *mech_data);

# endif

#endif /* SCRAM_H */
