/* $Id$
 *
 * Lasso - A free implementation of the Liberty Alliance specifications.
 *
 * Copyright (C) 2004-2007 Entr'ouvert
 * http://lasso.entrouvert.org
 *
 * Authors: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LASSO_XML_ENC_H__
#define __LASSO_XML_ENC_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <xmlsec/xmlenc.h>

#include "xml.h"

/**
 * LassoEncryptionSymKeyType:
 * @LASSO_ENCRYPTION_SYM_KEY_TYPE_DEFAULT : Default type (AES 128)
 * @LASSO_ENCRYPTION_SYM_KEY_TYPE_AES_256 : Aes 256 bits key
 * @LASSO_ENCRYPTION_SYM_KEY_TYPE_AES_128 : Aes 128 bits key
 * @LASSO_ENCRYPTION_SYM_KEY_TYPE_3DES : Triple DES 192 bits key
 *
 * Encryption symetric key type.
 **/
typedef enum {
	LASSO_ENCRYPTION_SYM_KEY_TYPE_DEFAULT,
	LASSO_ENCRYPTION_SYM_KEY_TYPE_AES_256,
	LASSO_ENCRYPTION_SYM_KEY_TYPE_AES_128,
	LASSO_ENCRYPTION_SYM_KEY_TYPE_3DES,
	LASSO_ENCRYTPION_SYM_KEY_TYPE_LAST
} LassoEncryptionSymKeyType;

/**
 * LassoKeyEncryptionMethod:
 * @LASSO_KEY_ENCRYPTION_METHOD_PKCS1 : RSA PKCS1.5 padding
 * @LASSO_KEY_ENCRYPTION_METHOD_OAEP : RSA OAEP padding
 *
 * Encryption symetric key encryption type.
 **/
typedef enum {
	LASSO_KEY_ENCRYPTION_METHOD_DEFAULT,
	LASSO_KEY_ENCRYPTION_METHOD_PKCS1,
	LASSO_KEY_ENCRYPTION_METHOD_OAEP,
	LASSO_KEY_ENCRYPTION_METHOD_LAST,
	LASSO_KEY_ENCRYPTION_METHOD_INVALID = -1
} LassoKeyEncryptionMethod;

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __LASSO_XML_H__ */
