--
--  Copyright (C) 2014-2022, AdaCore
--  SPDX-License-Identifier: Apache-2.0
--

with Langkit_Support.Token_Data_Handlers;
use Langkit_Support.Token_Data_Handlers;

with Libadalang.Common; use Libadalang.Common;
limited with Libadalang.Implementation;
with Libadalang.Lexer_Implementation;
use Libadalang.Lexer_Implementation;
with Libadalang.Parsers; use Libadalang.Parsers;

--  The rationale for this unit is explained in the $.Parsers package body

private package Libadalang.Parsers_Impl is

   procedure Init_Parser
     (Input        : Internal_Lexer_Input;
      With_Trivia  : Boolean;
      Unit         : access Implementation.Analysis_Unit_Type;
      TDH          : Token_Data_Handler_Access;
      Parser       : in out Parser_Type)
   with Export, External_Name => "Libadalang__init_parser";

   function Parse
     (Parser         : in out Parser_Type;
      Check_Complete : Boolean := True;
      Rule           : Grammar_Rule)
      return Parsed_Node
   with Export, External_Name => "Libadalang__parse";

   procedure Reset (Parser : in out Parser_Type)
   with Export, External_Name => "Libadalang__reset_parser";

   procedure Initialize (Parser : in out Parser_Type)
   with Export, External_Name => "Libadalang__initialize_parser";

   procedure Destroy (Parser : in out Parser_Type)
   with Export, External_Name => "Libadalang__destroy_parser";

end Libadalang.Parsers_Impl;
