if (CMAKE_SYSTEM_NAME STREQUAL "iOS" OR CMAKE_SYSTEM_NAME STREQUAL "Android")
    if (CMAKE_SYSTEM_NAME STREQUAL "Android")
        option(ENABLE_SYNC "Turns on sync functionality" ON)
        option(ENABLE_JAVA_BINDINGS "Enable the target to build the Java Bindings" ON)
        option(ENABLE_SDKLIB_WERROR "Disable warnings as errors" OFF)
    else()
        option(ENABLE_SYNC "Turns on sync functionality" OFF)
        option(ENABLE_JAVA_BINDINGS "Enable the target to build the Java Bindings" OFF)
    endif()
    option(ENABLE_CHAT "Turns on chat management functionality" ON)
    option(USE_MEDIAINFO "Used to determine media properties and set those as node attributes" OFF)
    option(USE_FREEIMAGE "Used to create previews/thumbnails for photos/pictures" OFF)
    option(USE_FFMPEG "Used to create previews/thumbnails for video files" OFF)
    option(USE_LIBUV "Includes the library and turns on internal web and ftp server functionality" ON)
    option(USE_PDFIUM "Used to create previews/thumbnails for PDF files" OFF)
    option(USE_READLINE "Use the readline library for the console" OFF)
    option(USE_OPENSSL "Use the OpenSSL library or a compatible one" ON)
else()
    option(ENABLE_SYNC "Turns on sync functionality" ON)
    option(ENABLE_CHAT "Turns on chat management functionality" OFF)
    option(USE_MEDIAINFO "Used to determine media properties and set those as node attributes" ON)
    option(USE_FREEIMAGE "Used to create previews/thumbnails for photos/pictures" ON)
    option(USE_FFMPEG "Used to create previews/thumbnails for video files" ON)
    option(USE_LIBUV "Includes the library and turns on internal web and ftp server functionality" OFF)
    option(USE_PDFIUM "Used to create previews/thumbnails for PDF files" ON)
    if (WIN32)
        option(USE_READLINE "Use the readline library for the console" OFF)
    else()
        option(USE_READLINE "Use the readline library for the console" ON)
    endif()
    if (APPLE) # AND NOT iOS
        option(USE_OPENSSL "Use the OpenSSL library or a compatible one" OFF)
    else()
        option(USE_OPENSSL "Use the OpenSSL library or a compatible one" ON)
    endif()
    option(ENABLE_JAVA_BINDINGS "Enable the target to build the Java Bindings" OFF)
endif()
option(ENABLE_LOG_PERFORMANCE "Faster log message generation" OFF)
option(ENABLE_DRIVE_NOTIFICATIONS "Allows to monitor (external) drives being [dis]connected to the computer" OFF)
option(ENABLE_QT_BINDINGS "Enable the target to build the Qt Bindings" OFF)
if (USE_FREEIMAGE)
    option(ENABLE_ISOLATED_GFX "Turns on isolated GFX processor" ON)
else()
    option(ENABLE_ISOLATED_GFX "Turns on isolated GFX processor" OFF)
endif()
option(ENABLE_ASAN "Enable address sanitizer" OFF)
option(ENABLE_UBSAN "Enable undefined behavior sanitizer" OFF)
option(ENABLE_TSAN "Enable thread sanitizer" OFF)
