# ctxzap
`import "github.com/grpc-ecosystem/go-grpc-middleware/logging/zap/ctxzap"`

* [Overview](#pkg-overview)
* [Imported Packages](#pkg-imports)
* [Index](#pkg-index)
* [Examples](#pkg-examples)

## <a name="pkg-overview">Overview</a>
`ctxzap` is a ctxlogger that is backed by Zap

It accepts a user-configured `zap.Logger` that will be used for logging. The same `zap.Logger` will
be populated into the `context.Context` passed into gRPC handler code.

You can use `ctxzap.Extract` to log into a request-scoped `zap.Logger` instance in your handler code.

As `ctxzap.Extract` will iterate all tags on from `grpc_ctxtags` it is therefore expensive so it is advised that you
extract once at the start of the function from the context and reuse it for the remainder of the function (see examples).

Please see examples and tests for examples of use.

## <a name="pkg-imports">Imported Packages</a>

- [github.com/grpc-ecosystem/go-grpc-middleware/tags](./../../../tags)
- [go.uber.org/zap](https://godoc.org/go.uber.org/zap)
- [go.uber.org/zap/zapcore](https://godoc.org/go.uber.org/zap/zapcore)
- [golang.org/x/net/context](https://godoc.org/golang.org/x/net/context)

## <a name="pkg-index">Index</a>
* [func AddFields(ctx context.Context, fields ...zapcore.Field)](#AddFields)
* [func Extract(ctx context.Context) \*zap.Logger](#Extract)
* [func TagsToFields(ctx context.Context) []zapcore.Field](#TagsToFields)
* [func ToContext(ctx context.Context, logger \*zap.Logger) context.Context](#ToContext)

#### <a name="pkg-examples">Examples</a>
* [Extract (Unary)](#example_Extract_unary)

#### <a name="pkg-files">Package files</a>
[context.go](./context.go) [doc.go](./doc.go) 

## <a name="AddFields">func</a> [AddFields](./context.go#L23)
``` go
func AddFields(ctx context.Context, fields ...zapcore.Field)
```
AddFields adds zap fields to the logger.

## <a name="Extract">func</a> [Extract](./context.go#L35)
``` go
func Extract(ctx context.Context) *zap.Logger
```
Extract takes the call-scoped Logger from grpc_zap middleware.

It always returns a Logger that has all the grpc_ctxtags updated.

#### Example:

<details>
<summary>Click to expand code.</summary>

```go
package ctxzap_test

import (
    "context"

    "github.com/grpc-ecosystem/go-grpc-middleware/logging/zap/ctxzap"
    "github.com/grpc-ecosystem/go-grpc-middleware/tags"
    pb_testproto "github.com/grpc-ecosystem/go-grpc-middleware/testing/testproto"
    "go.uber.org/zap"
)

var zapLogger *zap.Logger

// Simple unary handler that adds custom fields to the requests's context. These will be used for all log statements.
func ExampleExtract_unary() {
    _ = func(ctx context.Context, ping *pb_testproto.PingRequest) (*pb_testproto.PingResponse, error) {
        // Add fields the ctxtags of the request which will be added to all extracted loggers.
        grpc_ctxtags.Extract(ctx).Set("custom_tags.string", "something").Set("custom_tags.int", 1337)

        // Extract a single request-scoped zap.Logger and log messages.
        l := ctxzap.Extract(ctx)
        l.Info("some ping")
        l.Info("another ping")
        return &pb_testproto.PingResponse{Value: ping.Value}, nil
    }
}
```

</details>

## <a name="TagsToFields">func</a> [TagsToFields](./context.go#L48)
``` go
func TagsToFields(ctx context.Context) []zapcore.Field
```
TagsToFields transforms the Tags on the supplied context into zap fields.

## <a name="ToContext">func</a> [ToContext](./context.go#L59)
``` go
func ToContext(ctx context.Context, logger *zap.Logger) context.Context
```
ToContext adds the zap.Logger to the context for extraction later.
Returning the new context that has been created.

- - -
Generated by [godoc2ghmd](https://github.com/GandalfUK/godoc2ghmd)