//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// ホストネットワークのドライバ (基本クラス)
//

#include "netdriver.h"
#include "mainapp.h"
#include <sys/wait.h>

// コンストラクタ
NetDriver::NetDriver(HostDevice *hostdev_, const char *drivername_)
	: inherited(hostdev_, drivername_)
{
}

// デストラクタ
NetDriver::~NetDriver()
{
}

// ifup スクリプト実行
bool
NetDriver::Run_ifup()
{
	return RunScript("nono-ifup");
}

// ifdown スクリプト実行
bool
NetDriver::Run_ifdown()
{
	return RunScript("nono-ifdown");
}

// スクリプトを実行
bool
NetDriver::RunScript(const char *filename)
{
	std::string cmd;
	int r;

	// ファイルが存在するか
	std::string path = gMainApp.SearchFile(filename);
	if (path.empty()) {
		errmsg = string_format("%s not found", filename);
		goto abort;
	}

	// コマンドラインを作成
	cmd = path + " " + ifname;
	putmsg(1, "%s: command: %s", __func__, cmd.c_str());

	// 実行
	r = system(cmd.c_str());
	if (r == -1) {
		errmsg = string_format("system(\"%s\"): %s",
			cmd.c_str(), strerror(errno));
		goto abort;
	}

	if (WIFEXITED(r)) {
		int exitcode = WEXITSTATUS(r);
		if (exitcode == 0) {
			// ここが正常終了
			putmsg(1, "%s: \"%s\" exited successfully", __func__, cmd.c_str());
			return true;
		}
		if (exitcode == 127) {
			errmsg = string_format("\"%s\": shell execution failed",
				cmd.c_str());
		} else {
			errmsg = string_format("\"%s\" exited with code %d",
				cmd.c_str(), exitcode);
		}
	} else if (WIFSIGNALED(r)) {
		int signo = WTERMSIG(r);
		errmsg = string_format("\"%s\" terminated with signal %d",
			cmd.c_str(), signo);
	} else {
		// どうしたらいいかよく分からんのでとりあえず表示だけ。
		errmsg = string_format("\"%s\" terminated:"
			"IFSTOPPED=%d STOPSIG=%d IFCONTINUED=%d COREDUMP=%d",
			cmd.c_str(),
			WIFSTOPPED(r), WSTOPSIG(r), WIFCONTINUED(r), WCOREDUMP(r));
	}

 abort:
	putmsg(1, "%s: %s", __func__, errmsg.c_str());
	return false;
}
