//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// ADPCM (MSM6258V)
//

#pragma once

#include "device.h"

class DMACDevice;
class PPIDevice;

class ADPCMDevice : public IODevice
{
	using inherited = IODevice;

	static const uint32 baseaddr = 0xe92000;

	static const uint8 STAT_PLAY	= 0x80;

	static const uint8 REC_START	= 0x04;
	static const uint8 PLAY_START	= 0x02;
	static const uint8 STOP			= 0x01;

 public:
	ADPCMDevice();
	~ADPCMDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

	// CT1 によるクロック切り替え。OPM から呼ばれる。
	void SetClock(bool);

	// DMAC から呼ばれる。
	void AssertDACK(bool tc);
	void NegateDACK();

 protected:
	// BusIO インタフェース
	static const uint32 NPORT = 2;
	busdata ReadPort(uint32 offset);
	busdata WritePort(uint32 offset, uint32 data);
	busdata PeekPort(uint32 offset);
	bool PokePort(uint32 offset, uint32 data);

 private:
	void StartPlay();

	void EventCallback(Event *);

	bool playing {};
	bool dack {};
	int clk {};
	int div {};

	DMACDevice *dmac {};
	PPIDevice *ppi {};

	Event *event {};
};

static inline ADPCMDevice *GetADPCMDevice() {
	return Object::GetObject<ADPCMDevice>(OBJ_ADPCM);
}
