//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// UI スレッドへのメッセージ機構
//

#include "uimessage.h"

// コンストラクタ
UIMessage::UIMessage()
{
}

// デストラクタ
UIMessage::~UIMessage()
{
}

// コールバック関数をセットして、サービスを開始。
void
UIMessage::StartUIMessage(const std::function<void(uint, int)>& func_)
{
	std::lock_guard<std::mutex> lock(mtx);
	func = func_;
}

// サービスを停止。
void
UIMessage::StopUIMessage()
{
	std::lock_guard<std::mutex> lock(mtx);
	func = std::function<void(uint, int)>();
}

// UIMessage をポスト(実行)する。
void
UIMessage::Post(uint id, int arg)
{
	std::lock_guard<std::mutex> lock(mtx);
	if ((bool)func) {
		func(id, arg);
	}
}
