//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// メインウィンドウ
//

#pragma once

#include "wxnono.h"
#include "monitor.h"
#include <array>

class FDDDevice;
class Keyboard;
class HostCOMDevice;
class HostNetDevice;
class PowerDevice;
class SCSITarget;
class Syncer;
class WXBitmapPanel;
class WXMainView;
class WXStatusPanel;

class WXMainFrame : public wxFrame
{
	using inherited = wxFrame;
 public:
	explicit WXMainFrame(wxWindow *);
	~WXMainFrame() override;

	// (設定反映などの) 初期化
	bool Init();

	void Fit() override;
	bool Layout() override;

	// ウィンドウをリストから削除する。
	// ウィンドウをクローズする際に呼び出すこと。
	void DeleteWindow(wxWindow *);

	// 起動時にオープンするサブウィンドウの一覧
	static std::array<bool, ID_SUBWIN_MAX> subwindow_start;

	// モニタウィンドウの更新頻度取得・設定
	static int GetMonitorRate() { return monitor_rate; }
	static void SetMonitorRate(int val) { monitor_rate = val; }

	// メンバの取得
	WXMainView *GetMainView() { return mainview; }

	// ホストドライバ用のメニューを作成して返す
	void CreateHostNetMenu(wxMenu *, uint unit);
	void CreateHostComMenu(wxMenu *, int n);

	// SCSI リムーバブルデバイス、FD 用のメニューを作成して返す
	wxMenu *CreateSCSIRemovableMenu(uint id) const;
	wxMenu *CreateFDMenu(int unit) const;

	// FD を挿入する
	void InsertFD(int unit, const std::string& path);
	// FD をイジェクトする
	void EjectFD(int unit, bool force);

	// CD を挿入する
	void InsertCD(int id, const std::string& path);
	// CD をイジェクトする
	void EjectCD(int id, bool force);

	// ウィンドウタイトルを設定。
	void SetMyTitle(bool mousemode);

 private:
	void OnIdle(wxIdleEvent& event);
	void OnClose(wxCloseEvent& event);
	void OnActivate(wxActivateEvent& event);

	void OnPowerButton(wxCommandEvent& event);
	void OnPowerButtonUI(wxUpdateUIEvent& event);
	void OnSoftReset(wxCommandEvent& event);
	void OnResetButton(wxCommandEvent& event);
	void OnNMIButton(wxCommandEvent& event);
	void OnRestartVM(wxCommandEvent& event);
	void OnExit(wxCommandEvent&);

	void OnFullSpeed(wxCommandEvent& event);
	void OnFullSpeedUI(wxUpdateUIEvent& event);
	void OnMenuInput(wxCommandEvent& event);
	void OnMenuInputUI(wxUpdateUIEvent& event);
	void OnMenuHostNet(wxCommandEvent& event);
	void OnMenuHostNetUI(wxUpdateUIEvent& event);
	void OnMenuHostCom(wxCommandEvent& event);
	void OnMenuHostComUI(wxUpdateUIEvent& event);
	void OnHostNetFailed(wxCommandEvent& event);
	void OnHostComFailed(wxCommandEvent& event);
	void HostDriverFailed(const wxString& hostdev, const wxString& errmsg);

	void OnMenuScale(wxCommandEvent& event);
	void OnMenuScaleUI(wxUpdateUIEvent& event);
	void OnMenuFontSize(wxCommandEvent& event);
	void OnMenuFontSizeUI(wxUpdateUIEvent& event);
	void OnMenuMonRate(wxCommandEvent& event);
	void OnMenuMonRateUI(wxUpdateUIEvent& event);
	void OnShowStatusPanel(wxCommandEvent& event);
	void OnShowStatusPanelUI(wxUpdateUIEvent& event);

	void OnFDInsert(wxCommandEvent& event);
	void OnFDInsertUI(wxUpdateUIEvent& event);
	void OnFDEject(wxCommandEvent& event);
	void OnFDEjectUI(wxUpdateUIEvent& event);
	void OnFDForce(wxCommandEvent& event);
	void OnFDForceUI(wxUpdateUIEvent& event);
	void OnCDInsert(wxCommandEvent& event);
	void OnCDInsertUI(wxUpdateUIEvent& event);
	void OnCDEject(wxCommandEvent& event);
	void OnCDEjectUI(wxUpdateUIEvent& event);
	void OnCDForce(wxCommandEvent& event);
	void OnCDForceUI(wxUpdateUIEvent& event);
	void OnMouseMode(wxCommandEvent& event);
	void OnMouseModeUI(wxUpdateUIEvent& event);
	void OnKeyboardConnect(wxCommandEvent& event);
	void OnKeyboardConnectUI(wxUpdateUIEvent& event);

	void OnWindow(wxCommandEvent&);
	void DoWindow(int id, bool enable);
	void OnWindowUI(wxUpdateUIEvent&);

	void OnAbout(wxCommandEvent&);

	// 指定のモニタ/サブウィンドウがあればメニューに追加する
	void AppendIf(wxMenu *, int id, const wxString& label);

	int CreateMainviewScaleTable();
	void CreateMonRateTable();

	// リムーバブルデバイス用のメニューを作成して追加する
	void CreateRemovableMenu(wxMenu *);

	// ウィンドウをリストに追加する。
	void AddWindow(int id, wxWindow *);

	// 指定 ID のサブウィンドウがリストにあれば true を返す
	bool IsExistWindow(int id);

	// UI 表示用テキストを返す。
	wxString GetHostNetLabel(uint n) const;
	wxString GetHostComLabel(uint n) const;

	// メイン MPU 名を返す
	wxString MPUName() const { return mpuname; }

	// サブウィンドウリスト
	std::unique_ptr<wxWindow> windows[ID_SUBWIN_MAX] {};

	// メニュー操作用の SCSI デバイス
	// (ホストアダプタが増えた時のことは考えていない)
	std::array<SCSITarget *, 8> scsidev {};

	// メニュー操作用の FDD デバイス
	// (6台構成のことは考えていない)
	std::array<FDDDevice *, 4> fdd_array {};

	// ウィンドウタイトル
	wxString frame_title {};

	// ファイルダイアログを表示する際のカレントディレクトリ
	std::string current_dir {};

	// MPU 名
	std::string mpuname {};

	// ダブルバスフォールト・イベント
	void OnHaltNotify(wxCommandEvent& event);
	// メディア挿入失敗通知
	void OnInsertFailed(wxCommandEvent& event);

	WXMainView *mainview {};
	WXStatusPanel *statuspanel {};
	WXBitmapPanel *spaceL {};
	WXBitmapPanel *spaceR {};

	Keyboard *keyboard {};
	std::array<HostNetDevice *, 2> hostnet {};
	std::array<HostCOMDevice *, 3> hostcom {};
	HostCOMDevice *hostcom_dbg {};
	PowerDevice *power {};
	Syncer *syncer {};

	// 表示スケールの選択肢
	static std::vector<double> view_scales;

	// モニタの更新頻度(これが実行中の一次情報)
	static int monitor_rate;
	// モニタ更新頻度の選択肢
	static std::vector<int> monrates;

	wxDECLARE_EVENT_TABLE();
};
