//
// nono
// Copyright (C) 2023 nono project
// Licensed under nono-license.txt
//

//
// テストコード生成の共通サブルーチン
//

#include "optestxp_subr.h"
#include "mystring.h"

const char *testname;
int testpos;
std::vector<std::string> testlist;

// gentest の最初で行うことまとめ。
void
init(const char *testname_, const char *method)
{
	testname = testname_;
	testlist.push_back(testname);

	out("test_%s:\n", testname);
	out("	LD	HL,testset_%s\n", testname);
	out("	JP	%s\n", method);

	testpos = 0;
}

// テストセットのテーブルを出力。
void
out_testset()
{
	out("testset_%s:\n", testname);
	out("	defw	testname_%s\n", testname);
	out("	defw	testexec_%s\n", testname);
	out("	defw	testdata_%s\n", testname);
	out("	defb	%d\n", (strcmp(testname, "daa") == 0) ? 1 : 0);

	out("testname_%s:\n", testname);
	std::string upper = string_toupper(testname);
	out("	defm	\"%s $\"\n", upper.c_str());
	out("\n");
}

// testrun1 テスト用のデータテーブルを出力。
void
out_testdata_run1(uint32 dst, const hd64180flag& inflag,
	uint32 res, const hd64180flag& flag)
{
	if (testpos == 0) {
		out("testdata_%s:\n", testname);
	}
	out("	defb	0%02xH,0%02xH,0%02xH,0%02xH	; %s_%02x\n",
		dst, inflag.Get(), res, flag.Get(), testname, testpos);
	testpos++;
}

// testrun2 テスト用のデータテーブルを出力。
void
out_testdata_run2(uint32 dst, const hd64180flag& inflag, uint32 src,
	uint32 res, const hd64180flag& flag)
{
	if (testpos == 0) {
		out("testdata_%s:\n", testname);
	}
	out("	defb	0%02xH,0%02xH,0%02xH,0%02xH,0%02xH	; %s_%02x\n",
		dst, inflag.Get(), src, res, flag.Get(), testname, testpos);
	testpos++;
}

void
out(const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vprintf(fmt, ap);
	va_end(ap);
}
