//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// アラインされた配列
//

#pragma once

#include <stdlib.h>

template<typename T, std::size_t align>
class AlignedArray
{
 public:
	AlignedArray()
	{
	}

	explicit AlignedArray(std::size_t num_)
	{
		Alloc(num_);
	}

	~AlignedArray()
	{
		Reset();
	}

	// コピーコンストラクタ
	AlignedArray(const AlignedArray& src)
	{
		Reset(src.num);
		if (ptr) {
			memcpy(ptr, src.ptr, num * sizeof(T));
		}
	}
	// コピー代入演算子
	AlignedArray& operator=(const AlignedArray& src)
	{
		Reset(src.num);
		if (ptr) {
			memcpy(ptr, src.ptr, num * sizeof(T));
		}
		return *this;
	}

	void Reset()
	{
		free(ptr);
		ptr = NULL;
		num = 0;
	}

	bool Reset(std::size_t new_num)
	{
		if (new_num == num) {
			return true;
		}
		Reset();
		if (new_num == 0) {
			return true;
		}
		return Alloc(new_num);
	}

	T *get() const noexcept
	{
		return ptr;
	}

	explicit operator bool() const noexcept
	{
		return (ptr != NULL);
	}

 private:
	bool Alloc(std::size_t new_num)
	{
		assert(ptr == NULL);

		void *tmp;
		int r = posix_memalign(&tmp, align, new_num * sizeof(T));
		if (__predict_false(r != 0)) {
			return false;
		}
		ptr = reinterpret_cast<T*>(tmp);
		num = new_num;
		return true;
	}

	T *ptr {};
	std::size_t num {};
};
