#include <stdio.h>
#include <time.h>

void
X(struct tm& tm)
{
	printf("450007f8;l,80%02x%02x%02x\n",
		tm.tm_sec, tm.tm_min, tm.tm_hour);
	printf("450007fc;l,%02x%02x%02x%02x\n",
		tm.tm_wday, tm.tm_mday, tm.tm_mon, tm.tm_year);
	printf("450007f8;,0\n");
	printf("@1010\n");
	printf("450007f8\n");
	return;
}

// x が正常な BCD でかつ start <= x <= end ならば true
bool
BCDCheck(int x, int start, int end)
{
	int xh = (x >> 4) & 0xf;
	int xl = x & 0xf;

	if ((0 <= xh && xh <= 9) && (0 <= xl && xl <= 9)) {
		int v = xh * 10 + xl;
		return (start <= v && v <= end);
	}
	return false;
}


int
main(int ac, char *av[])
{
	struct tm tm {};

	// 0 リセット
	X(tm);

	// 秒テスト
	for (int i = 0; i <= 0x7f; i++) {
		if (BCDCheck(i, 0, 58)) {
			continue;
		}
		tm.tm_sec = i;
		X(tm);
	}
	tm.tm_sec = 0x59;

	// 分テスト
	for (int i = 0; i <= 0x7f; i++) {
		if (BCDCheck(i, 0, 58)) {
			continue;
		}
		tm.tm_min = i;
		X(tm);
	}
	tm.tm_min = 0x59;

	// 時テスト
	for (int i = 0; i <= 0x3f; i++) {
		if (BCDCheck(i, 0, 22)) {
			continue;
		}
		tm.tm_hour = i;
		X(tm);
	}
	tm.tm_hour = 0x23;

	// 曜日テスト
	for (int i = 0; i <= 7; i++) {
		tm.tm_wday = i;
		X(tm);
	}

	// 年月日テスト
	for (int y = 0; y <= 1; y++) {
		tm.tm_year = y;
		for (int m = 0; m <= 0x1f; m++) {
			tm.tm_mon = m;
			for (int d = 0; d <= 0x3f; d++) {
				if (BCDCheck(d, 2, 27)) {
					continue;
				}
				tm.tm_mday = d;
				X(tm);
			}
		}
	}
	return 0;
}
