//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// スレッドを持つデバイス
//

#pragma once

#include "device.h"
#include <mutex>
#include <thread>

class ThreadBase
{
 protected:
	enum class AffinityClass {
		Light,	// 処理の軽いスレッド
		Heavy,	// 処理の重いスレッド
	};

	// このスレッドのアフィニティを示唆する
	static void SetThreadAffinityHint(AffinityClass hint);
};

class ThreadDevice : public Device, public ThreadBase
{
	using inherited = Device;

 public:
	explicit ThreadDevice(uint objid_);
	~ThreadDevice() override;

	// スレッドを開始する
	virtual bool StartThread();

	// スレッドに終了を要求し、その終了を待つ
	void TerminateThread();

 protected:
	// オブジェクト名とスレッド名を設定する。
	void SetName(const std::string& newname) override;

	// スレッド名を設定する
	void SetThreadName(const std::string& threadname_);

	// スレッドエントリポイント
	virtual void ThreadRun() = 0;

	// スレッドに終了を指示する
	virtual void Terminate() = 0;

	std::unique_ptr<std::thread> thread {};

	// スレッド開始同期用
	std::mutex thread_starter {};

	// スレッド名
	std::string threadname {};
};
